/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.ftp;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Expression;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.ftp.FtpClientImpl;
import com.raqsoft.lib.ftp.SFtpClientImpl;
import com.raqsoft.resources.EngineMessage;

public class FtpClient
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        boolean sftp;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ftp_client" + mm.getMessage("function.missingParam"));
        }
        int size = this.param.getSubSize();
        String url = null;
        int port = 0;
        String user = "anonymous";
        String pwd = null;
        String option = this.option;
        if (option == null) {
            option = "";
        }
        int mode = option.indexOf("d") >= 0 ? 1 : 0;
        boolean bl = sftp = option.indexOf("s") >= 0;
        if (size == 0) {
            Expression exp = this.param.getLeafExpression();
            if (exp == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ws_client" + mm.getMessage("function.invalidParam"));
            }
            url = this.param.getLeafExpression().calculate(ctx).toString();
        } else {
            int i;
            char type = this.param.getType();
            if (type == ',') {
                i = 0;
                while (i < size) {
                    if (this.param.getSub(i) == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("ftp_client" + mm.getMessage("function.invalidParam"));
                    }
                    if (i == 0) {
                        char typei = this.param.getSub(i).getType();
                        if (typei == ':') {
                            url = this.param.getSub(i).getSub(0).getLeafExpression().calculate(ctx).toString();
                            port = Integer.parseInt(this.param.getSub(i).getSub(1).getLeafExpression().calculate(ctx).toString());
                        } else {
                            url = this.param.getSub(i).getLeafExpression().calculate(ctx).toString();
                        }
                    } else if (i == 1) {
                        user = (String)this.param.getSub(i).getLeafExpression().calculate(ctx);
                    } else if (i == 2) {
                        pwd = (String)this.param.getSub(i).getLeafExpression().calculate(ctx);
                    }
                    ++i;
                }
            } else if (type == ':') {
                i = 0;
                while (i < size) {
                    if (i == 0) {
                        url = this.param.getSub(i).getLeafExpression().calculate(ctx).toString();
                    } else if (i == 1) {
                        port = Integer.parseInt(this.param.getSub(i).getLeafExpression().calculate(ctx).toString());
                    }
                    ++i;
                }
            }
        }
        try {
            boolean succ;
            Table client;
            if (sftp) {
                client = new SFtpClientImpl(ctx, url, port, mode);
                succ = client.login(user, pwd);
                if (succ) {
                    ctx.addResource((IResource)client);
                }
                return client;
            }
            client = new FtpClientImpl(ctx, url, port, mode);
            succ = client.login(user, pwd);
            if (succ) {
                ctx.addResource((IResource)client);
            }
            return client;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

