/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.ftp;

import com.raqsoft.common.Logger;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.FileObject;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Table;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;

public class FtpClientImpl
extends Table
implements IResource {
    private FTPClient ftp = null;
    private Context ctx = null;
    private String info = "";
    private String dir = "/";
    private static String LOCAL_CHARSET = "GBK";
    private static String SERVER_CHARSET = "ISO-8859-1";

    public String toString() {
        return this.info;
    }

    public FtpClientImpl(Context ctx, String url, int port, int mode) throws Exception {
        this.ctx = ctx;
        this.info = String.valueOf(url) + ":" + port;
        this.ftp = new FTPClient();
        if (mode == 0) {
            this.ftp.enterLocalActiveMode();
        } else {
            this.ftp.enterLocalPassiveMode();
        }
        FTPClientConfig config = new FTPClientConfig();
        this.ftp.setDataTimeout(10000);
        this.ftp.setAutodetectUTF8(true);
        this.ftp.setControlEncoding("UTF-8");
        this.ftp.configure(config);
        if (port != 0) {
            this.ftp.connect(url, port);
        } else {
            this.ftp.connect(url);
        }
        FTPReply.isPositiveCompletion((int)this.ftp.sendCommand("OPTS UTF8", "ON"));
        Logger.debug((Object)("LOCAL_CHARSET \uff1a " + LOCAL_CHARSET));
    }

    public boolean login(String user, String password) throws Exception {
        this.info = String.valueOf(this.info) + "ftp:/" + user + ":" + password + ":" + this.info;
        boolean r = this.ftp.login(user, password);
        this.ftp.setFileType(2);
        Logger.debug((Object)("login : " + r));
        return r;
    }

    public boolean changeRemoteDir(String dir) throws Exception {
        String dir2 = dir;
        boolean r = this.ftp.changeWorkingDirectory(dir2);
        if (r) {
            Logger.debug((Object)("changeRemoteDir success : " + dir));
            this.dir = dir;
        } else {
            Logger.warn((Object)("changeRemoteDir \u201c" + dir + "\u201d failed, current remote dir is \u201c" + this.dir + "\u201d"));
        }
        return r;
    }

    public boolean mkdir(String dir) throws Exception {
        String dir2 = dir;
        boolean r = this.ftp.makeDirectory(dir2);
        if (r) {
            Logger.debug((Object)("mkdir success : " + dir));
        } else {
            Logger.warn((Object)("mkdir \u201c" + dir + "\u201d failed"));
        }
        return r;
    }

    public boolean put(String remoteFileName, InputStream in, boolean overwrite) throws Exception {
        Logger.debug((Object)("put [" + remoteFileName + "] begin"));
        String remoteFileName2 = remoteFileName;
        String status = this.ftp.getStatus(remoteFileName2);
        if (status != null) {
            if (overwrite) {
                this.ftp.deleteFile(remoteFileName2);
            } else {
                Logger.warn((Object)("remote file [" + this.dir + "/" + remoteFileName + "] has exist"));
                return false;
            }
        }
        boolean r = this.ftp.appendFile(remoteFileName2, in);
        return r;
    }

    public boolean get(String remoteFileName, FileObject localFile, boolean overwrite) throws Exception {
        Logger.debug((Object)("get [" + remoteFileName + "] begin"));
        String remoteFileName2 = remoteFileName;
        if (localFile.getLocalFile().file().exists()) {
            if (overwrite) {
                localFile.getLocalFile().file().delete();
            } else {
                Logger.warn((Object)("local file [" + localFile.getLocalFile().file() + "] has exist"));
                return false;
            }
        }
        OutputStream os = localFile.getOutputStream(false);
        boolean r = this.ftp.retrieveFile(remoteFileName2, os);
        os.flush();
        os.close();
        Logger.debug((Object)("get [" + remoteFileName + "] to local [" + localFile.getLocalFile().file().getAbsolutePath() + "]" + (r ? "success" : "failed")));
        return r;
    }

    public void close() {
        try {
            this.ftp.disconnect();
            this.ftp = null;
            this.ctx.removeResource((IResource)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            FtpClientImpl fc = new FtpClientImpl(null, "192.168.0.175", 21, 1);
            fc.login("iudean", "2");
            fc.changeRemoteDir("/");
            FileObject localFile = new FileObject("d:/aa2.txt");
            fc.get("aa.txt", localFile, true);
        }
        catch (Exception e) {
            Logger.error((Object)"", (Throwable)e);
            e.printStackTrace();
        }
    }
}

