/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.ftp;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.FileObject;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.ftp.FtpClientImpl;
import com.raqsoft.lib.ftp.SFtpClientImpl;
import com.raqsoft.resources.EngineMessage;

public class FtpGet
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ftp_get" + mm.getMessage("function.missingParam"));
        }
        int size = this.param.getSubSize();
        if (size != 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ftp_get" + mm.getMessage("function.invalidParam"));
        }
        FtpClientImpl client = null;
        SFtpClientImpl sclient = null;
        String remote = null;
        FileObject localFile = null;
        boolean overwrite = this.option != null && this.option.indexOf("f") >= 0;
        int i = 0;
        while (i < size) {
            Object o;
            if (this.param.getSub(i) == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ftp_get" + mm.getMessage("function.invalidParam"));
            }
            if (i == 0) {
                o = this.param.getSub(i).getLeafExpression().calculate(ctx);
                if (o instanceof FtpClientImpl) {
                    client = (FtpClientImpl)((Object)o);
                } else {
                    if (!(o instanceof SFtpClientImpl)) throw new RQException("first parameter is not ftp_client");
                    sclient = (SFtpClientImpl)((Object)o);
                }
            } else if (i == 1) {
                remote = (String)this.param.getSub(i).getLeafExpression().calculate(ctx);
            } else if (i == 2) {
                o = this.param.getSub(i).getLeafExpression().calculate(ctx);
                if (o instanceof String) {
                    localFile = new FileObject(o.toString());
                } else {
                    if (!(o instanceof FileObject)) throw new RQException("The third parameter must be a string file path or a file object");
                    localFile = (FileObject)o;
                }
            }
            ++i;
        }
        boolean r = false;
        try {
            r = client != null ? client.get(remote, localFile, overwrite) : sclient.get(remote, localFile.getLocalFile().file().getAbsolutePath());
            return "get remote file [" + remote + "] " + (r ? "success" : "failed");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RQException("ftp_get : " + e.getMessage());
        }
    }
}

