/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.ftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.raqsoft.common.Logger;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Table;
import java.util.Properties;

public class SFtpClientImpl
extends Table
implements IResource {
    private Session session = null;
    private Channel channel = null;
    private Context ctx = null;
    private String url = null;
    private int port = 0;
    private int mode = 0;
    private String ftpPath = "/";
    private ChannelSftp chSftp = null;

    public SFtpClientImpl(Context ctx, String url, int port, int mode) throws Exception {
        this.ctx = ctx;
        this.url = url;
        this.port = port;
        this.mode = mode;
    }

    public boolean login(String user, String password) throws Exception {
        JSch jsch = new JSch();
        this.session = jsch.getSession(user, this.url, this.port);
        this.session.setPassword(password);
        this.session.setTimeout(100000);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
        this.channel = this.session.openChannel("sftp");
        this.channel.connect();
        this.chSftp = (ChannelSftp)this.channel;
        Logger.debug((Object)"login : true");
        return true;
    }

    public boolean changeRemoteDir(String dir) throws Exception {
        this.ftpPath = dir;
        return true;
    }

    public boolean put(String remoteFileName, String localPath) throws Exception {
        Logger.debug((Object)("put [" + remoteFileName + "] begin"));
        ChannelSftp chSftp = (ChannelSftp)this.channel;
        String ftpFilePath = String.valueOf(this.ftpPath) + "/" + remoteFileName;
        try {
            chSftp.put(localPath, ftpFilePath);
            Logger.debug((Object)("put [" + remoteFileName + "] success"));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.debug((Object)("put [" + remoteFileName + "] failed"));
            return false;
        }
    }

    public boolean get(String remoteFileName, String localPath) throws Exception {
        Logger.debug((Object)("get [" + remoteFileName + "] begin"));
        String ftpFilePath = String.valueOf(this.ftpPath) + "/" + remoteFileName;
        try {
            this.chSftp.get(ftpFilePath, localPath);
            Logger.debug((Object)("get [" + remoteFileName + "] success"));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.debug((Object)("get [" + remoteFileName + "] failed"));
            return false;
        }
    }

    public void close() {
        try {
            this.chSftp.quit();
            this.channel.disconnect();
            this.session.disconnect();
            this.ctx.removeResource((IResource)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            SFtpClientImpl fc = new SFtpClientImpl(null, "123.57.218.190", 22, 1);
            fc.login("root", "Carrygame888");
            fc.changeRemoteDir("/");
            fc.put("/var/secure", "d:/ftp/secure");
            fc.close();
        }
        catch (Exception e) {
            Logger.error((Object)"", (Throwable)e);
            e.printStackTrace();
        }
    }
}

