/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseTestCaseOK {
    private static HBaseConfiguration hbaseConfig = null;
    private static HConnection hConn = null;

    static {
        System.getProperties().setProperty("HADOOP_USER_NAME", "etl");
        System.getProperties().setProperty("HADOOP_GROUP_NAME", "etl");
        Configuration config = HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", "192.168.0.76");
        config.setInt("hbase.client.retries.number", 5);
        try {
            hConn = HConnectionManager.createConnection((Configuration)config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Result getData(String tableName, String rowkey) {
        try {
            HTableInterface table = hConn.getTable(tableName);
            Get get = new Get(rowkey.getBytes());
            return table.get(get);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void format(Result result) {
        KeyValue[] kvs;
        String rowkey = Bytes.toString((byte[])result.getRow());
        KeyValue[] keyValueArray = kvs = result.raw();
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            String family = Bytes.toString((byte[])kv.getFamily());
            String qualifier = Bytes.toString((byte[])kv.getQualifier());
            System.out.println("rowkey->" + rowkey + " family->" + family + " qualifier->" + qualifier + " val->" + Bytes.toString((byte[])kv.getValue()));
            ++n2;
        }
    }

    public static void zookeeperTest() {
        Configuration conf = HBaseConfiguration.create();
        System.setProperty("hadoop.home.dir", "D:\\installer\\work\\hadoop\\");
        conf.set("hbase.zookeeper.quorum", "59.212.226.3,59.212.226.4,59.212.226.5");
        conf.set("hbase.zookeeper.property.clientPort", "2181");
        conf.set("hbase.master", "59.212.226.2:8020");
        try {
            hConn = HConnectionManager.createConnection((Configuration)conf);
            if (hConn != null) {
                System.out.println("Hbase init successful");
            }
            String tableName = "hbasetb_test";
            HTableInterface table = hConn.getTable(tableName);
            Get get = new Get("1000".getBytes());
            Result r = table.get(get);
            HBaseTestCaseOK.format(r);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Result r = HBaseTestCaseOK.getData("test", "2");
        HBaseTestCaseOK.format(r);
    }

    public static void selectByRowKey(String tablename, String rowKey) throws IOException {
        HTable table = new HTable((Configuration)hbaseConfig, tablename);
        Get g = new Get(Bytes.toBytes((String)rowKey));
        Result r = table.get(g);
        KeyValue[] keyValueArray = r.raw();
        int n = keyValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            System.out.println("getRow: " + new String(kv.getRow()));
            System.out.println("getFamily: " + new String(kv.getFamily()));
            System.out.println("getQualifier: " + new String(kv.getQualifier()));
            System.out.println("value: " + new String(kv.getValue()));
            ++n2;
        }
    }
}

