/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Sequence;
import com.raqsoft.dm.Table;
import com.raqsoft.dm.cursor.ICursor;
import com.raqsoft.lib.hbase1_3_0.HbaseDriverCli;
import com.raqsoft.lib.hbase1_3_0.function.TableInfo;

public class HbaseCursor
extends ICursor {
    private HbaseDriverCli client;
    private Context ctx;
    private TableInfo m_tbInfo;
    private boolean bEnd = false;

    public HbaseCursor(HbaseDriverCli client, Context ctx, TableInfo tbInfo) {
        this.client = client;
        this.ctx = ctx;
        this.m_tbInfo = tbInfo;
        ctx.addResource((IResource)this);
    }

    protected int skipOver(int n) {
        int count = this.client.skipOver(n);
        if (count < n) {
            this.close();
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        try {
            if (this.client != null) {
                this.ctx.removeResource((IResource)this);
                this.client.close();
                this.client = null;
                this.ctx = null;
            }
            this.bEnd = true;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    public Sequence get(int n) {
        Table table = this.client.getTable(n, this.m_tbInfo);
        if (table == null) {
            this.close();
            return null;
        }
        if (table.length() < n && n < 99999) {
            this.close();
        }
        return table;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isEnd() {
        return this.bEnd;
    }
}

