/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Table;
import com.raqsoft.dm.cursor.ICursor;
import com.raqsoft.lib.hbase1_3_0.HbaseCursor;
import com.raqsoft.lib.hbase1_3_0.function.HbaseQuery;
import com.raqsoft.lib.hbase1_3_0.function.TableInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseDriverCli
implements IResource {
    public Configuration conf = null;
    public HConnection hConn = null;
    ResultScanner m_scanner;
    HTableInterface m_table;

    public HbaseDriverCli(Context ctx, String rootDir, String zkServer) {
        if (rootDir.indexOf("hdfs://") != -1) {
            this.conf = HBaseConfiguration.create();
            this.conf.set("hbase.rootdir", rootDir);
            this.conf.set("hbase.zookeeper.quorum", zkServer);
        } else {
            String[] ls = rootDir.split(":");
            if (ls.length != 2) {
                return;
            }
            System.getProperties().setProperty("HADOOP_USER_NAME", ls[0]);
            System.getProperties().setProperty("HADOOP_GROUP_NAME", ls[1]);
            System.out.println(zkServer);
            this.conf = HBaseConfiguration.create();
            this.conf.set("hbase.zookeeper.quorum", zkServer);
            this.conf.setInt("hbase.client.retries.number", 5);
        }
        try {
            this.hConn = HConnectionManager.createConnection((Configuration)this.conf);
            if (this.hConn != null) {
                System.out.println("Hbase init successful");
                ctx.addResource((IResource)this);
            } else {
                System.out.println("Hbase init false");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            System.out.println("HbaseDriverCli quit....");
            if (this.m_scanner != null) {
                this.m_scanner.close();
                this.m_scanner = null;
            }
            if (this.m_table != null) {
                this.m_table.close();
                this.m_table = null;
            }
            if (this.hConn != null) {
                this.hConn.close();
                this.hConn = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void crateTable(String tableName, List<String> cols) {
        try {
            HBaseAdmin admin = new HBaseAdmin(this.hConn.getConfiguration());
            if (admin.tableExists(tableName)) {
                throw new IOException("table exists");
            }
            HTableDescriptor tableDesc = new HTableDescriptor(tableName);
            for (String col : cols) {
                HColumnDescriptor colDesc = new HColumnDescriptor(col);
                colDesc.setCompressionType(Compression.Algorithm.GZ);
                colDesc.setDataBlockEncoding(DataBlockEncoding.DIFF);
                tableDesc.addFamily(colDesc);
            }
            admin.createTable(tableDesc);
        }
        catch (MasterNotRunningException e) {
            e.printStackTrace();
        }
        catch (ZooKeeperConnectionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveData(String tableName, List<Put> puts) {
        try {
            HTableInterface table = this.hConn.getTable(tableName);
            table.put(puts);
            table.setAutoFlush(false);
            table.flushCommits();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Result getData(String tableName, String rowkey) {
        try {
            HTableInterface table = this.hConn.getTable(tableName);
            Get get = new Get(rowkey.getBytes());
            return table.get(get);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void format(Result result) {
        KeyValue[] kvs;
        String rowkey = Bytes.toString((byte[])result.getRow());
        KeyValue[] keyValueArray = kvs = result.raw();
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            String family = Bytes.toString((byte[])kv.getFamily());
            String qualifier = Bytes.toString((byte[])kv.getQualifier());
            System.out.println("rowkey->" + rowkey + " family->" + family + " qualifier->" + qualifier + " val->" + Bytes.toString((byte[])kv.getValue()));
            ++n2;
        }
    }

    public void hbaseScan(String tableName) {
        Scan scan = new Scan();
        scan.setCaching(1000);
        try {
            HTableInterface table = this.hConn.getTable(tableName);
            ResultScanner scanner = table.getScanner(scan);
            for (Result res : scanner) {
                this.format(res);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void doRegexStringComparator(String tableName) {
        byte[] cf = Bytes.toBytes((String)"company");
        byte[] column = Bytes.toBytes((String)"name");
        byte[] column2 = Bytes.toBytes((String)"position");
        byte[] row1 = Bytes.toBytes((String)"row1");
        FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        SubstringComparator comp = new SubstringComparator("as");
        SingleColumnValueFilter filter1 = new SingleColumnValueFilter(cf, column, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)comp);
        list.addFilter((Filter)filter1);
        Scan scan = new Scan();
        scan.setFilter((Filter)list);
        try {
            HTableInterface table = this.hConn.getTable(tableName);
            ResultScanner scanner = table.getScanner(scan);
            for (Result res : scanner) {
                this.format(res);
                System.out.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ICursor queryRange(Context ctx, Scan scan, TableInfo tbInfo) {
        try {
            this.m_table = this.hConn.getTable(tbInfo.m_tableName);
            if (this.m_table == null) {
                throw new RQException("hbaseScan table: " + tbInfo.m_tableName + " is existed");
            }
            this.m_scanner = this.m_table.getScanner(scan);
            if (this.m_scanner == null) {
                throw new RQException("hbaseScan table: " + tbInfo.m_tableName + " resultScanner is null");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new HbaseCursor(this, ctx, tbInfo);
    }

    public int skipOver(int n) {
        int count;
        block4: {
            count = 0;
            if (this.m_scanner != null && n != 0) break block4;
            return 0;
        }
        try {
            Iterator itr = this.m_scanner.iterator();
            while (itr.hasNext() && ++count < n) {
                itr.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public Table getTable(int n, TableInfo tbInfo) {
        Table tb = null;
        if (this.m_scanner == null || n < 1) {
            return tb;
        }
        try {
            int nCnt = n;
            if (n > 99999) {
                nCnt = 99999;
            }
            tb = HbaseQuery.toTable(this.m_scanner, tbInfo, n);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tb;
    }
}

