/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.Sequence;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.IParam;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.hbase1_3_0.function.Utils;
import com.raqsoft.resources.EngineMessage;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.util.Bytes;

public class Comparator
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        String option = this.getOption();
        if (option != null && option.equals("n")) {
            return new NullComparator();
        }
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("comparator param is null ");
        }
        int size = param.getSubSize();
        System.out.println("comparator option= " + option + " size = " + size);
        if (size == 0) {
            Object obj = param.getLeafExpression().calculate(ctx);
            System.out.println("comparator Object= " + obj);
            if (option == null) {
                return new BinaryComparator(((String)obj).getBytes());
            }
            if (option.compareTo("p") == 0) {
                return new BinaryPrefixComparator(((String)obj).getBytes());
            }
            if (option.compareTo("s") == 0) {
                return new SubstringComparator((String)obj);
            }
            if (option.compareTo("l") == 0) {
                return new LongComparator(Utils.objectToLong(obj));
            }
            if (option.compareTo("r") == 0) {
                return new RegexStringComparator((String)obj);
            }
            throw new RQException("comparator " + option + " param is not support");
        }
        if (size == 2) {
            Object obj0 = null;
            Object obj1 = null;
            if (option.equals("r")) {
                obj0 = Utils.checkValidDataType(param.getSub(0), ctx, "String");
                if (obj0 == null || (obj1 = Utils.checkValidDataType(param.getSub(1), ctx, "String")) == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("comparator param1 " + mm.getMessage("function.invalidParam"));
                }
                int nPatten = Utils.getRegexPattern((String)obj1);
                return new RegexStringComparator((String)obj0, nPatten);
            }
            if (option.equals("b")) {
                obj1 = Utils.checkValidDataType(param.getSub(1), ctx, "String");
                if (obj1 == null) {
                    throw new RQException("bitcomparator param 2 function.invalidParam");
                }
                try {
                    obj0 = Utils.checkValidDataType(param.getSub(0), ctx, "Sequence");
                    if (obj0 != null) {
                        int[] nt = ((Sequence)obj0).toIntArray();
                        byte[] bt = new byte[nt.length];
                        int j = 0;
                        while (j < nt.length) {
                            bt[j] = (byte)nt[j];
                            ++j;
                        }
                        return new BitComparator(bt, Utils.GetBitwiseOp((String)obj1));
                    }
                    obj0 = Utils.checkValidDataType(param.getSub(0), ctx, "String");
                    if (obj0 != null) {
                        String s = (String)obj0;
                        return new BitComparator(Bytes.toBytes((String)s), Utils.GetBitwiseOp((String)obj1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static ByteArrayComparable getComparator(String comparatorName, Object param) {
        RegexStringComparator comp = null;
        if (comparatorName.compareToIgnoreCase("RegexStringComparator") == 0) {
            comp = new RegexStringComparator((String)param);
        } else if (comparatorName.compareToIgnoreCase("SubstringComparator") == 0) {
            comp = new SubstringComparator((String)param);
        } else if (comparatorName.compareToIgnoreCase("BinaryPrefixComparator") == 0) {
            comp = new BinaryPrefixComparator(((String)param).getBytes());
        } else if (comparatorName.compareToIgnoreCase("BinaryComparator") == 0) {
            comp = new BinaryComparator(((String)param).getBytes());
        } else if (comparatorName.compareToIgnoreCase("LongComparator") == 0) {
            if (param instanceof Long) {
                comp = new LongComparator(((Long)param).longValue());
            }
        } else if (comparatorName.compareToIgnoreCase("nullComparator") == 0) {
            comp = new NullComparator();
        } else if (comparatorName.compareToIgnoreCase("bitComparator") == 0) {
            comp = new BitComparator(((String)param).getBytes(), BitComparator.BitwiseOp.AND);
        }
        return comp;
    }
}

