/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.IParam;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.hbase1_3_0.function.ParseFilter;
import com.raqsoft.lib.hbase1_3_0.function.Utils;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;

public class HbaseFilter
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        if (param == null) {
            throw new RQException("hbase filter param is null");
        }
        int size = param.getSubSize();
        String filterName = "";
        Object obj = null;
        if (size == 0) {
            obj = Utils.checkValidDataType(param, ctx, "String");
            if (obj == null) {
                throw new RQException("Filter param: " + obj + " is unvalid");
            }
            filterName = (String)obj;
            if (filterName.compareToIgnoreCase("FirstKeyOnlyFilter") == 0) {
                return new FirstKeyOnlyFilter();
            }
            if (filterName.compareToIgnoreCase("KeyOnlyFilter") == 0) {
                return new KeyOnlyFilter();
            }
            throw new RQException("FilterName: " + filterName + " is not existed");
        }
        ParseFilter pf = new ParseFilter(ctx, param);
        Object o = pf.calculate();
        return o;
    }
}

