/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.hbase1_3_0.HbaseDriverCli;
import com.raqsoft.lib.hbase1_3_0.function.HbaseQuery;
import com.raqsoft.lib.hbase1_3_0.function.OprationType;
import com.raqsoft.lib.hbase1_3_0.function.TableInfo;
import com.raqsoft.lib.hbase1_3_0.function.Utils;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseGet
extends HbaseQuery {
    @Override
    public Node optimize(Context ctx) {
        super.optimize(ctx);
        if (this.m_tableInfo == null) {
            this.m_tableInfo = new TableInfo(OprationType.OPRATION_GET);
        }
        return this;
    }

    @Override
    public Object calculate(Context ctx) {
        try {
            return super.calculate(ctx);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void hbaseGet(HConnection hConn, String tableName, String family, String column, String rowKey, Filter filter, int maxVersions, long minStamp, long maxStamp, long timestamp) {
        Get get = new Get(rowKey.getBytes());
        if (filter != null) {
            get.setFilter(filter);
        }
        boolean bAddFamily = false;
        if (column != null && !column.isEmpty() && family != null && !family.isEmpty()) {
            bAddFamily = true;
            get.addColumn(family.getBytes(), column.getBytes());
        }
        if (!bAddFamily && family != null && !family.isEmpty()) {
            get.addFamily(family.getBytes());
        }
        try {
            HTableInterface table = hConn.getTable(tableName);
            Result res = table.get(get);
            HbaseGet.format(res);
            System.out.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Table hbaseQuery(Object[] obj) throws IOException {
        Table tb = null;
        try {
            if (obj.length != 3) {
                throw new RQException("hbaseGet hbaseQuery tableName or rowKey is not right");
            }
            HbaseDriverCli client = (HbaseDriverCli)obj[0];
            if (client == null) {
                throw new RQException("hbaseGet hbaseQuery HbaseDriverCli is null");
            }
            HConnection hConn = client.hConn;
            if (hConn == null) {
                throw new RQException("hbaseGet hbaseQuery hConn is null");
            }
            String rowKey = (String)obj[2];
            Get get = new Get(rowKey.getBytes());
            HTableInterface table = hConn.getTable((String)obj[1]);
            Result res = table.get(get);
            tb = this.toTable(res);
            table.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tb;
    }

    public Table toTable(Result result) {
        String rowkey = Bytes.toString((byte[])result.getRow());
        String fullName = "rowkey:";
        KeyValue[] kvs = result.raw();
        ArrayList<String> list = new ArrayList<String>();
        list.add(rowkey);
        KeyValue[] keyValueArray = kvs;
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            String family = Bytes.toString((byte[])kv.getFamily());
            String column = Bytes.toString((byte[])kv.getQualifier());
            if (column.compareTo("_0") != 0) {
                fullName = String.valueOf(fullName) + family + "_" + column + ":";
                list.add(Bytes.toString((byte[])kv.getValue()));
            }
            ++n2;
        }
        fullName = fullName.substring(0, fullName.length() - 1);
        String[] ary = fullName.split(":");
        System.out.println("fullName = " + ary.length + " list=" + list.size());
        Table table = new Table(ary);
        table.newLast(list.toArray());
        return table;
    }

    public Table doHbaseQuery(TableInfo tb) throws IOException {
        if (tb == null) {
            throw new RQException("hbaseGet param tableInfo is null");
        }
        if (tb.m_connect == null) {
            throw new RQException("hbaseGet param connect is null");
        }
        if (tb.m_rowkey == null || tb.m_rowkey.isEmpty()) {
            throw new RQException("hbaseGet param rowkey is empty");
        }
        if (tb.m_tableName == null || tb.m_tableName == "") {
            throw new RQException("hbaseGet param tableName is empty");
        }
        int size = tb.m_family.size();
        if (size == 0) {
            throw new RQException("hbaseGet param family is empty");
        }
        if (tb.m_column.size() != size) {
            throw new RQException("hbaseGet param column is not right");
        }
        if (tb.m_columnType.size() != size) {
            throw new RQException("hbaseGet param columnType is not right");
        }
        if (tb.m_columnAlias.size() != size) {
            throw new RQException("hbaseGet param columnAlias is not right");
        }
        Get get = new Get(tb.m_rowkey.getBytes());
        if (tb.m_filter != null) {
            get.setFilter(tb.m_filter);
        }
        if (tb.m_version > 0) {
            get.setMaxVersions(tb.m_version);
        }
        if (tb.m_minTimeStamp > 0L && tb.m_maxTimeStamp > 0L) {
            get.setTimeRange(tb.m_minTimeStamp, tb.m_maxTimeStamp);
        }
        if (tb.m_timeStamp > 0L) {
            get.setTimeStamp(tb.m_timeStamp);
        }
        int i = 0;
        while (i < size) {
            get.addColumn(tb.m_family.get(i).getBytes(), tb.m_column.get(i).getBytes());
            ++i;
        }
        Table tbl = null;
        try {
            HbaseDriverCli client = (HbaseDriverCli)tb.m_connect;
            HTableInterface table = client.hConn.getTable(tb.m_tableName);
            Result res = table.get(get);
            tbl = HbaseGet.toTable(res, tb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tbl;
    }

    static Table toTable(Result res, TableInfo tb) {
        if (res == null) {
            throw new RQException("toTable param res is not null");
        }
        if (tb == null) {
            throw new RQException("toTable param TableInfo is not null");
        }
        int colSize = 0;
        Object[] objs = null;
        colSize = tb.m_columnAlias.size() + 1;
        Table table = HbaseGet.createTable(tb);
        if (table == null) {
            throw new RQException("toTable param create table false");
        }
        if (res.size() == 0) {
            return table;
        }
        String sAliasKey = "";
        String rowkey = Bytes.toString((byte[])res.getRow());
        objs = new Object[colSize];
        objs[0] = rowkey;
        Record r = table.newLast(objs);
        KeyValue[] kvs = res.raw();
        int nCol = 0;
        KeyValue[] keyValueArray = kvs;
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            String family = Bytes.toString((byte[])kv.getFamily());
            String column = Bytes.toString((byte[])kv.getQualifier());
            if (column.compareTo("_0") != 0) {
                String fullName = String.valueOf(family) + "_" + column;
                sAliasKey = tb.m_columnAlias.get(fullName);
                objs[0] = Utils.getDataType(tb, fullName, Bytes.toString((byte[])kv.getValue()));
                r.set(sAliasKey, objs[0]);
                ++nCol;
            }
            ++n2;
        }
        return table;
    }

    private static Table createTable(TableInfo tb) {
        if (tb == null) {
            throw new RQException("createTable tableInfo is null");
        }
        String[] colNames = null;
        int colSize = tb.m_columnAlias.size() + 1;
        colNames = new String[colSize];
        colNames[0] = "rowkey";
        int i = 1;
        for (String val : tb.m_columnAlias.values()) {
            colNames[i++] = val;
        }
        return new Table(colNames, colSize);
    }
}

