/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Expression;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.IParam;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.hbase1_3_0.HbaseDriverCli;
import com.raqsoft.lib.hbase1_3_0.function.OprationType;
import com.raqsoft.lib.hbase1_3_0.function.TableInfo;
import com.raqsoft.lib.hbase1_3_0.function.Utils;
import com.raqsoft.resources.EngineMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseQuery
extends Function {
    protected TableInfo m_tableInfo = null;
    protected CheckType m_chkType;
    protected String m_tmpColumnName;
    protected Context m_ctx;

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        this.m_ctx = ctx;
        IParam param = this.param;
        try {
            if (param == null || param.getSubSize() < 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("hbase calculate" + mm.getMessage(Integer.toString(param.getSubSize())));
            }
            int size = param.getSubSize();
            if (param.getType() == ';') {
                ArrayList<Expression> list1 = new ArrayList<Expression>();
                ArrayList<Expression> list2 = new ArrayList<Expression>();
                param.getSub(0).getAllLeafExpression(list1);
                param.getSub(1).getAllLeafExpression(list2);
                this.m_tableInfo.reset();
                this.doTableColumn(ctx, list1);
                this.doTableParam(ctx, list2);
                return this.doHbaseQuery(this.m_tableInfo);
            }
            if (param.getType() == ',') {
                System.out.println("querySize = " + size + " type = " + (Object)((Object)this.m_tableInfo.m_oprationType));
                if (size == 2 && this.m_tableInfo.m_oprationType == OprationType.OPRATION_SCAN || size == 3 && this.m_tableInfo.m_oprationType == OprationType.OPRATION_GET) {
                    Object[] obj = new Object[size];
                    int i = 0;
                    while (i < size) {
                        obj[i] = param.getSub(i).getLeafExpression().calculate(ctx);
                        ++i;
                    }
                    return this.doHbaseQuery(obj);
                }
                if (size != 3 || this.m_tableInfo.m_oprationType != OprationType.OPRATION_GET) {
                    this.doTableColumn(ctx, param);
                    return this.doHbaseQuery(this.m_tableInfo);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object doHbaseQuery(TableInfo tb) throws IOException {
        return null;
    }

    public Scan hbaseScanInfo(TableInfo tb) throws IOException {
        if (tb == null) {
            throw new RQException("hbaseScan param tableInfo is null");
        }
        if (tb.m_connect == null) {
            throw new RQException("hbaseScan param connect is null");
        }
        if (tb.m_tableName == null || tb.m_tableName == "") {
            throw new RQException("hbaseScan param tableName is empty");
        }
        int size = tb.m_family.size();
        if (tb.m_column.size() != size) {
            throw new RQException("hbaseScan param column " + tb.m_column.size() + " is " + size);
        }
        if (tb.m_columnType.size() != size) {
            throw new RQException("hbaseScan param columnType " + tb.m_columnType.size() + " is " + size);
        }
        if (tb.m_columnAlias.size() != size) {
            throw new RQException("hbaseScan param columnAlias " + tb.m_columnType.size() + " is " + size);
        }
        Scan scan = new Scan();
        if (tb.m_filter != null) {
            scan.setFilter(tb.m_filter);
        }
        if (tb.m_limit > 0) {
            System.out.println("scan setCaching limit = " + tb.m_limit);
            this.scanSetLimit(scan, tb.m_limit);
        }
        if (tb.m_rowPrefix != null && !tb.m_rowPrefix.isEmpty()) {
            scan.setRowPrefixFilter(tb.m_rowPrefix.getBytes());
        }
        if (tb.m_startRow != null && !tb.m_startRow.isEmpty()) {
            scan.setStartRow(tb.m_startRow.getBytes());
        }
        if (tb.m_stopRow != null && !tb.m_stopRow.isEmpty()) {
            scan.setStopRow(tb.m_stopRow.getBytes());
        }
        if (tb.m_version > 0) {
            scan.setMaxVersions(tb.m_version);
        }
        if (tb.m_minTimeStamp > 0L && tb.m_maxTimeStamp > 0L) {
            scan.setTimeRange(tb.m_minTimeStamp, tb.m_maxTimeStamp);
        }
        if (tb.m_timeStamp > 0L) {
            scan.setTimeStamp(tb.m_timeStamp);
        }
        int i = 0;
        while (i < size) {
            scan.addColumn(tb.m_family.get(i).getBytes(), tb.m_column.get(i).getBytes());
            ++i;
        }
        return scan;
    }

    private void scanSetLimit(Scan scan, int limit) {
        try {
            Method[] m = null;
            if (Utils.checkFunctionExisted(scan.getClass(), "setLimit", m)) {
                m[0].invoke(scan.getClass(), limit);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Object doHbaseQuery(Object[] obj) throws IOException {
        return null;
    }

    public Object hbaseQuery(Object[] obj) throws IOException {
        try {
            if (obj.length != 2) {
                throw new RQException("hbaseScan hbaseQuery tableName or rowKey is not right");
            }
            HbaseDriverCli client = (HbaseDriverCli)obj[0];
            if (client == null) {
                throw new RQException("hbaseScan hbaseQuery HbaseDriverCli is null");
            }
            HConnection hConn = client.hConn;
            if (hConn == null) {
                throw new RQException("hbaseScan hbaseQuery hConn is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void doTableParam(Context ctx, ArrayList<Expression> list) {
        int size = list.size();
        if (size % 2 == 1) {
            throw new RQException("scan params not map key structure");
        }
        int i = 0;
        while (i < size) {
            String key = list.get(i).toString();
            String v = list.get(i + 1).toString();
            if (key.compareToIgnoreCase("filter") == 0) {
                Object val = list.get(i + 1).calculate(ctx);
                Filter f = (Filter)val;
                this.m_tableInfo.setFilter(f);
            } else if (key.compareToIgnoreCase("rowPrefix") == 0) {
                this.m_tableInfo.setRowPrefixFilter(v);
            } else if (key.compareToIgnoreCase("limit") == 0) {
                this.m_tableInfo.setLimit(Integer.parseInt(v));
            } else if (key.compareToIgnoreCase("version") == 0) {
                this.m_tableInfo.setVersion(Integer.parseInt(v));
            } else if (key.compareToIgnoreCase("startRow") == 0) {
                this.m_tableInfo.setStartRow(v);
            } else if (key.compareToIgnoreCase("stopRow") == 0) {
                this.m_tableInfo.setStopRow(v);
            } else if (key.compareToIgnoreCase("timeRange") == 0) {
                String ss = v.replace("[", "");
                ss = ss.replace("]", "");
                ss = ss.replace(" ", "");
                String[] ls = (ss = ss.replace("\t", "")).split(",");
                if (ls[0] != null && ls[0] != "") {
                    this.m_tableInfo.setMinTimeStamp(Utils.objectToLong(ls[0]));
                }
                if (ls[1] != null && ls[1] != "") {
                    this.m_tableInfo.setMaxTimeStamp(Utils.objectToLong(ls[1]));
                }
            } else if (key.compareToIgnoreCase("timeStamp") == 0) {
                this.m_tableInfo.setTimeStamp(Utils.objectToLong(v));
            }
            i += 2;
        }
    }

    protected void doTableColumn(Context ctx, ArrayList<Expression> list) {
        int size = list.size();
        Object obj = new Object();
        this.m_chkType = CheckType.CHECK_TABLE;
        Matcher[] m = new Matcher[1];
        int i = 0;
        while (i < size) {
            if (list.get(i) != null) {
                String ss = list.get(i).getIdentifierName();
                String s = ss.replace("\"", "");
                if (Utils.isRegExpMatch(s, "(\\w+):(\\w+)", m)) {
                    this.m_chkType = CheckType.CHECK_COLUMN;
                }
                if (this.m_chkType == CheckType.CHECK_TABLE) {
                    obj = list.get(i).calculate(ctx);
                    if (i == 0) {
                        this.m_tableInfo.setConnect(obj);
                    } else if (i == 1) {
                        this.m_tableInfo.setTableName((String)obj);
                        if (this.m_tableInfo.m_oprationType == OprationType.OPRATION_SCAN) {
                            this.m_chkType = CheckType.CHECK_COLUMN;
                        }
                    } else if (i == 2) {
                        if (this.m_tableInfo.m_oprationType == OprationType.OPRATION_SCAN) {
                            throw new RQException("scan params not rowkey after tableName");
                        }
                        this.m_tableInfo.setRowkey((String)obj);
                        if (this.m_tableInfo.m_oprationType == OprationType.OPRATION_GET) {
                            this.m_chkType = CheckType.CHECK_COLUMN;
                        }
                    }
                } else if (this.m_chkType == CheckType.CHECK_COLUMN) {
                    this.parseFamilyColumn(m);
                } else if (this.m_chkType == CheckType.CHECK_TYPE) {
                    if (Utils.checkColumnType(this.m_tableInfo, this.m_tmpColumnName, s)) {
                        this.m_chkType = CheckType.CHECK_ALIAS;
                    }
                } else if (this.m_chkType == CheckType.CHECK_ALIAS) {
                    this.m_tableInfo.setColumnAlias(this.m_tmpColumnName, s);
                    this.m_chkType = CheckType.CHECK_COLUMN;
                }
            } else {
                this.m_tableInfo.setColumnType(this.m_tmpColumnName, "type");
                this.m_chkType = CheckType.CHECK_ALIAS;
            }
            ++i;
        }
    }

    protected void doTableColumn(Context ctx, IParam param) {
        int size = param.getSubSize();
        Object obj = new Object();
        String s = "";
        ArrayList list = new ArrayList();
        this.m_chkType = CheckType.CHECK_TABLE;
        int i = 0;
        while (i < size) {
            block18: {
                block16: {
                    block19: {
                        block17: {
                            if (param.getSub(i).isLeaf()) {
                                if (i == 0) {
                                    obj = param.getSub(i).getLeafExpression().calculate(ctx);
                                } else {
                                    s = (String)param.getSub(i).getLeafExpression().calculate(ctx);
                                }
                            } else {
                                list.clear();
                                param.getSub(i).getAllLeafExpression(list);
                            }
                            if (this.m_chkType != CheckType.CHECK_TABLE) break block16;
                            if (i != 0) break block17;
                            this.m_tableInfo.setConnect(obj);
                            break block18;
                        }
                        if (i != 1) break block19;
                        this.m_tableInfo.setTableName(s);
                        if (this.m_tableInfo.m_oprationType == OprationType.OPRATION_SCAN) {
                            this.m_chkType = CheckType.CHECK_COLUMN;
                        }
                        break block18;
                    }
                    if (i != 2) break block18;
                    this.m_tableInfo.setRowkey(s);
                    if (this.m_tableInfo.m_oprationType != OprationType.OPRATION_GET) break block18;
                    this.m_chkType = CheckType.CHECK_COLUMN;
                    break block18;
                }
                Matcher[] m = new Matcher[1];
                int j = 0;
                while (j < list.size()) {
                    if (list.get(j) != null) {
                        String ss = ((Expression)list.get(j)).getIdentifierName();
                        s = ss.replace("\"", "");
                        if (Utils.isRegExpMatch(s, "(\\w+):(\\w+)", m)) {
                            this.m_chkType = CheckType.CHECK_COLUMN;
                        }
                        if (this.m_chkType == CheckType.CHECK_COLUMN) {
                            this.parseFamilyColumn(m);
                        } else if (this.m_chkType == CheckType.CHECK_TYPE) {
                            if (Utils.checkColumnType(this.m_tableInfo, this.m_tmpColumnName, s)) {
                                this.m_chkType = CheckType.CHECK_ALIAS;
                            }
                        } else if (this.m_chkType == CheckType.CHECK_ALIAS) {
                            this.m_tableInfo.setColumnAlias(this.m_tmpColumnName, s);
                            this.m_chkType = CheckType.CHECK_COLUMN;
                        }
                    } else {
                        this.m_chkType = CheckType.CHECK_ALIAS;
                        this.m_tableInfo.setColumnType(this.m_tmpColumnName, "byte");
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void parseFamilyColumn(Matcher[] m) {
        if (m[0].groupCount() != 2) {
            throw new RQException("parseFamilyColumn matcher groupCount is not 2");
        }
        this.m_tmpColumnName = String.valueOf(m[0].group(1)) + "_" + m[0].group(2);
        this.m_tableInfo.setFamily(m[0].group(1));
        this.m_tableInfo.setColumn(m[0].group(2));
        this.m_tableInfo.setColumnAlias(this.m_tmpColumnName, this.m_tmpColumnName);
        this.m_tableInfo.setColumnType(this.m_tmpColumnName, "byte");
        this.m_chkType = CheckType.CHECK_TYPE;
    }

    public static void format(Result result) {
        KeyValue[] kvs;
        String rowkey = Bytes.toString((byte[])result.getRow());
        KeyValue[] keyValueArray = kvs = result.raw();
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            String family = Bytes.toString((byte[])kv.getFamily());
            String qualifier = Bytes.toString((byte[])kv.getQualifier());
            System.out.println("rowkey->" + rowkey + " family->" + family + " qualifier->" + qualifier + " val->" + Bytes.toString((byte[])kv.getValue()));
            ++n2;
        }
    }

    public static Table toTable(ResultScanner scanner) throws IOException {
        if (scanner == null) {
            return null;
        }
        String[] colNames = null;
        Table table = null;
        boolean bFirst = true;
        Object[] objs = null;
        List<String> list = null;
        for (Result res : scanner) {
            String rowkey = Bytes.toString((byte[])res.getRow());
            if (bFirst) {
                bFirst = false;
                colNames = HbaseQuery.getColumnArray(res);
                table = new Table(colNames);
                list = Arrays.asList(colNames);
            }
            KeyValue[] kvs = res.raw();
            objs = new Object[colNames.length];
            objs[0] = rowkey;
            Record r = table.newLast(objs);
            KeyValue[] keyValueArray = kvs;
            int n = kvs.length;
            int n2 = 0;
            while (n2 < n) {
                String fullName;
                KeyValue kv = keyValueArray[n2];
                String family = Bytes.toString((byte[])kv.getFamily());
                String column = Bytes.toString((byte[])kv.getQualifier());
                if (column.compareTo("_0") != 0 && list.indexOf(fullName = String.valueOf(family) + "_" + column) > -1) {
                    r.set(fullName, (Object)Bytes.toString((byte[])kv.getValue()));
                }
                ++n2;
            }
        }
        return table;
    }

    public static Table toTable(ResultScanner scanner, TableInfo tb, int limit) {
        if (scanner == null) {
            throw new RQException("toTable param scanner is not null");
        }
        if (tb == null) {
            throw new RQException("toTable param TableInfo is not null");
        }
        if (tb.m_family.size() == 0) {
            try {
                return HbaseQuery.toTable(scanner);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Table table = null;
        Object[] objs = null;
        String[] colNames = null;
        String sAliasKey = "";
        int nCount = 0;
        int nCol = 0;
        int colSize = tb.m_columnAlias.size() + 1;
        colNames = new String[colSize];
        colNames[0] = "rowkey";
        for (String val : tb.m_columnAlias.values()) {
            colNames[++nCol] = val;
        }
        table = new Table(colNames);
        for (Result res : scanner) {
            objs = new Object[colSize];
            objs[0] = res.getRow();
            objs[0] = objs[0] instanceof Integer ? Integer.valueOf(Integer.parseInt(String.valueOf(objs[0]))) : Bytes.toString((byte[])res.getRow());
            nCol = 0;
            KeyValue[] kvs = res.raw();
            Record r = table.newLast(objs);
            KeyValue[] keyValueArray = kvs;
            int n = kvs.length;
            int n2 = 0;
            while (n2 < n) {
                KeyValue kv = keyValueArray[n2];
                String family = Bytes.toString((byte[])kv.getFamily());
                String column = Bytes.toString((byte[])kv.getQualifier());
                if (column.compareTo("_0") != 0) {
                    String fullName = String.valueOf(family) + "_" + column;
                    sAliasKey = tb.m_columnAlias.get(fullName);
                    objs[0] = Utils.getDataType(tb, fullName, Bytes.toString((byte[])kv.getValue()));
                    r.set(sAliasKey, objs[0]);
                }
                ++n2;
            }
            if (limit > 0 && ++nCount >= limit) break;
        }
        return table;
    }

    private static String[] getColumnArray(Result result) {
        String rowkey = Bytes.toString((byte[])result.getRow());
        String fullName = "rowkey:";
        KeyValue[] kvs = result.raw();
        ArrayList<String> list = new ArrayList<String>();
        list.add(rowkey);
        KeyValue[] keyValueArray = kvs;
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue kv = keyValueArray[n2];
            String family = Bytes.toString((byte[])kv.getFamily());
            String column = Bytes.toString((byte[])kv.getQualifier());
            if (column.compareTo("_0") != 0) {
                fullName = String.valueOf(fullName) + family + "_" + column + ":";
            }
            ++n2;
        }
        fullName = fullName.substring(0, fullName.length() - 1);
        String[] ary = fullName.split(":");
        System.out.println("fullName = " + ary.length + " list=" + list.size());
        return ary;
    }

    static enum CheckType {
        CHECK_TABLE,
        CHECK_COLUMN,
        CHECK_TYPE,
        CHECK_ALIAS;

    }
}

