/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.dm.Context;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.hbase1_3_0.HbaseDriverCli;
import com.raqsoft.lib.hbase1_3_0.function.HbaseQuery;
import com.raqsoft.lib.hbase1_3_0.function.OprationType;
import com.raqsoft.lib.hbase1_3_0.function.TableInfo;
import java.io.IOException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;

public class HbaseScan
extends HbaseQuery {
    @Override
    public Node optimize(Context ctx) {
        super.optimize(ctx);
        if (this.m_tableInfo == null) {
            this.m_tableInfo = new TableInfo(OprationType.OPRATION_SCAN);
        }
        return this;
    }

    @Override
    public Object calculate(Context ctx) {
        try {
            return super.calculate(ctx);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object doHbaseQuery(Object[] obj) {
        String option = this.getOption();
        if (option != null && option.equals("c")) {
            return this.hbaseCursor(obj);
        }
        return this.hbaseQuery(obj);
    }

    @Override
    public Object doHbaseQuery(TableInfo tb) throws IOException {
        String option = this.getOption();
        if (option != null && option.equals("c")) {
            return this.hbaseCursor(tb);
        }
        return this.hbaseQuery(tb);
    }

    public Table hbaseQuery(Object[] obj) {
        Table tb = null;
        try {
            super.hbaseQuery(obj);
            Scan scan = new Scan();
            HbaseDriverCli client = (HbaseDriverCli)obj[0];
            HTableInterface table = client.hConn.getTable((String)obj[1]);
            ResultScanner scanner = table.getScanner(scan);
            tb = HbaseScan.toTable(scanner);
            scanner.close();
            scanner = null;
            table.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tb;
    }

    public Table hbaseQuery(TableInfo tb) throws IOException {
        Table tbl = null;
        try {
            Scan scan = this.hbaseScanInfo(tb);
            HbaseDriverCli client = (HbaseDriverCli)tb.m_connect;
            HTableInterface table = client.hConn.getTable(tb.m_tableName);
            ResultScanner scanner = table.getScanner(scan);
            tbl = HbaseScan.toTable(scanner, tb, 0);
            scanner.close();
            scanner = null;
            table.close();
            scanner = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tbl;
    }

    public Object hbaseCursor(Object[] obj) {
        try {
            super.hbaseQuery(obj);
            HbaseDriverCli client = (HbaseDriverCli)obj[0];
            Scan scan = new Scan();
            this.m_tableInfo.setTableName((String)obj[1]);
            return client.queryRange(this.m_ctx, scan, this.m_tableInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object hbaseCursor(TableInfo tb) throws IOException {
        try {
            Scan scan = this.hbaseScanInfo(tb);
            HbaseDriverCli client = (HbaseDriverCli)tb.m_connect;
            return client.queryRange(this.m_ctx, scan, tb);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

