/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.Sequence;
import com.raqsoft.expression.IParam;
import com.raqsoft.lib.hbase1_3_0.function.Comparator;
import com.raqsoft.lib.hbase1_3_0.function.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class ParseFilter {
    private Context ctx;
    private IParam param;

    public ParseFilter(Context c, IParam p) {
        this.ctx = c;
        this.param = p;
    }

    public Object calculate() {
        int size = this.param.getSubSize();
        Object[] val = new Object[size];
        val[0] = Utils.checkValidDataType(this.param.getSub(0), this.ctx, "String");
        if (val[0] == null) {
            throw new RQException("Filter Param: " + val[0] + " not unvalid");
        }
        String filterName = (String)val[0];
        System.out.println("filter = " + filterName + " size=" + size);
        if (filterName.compareToIgnoreCase("singleColumnValueFilter") == 0) {
            if (size != 5) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doSingleColumnValueFilter(val);
        }
        if (filterName.compareToIgnoreCase("SingleColumnValueExcludeFilter") == 0) {
            if (size != 5) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doSingleColumnValueExcludeFilter(val);
        }
        if (filterName.compareToIgnoreCase("FamilyFilter") == 0) {
            if (size != 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doFamilyFilter(val);
        }
        if (filterName.compareToIgnoreCase("qualifierFilter") == 0) {
            if (size != 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doQualifierFilter(val);
        }
        if (filterName.compareToIgnoreCase("ColumnPrefixFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doColumnPrefixFilter(val);
        }
        if (filterName.compareToIgnoreCase("MultipleColumnPrefixFilter") == 0) {
            if (size < 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doMultipleColumnPrefixFilter(val);
        }
        if (filterName.compareToIgnoreCase("ColumnRangeFilter") == 0) {
            if (size != 5) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doColumnRangeFilter(val);
        }
        if (filterName.compareToIgnoreCase("DependentColumnFilter") == 0) {
            if (size <= 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doDependentColumnFilter(val);
        }
        if (filterName.compareToIgnoreCase("rowFilter") == 0) {
            if (size != 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doRowFilter(val);
        }
        if (filterName.compareToIgnoreCase("RandomRowFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doRandomRowFilter(val);
        }
        if (filterName.compareToIgnoreCase("SkipFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doSkipFilter(val);
        }
        if (filterName.compareToIgnoreCase("WhileMatchFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doWhileMatchFilter(val);
        }
        if (filterName.compareToIgnoreCase("PageFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doPageFilter(val);
        }
        if (filterName.compareToIgnoreCase("FirstKeyValueMatchingQualifiersFilter") == 0) {
            if (size < 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doFirstKeyValueMatchingQualifiersFilter(val);
        }
        if (filterName.compareToIgnoreCase("InclusiveStopFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doInclusiveStopFilter(val);
        }
        if (filterName.compareToIgnoreCase("ColumnPaginationFilter") == 0) {
            if (size != 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doColumnPaginationFilter(val);
        }
        if (filterName.compareToIgnoreCase("ColumnCountGetFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doColumnCountGetFilter(val);
        }
        if (filterName.compareToIgnoreCase("FuzzyRowFilter") == 0) {
            if (size < 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            if (size % 2 != 1) {
                throw new RQException("FilterName: " + filterName + " param size is not 2N");
            }
            return this.doFuzzyRowFilter(val);
        }
        if (filterName.compareToIgnoreCase("PrefixFilter") == 0) {
            if (size != 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doPrefixFilter(val);
        }
        if (filterName.compareToIgnoreCase("TimestampsFilter") == 0) {
            if (size <= 2) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doTimestampsFilter(val);
        }
        if (filterName.compareToIgnoreCase("ValueFilter") == 0) {
            if (size != 3) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            return this.doValueFilter(val);
        }
        if (filterName.compareToIgnoreCase("MultiRowRangeFilter") == 0) {
            if (size < 5) {
                throw new RQException("FilterName: " + filterName + " param size is " + (size - 1));
            }
            if ((size - 1) % 4 != 0) {
                throw new RQException("FilterName: " + filterName + " param size is 4 * n");
            }
            return this.doMultiRowRangeFilter(val);
        }
        throw new RQException("FilterName: " + filterName + " is not existed");
    }

    public Filter doSingleColumnValueFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "String")) == null) {
            throw new RQException("Filter " + val[0] + " Param: family, qualifier, compareOp");
        }
        val[3] = Utils.checkValidDataType(this.param.getSub(3), this.ctx, "String");
        CompareFilter.CompareOp op = Utils.fromSymbol((String)val[3]);
        ByteArrayComparable comp = null;
        val[4] = Utils.checkValidDataTypeWithoutPrompt(this.param.getSub(4), this.ctx, "String");
        if (val[4] != null) {
            String regExp = "(\\w+Filter)\\((.*)\\)";
            Pattern p = Pattern.compile(regExp);
            Matcher m = p.matcher((String)val[4]);
            if (m.matches() && m.groupCount() == 2) {
                String compatorName = m.group(0);
                String compatorParam = m.group(1);
                comp = Comparator.getComparator(compatorName, compatorParam);
                return ParseFilter.singleColumnValueFilter((String)val[1], (String)val[2], op, comp);
            }
            return ParseFilter.singleColumnValueFilter((String)val[1], (String)val[2], op, (String)val[4]);
        }
        val[4] = Utils.checkValidDataType(this.param.getSub(4), this.ctx, "Compator");
        if (val[4] == null) {
            throw new RQException("Filter " + val[0] + " Param: family, qualifier, compareOp compator");
        }
        return ParseFilter.singleColumnValueFilter((String)val[1], (String)val[2], op, (ByteArrayComparable)val[4]);
    }

    public static Filter singleColumnValueFilter(String family, String qualifier, CompareFilter.CompareOp op, String value) {
        System.out.println("SingleColumnValueFilter family=" + family + " column=" + qualifier + " val=" + value + " op=" + op);
        return new SingleColumnValueFilter(family.getBytes(), qualifier.getBytes(), op, value.getBytes());
    }

    public static Filter singleColumnValueFilter(String family, String qualifier, CompareFilter.CompareOp op, ByteArrayComparable comparator) {
        return new SingleColumnValueFilter(family.getBytes(), qualifier.getBytes(), op, comparator);
    }

    public Filter doSingleColumnValueExcludeFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "String")) == null) {
            throw new RQException("Filter " + val[0] + " Param: family, qualifier, compareOp");
        }
        val[3] = Utils.checkValidDataType(this.param.getSub(3), this.ctx, "String");
        CompareFilter.CompareOp op = Utils.fromSymbol((String)val[3]);
        Object comp = null;
        System.out.println("subStr = " + this.param.getSub(4).getLeafExpression().calculate(this.ctx));
        val[4] = Utils.checkValidDataType(this.param.getSub(4), this.ctx, "String");
        if (val[4] != null) {
            return ParseFilter.singleColumnValueExcludeFilter((String)val[1], (String)val[2], op, (String)val[4]);
        }
        val[4] = Utils.checkValidDataType(this.param.getSub(4), this.ctx, "Compator");
        if (val[4] != null) {
            return ParseFilter.singleColumnValueExcludeFilter((String)val[1], (String)val[2], op, (ByteArrayComparable)val[4]);
        }
        throw new RQException("Filter " + val[0] + " Param: family, qualifier, compareOp compator");
    }

    public static Filter singleColumnValueExcludeFilter(String family, String qualifier, CompareFilter.CompareOp op, String value) {
        return new SingleColumnValueExcludeFilter(family.getBytes(), qualifier.getBytes(), op, value.getBytes());
    }

    public static Filter singleColumnValueExcludeFilter(String family, String qualifier, CompareFilter.CompareOp op, ByteArrayComparable comparator) {
        return new SingleColumnValueExcludeFilter(family.getBytes(), qualifier.getBytes(), op, comparator);
    }

    public Filter doFamilyFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "CompareOp");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "Compator")) == null) {
            throw new RQException("Filter " + val[0] + " Param compareOp Comparator");
        }
        return new FamilyFilter(Utils.fromSymbol((String)val[1]), (ByteArrayComparable)val[2]);
    }

    public Filter doQualifierFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "Compator")) == null) {
            throw new RQException("Filter " + val[0] + " Param compareOp Comparator");
        }
        return new QualifierFilter(Utils.fromSymbol((String)val[1]), (ByteArrayComparable)val[2]);
    }

    public Filter doColumnPrefixFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "string");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param byte[]");
        }
        return new ColumnPrefixFilter(((String)val[1]).getBytes());
    }

    public Filter doMultipleColumnPrefixFilter(Object[] vals) {
        int i = 0;
        int j = 0;
        byte[][] prefixes = new byte[vals.length - 1][];
        Object[] objectArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            if (i == 0) {
                ++i;
            } else {
                v = Utils.checkValidDataType(this.param.getSub(i), this.ctx, "string");
                if (v == null) {
                    throw new RQException("Filter " + vals[0] + " index:" + i + " Param byte[]");
                }
                prefixes[j++] = ((String)v).getBytes();
                ++i;
            }
            ++n2;
        }
        return new MultipleColumnPrefixFilter((byte[][])prefixes);
    }

    public Filter doColumnRangeFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "bool")) == null || (val[3] = Utils.checkValidDataType(this.param.getSub(3), this.ctx, "String")) == null || (val[4] = Utils.checkValidDataType(this.param.getSub(4), this.ctx, "bool")) == null) {
            throw new RQException("Filter " + val[0] + "Param type: minColumn minColumnInclusive " + " maxColumn maxColumnInclusive");
        }
        boolean minColumnInclusive = (Boolean)val[2];
        boolean maxColumnInclusive = (Boolean)val[4];
        return new ColumnRangeFilter(((String)val[1]).getBytes(), minColumnInclusive, ((String)val[3]).getBytes(), maxColumnInclusive);
    }

    public Filter doDependentColumnFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "String")) == null) {
            throw new RQException("Filter " + val[0] + "Param family qualifier");
        }
        if (val.length == 3) {
            return new DependentColumnFilter(((String)val[1]).getBytes(), ((String)val[2]).getBytes());
        }
        if (val.length > 3) {
            val[3] = Utils.checkValidDataType(this.param.getSub(3), this.ctx, "bool");
            if (val[3] == null) {
                throw new RQException("Filter " + val[0] + "Param family qualifier true/false");
            }
            if (val.length == 4) {
                return new DependentColumnFilter(((String)val[1]).getBytes(), ((String)val[2]).getBytes(), ((Boolean)val[3]).booleanValue());
            }
            if (val.length == 6) {
                val[4] = Utils.checkValidDataType(this.param.getSub(4), this.ctx, "String");
                if (val[4] == null || (val[5] = Utils.checkValidDataType(this.param.getSub(5), this.ctx, "Compator")) == null) {
                    throw new RQException("Filter " + val[0] + "Param family qualifier");
                }
                return new DependentColumnFilter(((String)val[1]).getBytes(), ((String)val[2]).getBytes(), ((Boolean)val[3]).booleanValue(), Utils.fromSymbol((String)val[4]), (ByteArrayComparable)val[5]);
            }
        }
        return null;
    }

    public Filter doRowFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "Compator")) == null) {
            throw new RQException("Filter " + val[0] + " Param compareOp Comparator");
        }
        return new RowFilter(Utils.fromSymbol((String)val[1]), (ByteArrayComparable)val[2]);
    }

    public Filter doRandomRowFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "double");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param chance");
        }
        return new RandomRowFilter(Utils.objectToFloat(val[1]));
    }

    public Filter doSkipFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "Filter");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param filter");
        }
        return new SkipFilter((Filter)val[1]);
    }

    public Filter doWhileMatchFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "Filter");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param filter");
        }
        return new WhileMatchFilter((Filter)val[1]);
    }

    public Filter doPageFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "int");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param pageSize");
        }
        return new PageFilter((long)((Integer)val[1]).intValue());
    }

    public Filter firstKeyOnlyFilter() {
        return new FirstKeyOnlyFilter();
    }

    public Filter doFirstKeyValueMatchingQualifiersFilter(Object[] vals) {
        int i = 0;
        HashSet<byte[]> qualifiers = new HashSet<byte[]>();
        Object[] objectArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            if (i == 0) {
                ++i;
            } else {
                v = Utils.checkValidDataType(this.param.getSub(i), this.ctx, "string");
                if (v == null) {
                    throw new RQException("Filter " + vals[0] + " index:" + i + " Param byte[]");
                }
                qualifiers.add(((String)v).getBytes());
                ++i;
            }
            ++n2;
        }
        return new FirstKeyValueMatchingQualifiersFilter(qualifiers);
    }

    public Filter keyOnlyFilter() {
        return new KeyOnlyFilter();
    }

    public Filter doInclusiveStopFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param: stopRowKey");
        }
        return new InclusiveStopFilter(((String)val[1]).getBytes());
    }

    public Filter doColumnPaginationFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "int");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param limit columnOffset");
        }
        val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "int");
        if (val[2] != null) {
            return new ColumnPaginationFilter(((Integer)val[1]).intValue(), ((Integer)val[2]).intValue());
        }
        val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "string");
        if (val[2] != null) {
            return new ColumnPaginationFilter(((Integer)val[1]).intValue(), ((String)val[2]).getBytes());
        }
        return null;
    }

    public Filter doColumnCountGetFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "int");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param count");
        }
        return new ColumnCountGetFilter(((Integer)val[1]).intValue());
    }

    public Filter doFuzzyRowFilter(Object[] vals) {
        try {
            LinkedList<Pair> fuzzyKeysData = new LinkedList<Pair>();
            int i = 1;
            while (i < vals.length) {
                vals[1] = Utils.checkValidDataType(this.param.getSub(i), this.ctx, "string");
                if (vals[1] == null || (vals[2] = Utils.checkValidDataType(this.param.getSub(i + 1), this.ctx, "sequence")) == null) {
                    throw new RQException("Filter " + vals[0] + " index:" + i + " Param long");
                }
                int[] nt = ((Sequence)vals[2]).toIntArray();
                byte[] bt = new byte[nt.length];
                int j = 0;
                while (j < nt.length) {
                    bt[j] = (byte)nt[j];
                    ++j;
                }
                Pair data = new Pair((Object)Bytes.toBytesBinary((String)((String)vals[1])), (Object)bt);
                fuzzyKeysData.add(data);
                i += 2;
            }
            return new FuzzyRowFilter(fuzzyKeysData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Filter doPrefixFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "string");
        if (val[1] == null) {
            throw new RQException("Filter " + val[0] + " Param string");
        }
        return new PrefixFilter(((String)val[1]).getBytes());
    }

    public Filter doTimestampsFilter(Object[] vals) {
        int i = 0;
        LinkedList<Long> list = new LinkedList<Long>();
        i = 1;
        while (i < vals.length - 1) {
            vals[0] = Utils.checkValidDataType(this.param.getSub(i), this.ctx, "long");
            if (vals[0] == null) {
                throw new RQException("Filter " + vals[0] + " index:" + i + " Param long");
            }
            list.add(Utils.objectToLong(vals[0]));
            ++i;
        }
        vals[1] = Utils.checkValidDataType(this.param.getSub(vals.length - 1), this.ctx, "bool");
        if (vals[1] == null) {
            throw new RQException("Filter " + vals[0] + " index:" + i + " Param byte[]");
        }
        return new TimestampsFilter(list, ((Boolean)vals[1]).booleanValue());
    }

    public Filter doValueFilter(Object[] val) {
        val[1] = Utils.checkValidDataType(this.param.getSub(1), this.ctx, "String");
        if (val[1] == null || (val[2] = Utils.checkValidDataType(this.param.getSub(2), this.ctx, "Compator")) == null) {
            throw new RQException("Filter " + val[0] + " Param compareOp Comparator");
        }
        return new ValueFilter(Utils.fromSymbol((String)val[1]), (ByteArrayComparable)val[2]);
    }

    private byte[] doMultiRowRangeVal(int i, Object[] vals, Context ctx) {
        byte[] bt = null;
        vals[1] = Utils.checkValidDataType(this.param.getSub(i), ctx, "String");
        if (vals[1] != null) {
            bt = Bytes.toBytes((String)vals[1].toString());
        } else {
            vals[1] = Utils.checkValidDataType(this.param.getSub(i), ctx, "int");
            if (vals[1] != null) {
                int n = Integer.parseInt(String.valueOf(vals[1]));
                bt = Bytes.toBytes((int)n);
            } else {
                vals[1] = Utils.checkValidDataType(this.param.getSub(i), ctx, "decimal");
                if (vals[1] != null) {
                    BigDecimal n = Utils.getBigDecimal(vals[1]);
                    bt = Bytes.toBytes((BigDecimal)n);
                }
            }
        }
        return bt;
    }

    public Filter doMultiRowRangeFilter(Object[] vals) {
        MultiRowRangeFilter filter = null;
        try {
            int i = 0;
            Object o = null;
            Object o2 = null;
            ArrayList<MultiRowRangeFilter.RowRange> range = new ArrayList<MultiRowRangeFilter.RowRange>();
            byte[] low = null;
            byte[] high = null;
            i = 1;
            while (i < vals.length) {
                low = this.doMultiRowRangeVal(i + 0, vals, this.ctx);
                high = this.doMultiRowRangeVal(i + 2, vals, this.ctx);
                vals[2] = Utils.checkValidDataType(this.param.getSub(i + 1), this.ctx, "bool");
                if (vals[2] == null || (vals[4] = Utils.checkValidDataType(this.param.getSub(i + 3), this.ctx, "bool")) == null) {
                    throw new RQException("Filter " + vals[0] + " index:" + (i + 1) + " or " + (i + 3) + " Param is boolean");
                }
                range.add(new MultiRowRangeFilter.RowRange(low, ((Boolean)vals[2]).booleanValue(), high, ((Boolean)vals[4]).booleanValue()));
                i += 4;
            }
            filter = new MultiRowRangeFilter(range);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filter;
    }
}

