/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.lib.hbase1_3_0.function.OprationType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.filter.Filter;

public class TableInfo {
    public OprationType m_oprationType;
    public String m_rowkey;
    public Object m_connect;
    public String m_tableName;
    public List<String> m_family;
    public List<String> m_column;
    public LinkedHashMap<String, String> m_columnType;
    public LinkedHashMap<String, String> m_columnAlias;
    public String m_rowPrefix;
    public Filter m_filter;
    public int m_limit;
    public int m_version;
    public String m_startRow;
    public String m_stopRow;
    public long m_minTimeStamp;
    public long m_maxTimeStamp;
    public long m_timeStamp;

    public TableInfo(OprationType oprationType) {
        this.m_oprationType = oprationType;
        this.init();
    }

    public void setOprationType(OprationType oprationType) {
        this.m_oprationType = oprationType;
    }

    public void setRowkey(String key) {
        this.m_rowkey = key;
    }

    public void setConnect(Object f) {
        this.m_connect = f;
    }

    public void setFilter(Filter f) {
        this.m_filter = f;
    }

    public void setTableName(String s) {
        this.m_tableName = s;
    }

    public void setFamily(String s) {
        this.m_family.add(s);
    }

    public void setColumn(String s) {
        this.m_column.add(s);
    }

    public void setColumnType(String key, String val) {
        this.m_columnType.put(key, val);
    }

    public void setColumnAlias(String key, String val) {
        this.m_columnAlias.put(key, val);
    }

    public void setRowPrefixFilter(String s) {
        this.m_rowPrefix = s;
    }

    public void setLimit(int n) {
        this.m_limit = n;
    }

    public void setVersion(int n) {
        this.m_version = n;
    }

    public void setStartRow(String s) {
        this.m_startRow = s;
    }

    public void setStopRow(String s) {
        this.m_stopRow = s;
    }

    public void setMinTimeStamp(long l) {
        this.m_minTimeStamp = l;
    }

    public void setMaxTimeStamp(long l) {
        this.m_maxTimeStamp = l;
    }

    public void setTimeStamp(long l) {
        this.m_timeStamp = l;
    }

    private void init() {
        this.m_rowkey = "";
        this.m_connect = null;
        this.m_filter = null;
        this.m_tableName = "";
        this.m_family = new ArrayList<String>();
        this.m_column = new ArrayList<String>();
        this.m_columnType = new LinkedHashMap();
        this.m_columnAlias = new LinkedHashMap();
        this.m_rowPrefix = "";
        this.m_limit = 0;
        this.m_version = 0;
        this.m_startRow = "";
        this.m_stopRow = "";
        this.m_minTimeStamp = 0L;
        this.m_maxTimeStamp = 0L;
        this.m_timeStamp = 0L;
    }

    public void reset() {
        this.m_rowkey = "";
        this.m_connect = null;
        this.m_filter = null;
        this.m_tableName = "";
        this.m_family.clear();
        this.m_column.clear();
        this.m_columnType.clear();
        this.m_columnAlias.clear();
        this.m_rowPrefix = "";
        this.m_limit = 0;
        this.m_version = 0;
        this.m_startRow = "";
        this.m_stopRow = "";
        this.m_minTimeStamp = 0L;
        this.m_maxTimeStamp = 0L;
        this.m_timeStamp = 0L;
    }

    public void printTest(String sinfo) {
        System.out.println(sinfo);
        System.out.println("m_rowkey = " + this.m_rowkey);
        System.out.println("connect = " + this.m_connect);
        System.out.println("filter = " + this.m_filter);
        System.out.println("m_tableName = " + this.m_tableName);
        System.out.println("m_family = " + this.m_family);
        System.out.println("m_column = " + this.m_column);
        System.out.println("m_columnType = " + this.m_columnType);
        for (Map.Entry<String, String> entry : this.m_columnAlias.entrySet()) {
            System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
        }
        System.out.println("m_columnAlias = " + this.m_columnAlias);
        System.out.println("m_rowPrefix = " + this.m_rowPrefix);
        System.out.println("m_limit = " + this.m_limit);
        System.out.println("m_version = " + this.m_version);
        System.out.println("m_startRow = " + this.m_startRow);
        System.out.println("m_stopRow= " + this.m_stopRow);
        System.out.println("m_minTimeStamp = " + this.m_minTimeStamp);
        System.out.println("m_maxTimeStamp = " + this.m_maxTimeStamp);
        System.out.println("m_timeStamp = " + this.m_timeStamp);
    }
}

