/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.hbase1_3_0.function;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.Sequence;
import com.raqsoft.expression.IParam;
import com.raqsoft.lib.hbase1_3_0.function.TableInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;

public class Utils {
    public static CompareFilter.CompareOp fromSymbol(String v) {
        CompareFilter.CompareOp op = CompareFilter.CompareOp.EQUAL;
        op = v == null || "".equals(v) ? CompareFilter.CompareOp.NO_OP : (v.equals("<") || v.equals("lt") ? CompareFilter.CompareOp.LESS : (v.equals("<=") || v.equals("le") ? CompareFilter.CompareOp.LESS_OR_EQUAL : (v.equals("=") || v.equals("eq") ? CompareFilter.CompareOp.EQUAL : (v.equals("!=") || v.equals("ne") || v.equals("neq") ? CompareFilter.CompareOp.NOT_EQUAL : (v.equals(">=") || v.equals("ge") ? CompareFilter.CompareOp.GREATER_OR_EQUAL : (v.equals(">") || v.equals("gt") ? CompareFilter.CompareOp.GREATER : (v.equals("<>") || v.equals("nop") ? CompareFilter.CompareOp.NO_OP : CompareFilter.CompareOp.EQUAL)))))));
        return op;
    }

    public static int getRegexPattern(String s) {
        int nRet = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == 'i') {
                nRet |= 2;
            } else if (s.charAt(i) == 'm') {
                nRet |= 8;
            } else if (s.charAt(i) == 'd') {
                nRet |= 0x20;
            } else if (s.charAt(i) == 'u') {
                nRet |= 0x40;
            } else if (s.charAt(i) == 'q') {
                nRet |= 0x80;
            } else if (s.charAt(i) == 'x') {
                nRet |= 1;
            } else if (s.charAt(i) == 'l') {
                nRet |= 0x10;
            } else if (s.charAt(i) == 'c') {
                nRet |= 4;
            } else if (s.charAt(i) == 'n') {
                nRet |= 0x100;
            } else {
                throw new RQException("regex param: " + s.charAt(i) + " not existed");
            }
            ++i;
        }
        return nRet;
    }

    public static BitComparator.BitwiseOp GetBitwiseOp(String v) {
        if ("and".equalsIgnoreCase(v)) {
            return BitComparator.BitwiseOp.AND;
        }
        if ("or".equalsIgnoreCase(v)) {
            return BitComparator.BitwiseOp.OR;
        }
        if ("xor".equalsIgnoreCase(v)) {
            return BitComparator.BitwiseOp.XOR;
        }
        return BitComparator.BitwiseOp.AND;
    }

    public static Object checkValidDataTypeWithoutPrompt(IParam sub, Context ctx, String type) {
        Object retObj = null;
        if (sub != null) {
            Object o = sub.getLeafExpression().calculate(ctx);
            if (!(type.equalsIgnoreCase("Compator") ? !(o instanceof ByteArrayComparable) : (type.equalsIgnoreCase("CompateOp") ? !(o instanceof CompareFilter.CompareOp) : (type.equalsIgnoreCase("Filter") ? !(o instanceof Filter) : (type.equalsIgnoreCase("int") ? !(o instanceof Integer) : (type.equalsIgnoreCase("long") ? !(o instanceof Long) : (type.equalsIgnoreCase("bool") ? !(o instanceof Boolean) : (type.equalsIgnoreCase("decimal") ? !(o instanceof BigDecimal) : (type.equalsIgnoreCase("double") ? !(o instanceof Double) : (type.equalsIgnoreCase("byte") ? !(o instanceof byte[]) : o == null || !(o instanceof String))))))))))) {
                retObj = o;
            }
        }
        return retObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object checkValidDataType(IParam sub, Context ctx, String type) {
        Object retObj = null;
        if (sub == null) return retObj;
        Object o = sub.getLeafExpression().calculate(ctx);
        if (type.equalsIgnoreCase("Compator")) {
            if (o instanceof ByteArrayComparable) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("CompateOp")) {
            if (o instanceof CompareFilter.CompareOp) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("Filter")) {
            if (o instanceof Filter) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("int")) {
            if (o instanceof Integer) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("long")) {
            if (o instanceof Long) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("bool")) {
            if (o instanceof Boolean) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("double")) {
            if (o instanceof Double) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("byte")) {
            if (o instanceof byte[]) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else if (type.equalsIgnoreCase("Sequence")) {
            if (o instanceof Sequence) return o;
            System.out.println("instanceof = " + o + " is not " + type);
            return retObj;
        } else {
            if (o == null) return retObj;
            if (o instanceof String) return o;
            System.out.println("instanceof = " + o + " is not String");
        }
        return retObj;
    }

    public static long objectToLong(Object Obj) {
        double d = Double.valueOf(String.valueOf(Obj));
        return (long)d;
    }

    public static float objectToFloat(Object Obj) {
        return Float.valueOf(String.valueOf(Obj)).floatValue();
    }

    public static double objectToDouble(Object Obj) {
        return Double.valueOf(String.valueOf(Obj));
    }

    public static boolean checkColumnType(TableInfo tableInfo, String colFullName, String type) {
        boolean bRet = false;
        if (type.compareToIgnoreCase("string") == 0 || type.compareToIgnoreCase("long") == 0 || type.compareToIgnoreCase("float") == 0 || type.compareToIgnoreCase("decimal") == 0) {
            bRet = true;
            tableInfo.setColumnType(colFullName, type.toLowerCase());
        } else if (type.compareToIgnoreCase("int") == 0 || type.compareToIgnoreCase("integer") == 0) {
            bRet = true;
            tableInfo.setColumnType(colFullName, "int");
        } else {
            bRet = true;
            tableInfo.setColumnType(colFullName, "bytes");
        }
        return bRet;
    }

    public static Object getDataType(TableInfo tableInfo, String colFullName, Object data) {
        Object oRet = null;
        String type = tableInfo.m_columnType.get(colFullName);
        oRet = type.compareToIgnoreCase("string") == 0 ? (String)data : (type.compareToIgnoreCase("int") == 0 ? Integer.valueOf(Integer.parseInt(String.valueOf(data))) : (type.compareToIgnoreCase("long") == 0 ? Long.valueOf(Utils.objectToLong(data)) : (type.compareToIgnoreCase("float") == 0 ? Float.valueOf(String.valueOf(data)) : (type.compareToIgnoreCase("decimal") == 0 ? Utils.getBigDecimal(data) : (String)data))));
        return oRet;
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    public static boolean isRegExpMatch(String strSrc, String regExp, Matcher[] retMatch) {
        if (strSrc == null || strSrc.isEmpty()) {
            throw new RQException("hive isMatch strUrl is empty");
        }
        if (regExp == null || regExp.isEmpty()) {
            throw new RQException("hive isMatch regExp is empty");
        }
        Pattern p = Pattern.compile(regExp);
        retMatch[0] = p.matcher(strSrc);
        return retMatch[0].matches() && retMatch[0].groupCount() == 2;
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes;
        block3: {
            bytes = null;
            if (obj != null) break block3;
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public static Object toObject(byte[] bytes) {
        Object obj;
        block4: {
            obj = null;
            if (obj != null) break block4;
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public static boolean checkFunctionExisted(Class<?> cls, String funcName, Method[] m) {
        boolean bExisted = false;
        Method[] methods = cls.getMethods();
        int idx = 0;
        while (idx < methods.length) {
            System.out.println("func = " + methods[idx].getName());
            if (methods[idx].getName().equals(funcName)) {
                bExisted = true;
                m = new Method[]{methods[idx]};
                break;
            }
            ++idx;
        }
        return bExisted;
    }
}

