/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.olap4j.function;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Sequence;
import com.raqsoft.dm.Table;
import com.raqsoft.dm.cursor.ICursor;
import com.raqsoft.lib.olap4j.function.Utils;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Member;

public class ImCursor
extends ICursor {
    private Context m_ctx;
    private CellSet m_cellSet;
    private boolean m_bEnd = false;
    private String[] m_colNames;
    private int m_nIndex = 0;

    public ImCursor(CellSet cellset, Context ctx) {
        this.m_cellSet = cellset;
        this.m_ctx = ctx;
        ctx.addResource((IResource)this);
        this.m_colNames = Utils.getColumnNames(cellset);
    }

    protected long skipOver(long n) {
        int count = 0;
        if ((long)count < n) {
            this.close();
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        try {
            if (this.m_ctx != null) {
                this.m_ctx.removeResource((IResource)this);
                this.m_ctx = null;
            }
            this.m_bEnd = true;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    public Sequence get(int n) {
        Table table = this.getTable(n);
        if (table == null) {
            this.close();
            return null;
        }
        if (table.length() < n && n < 99999) {
            this.close();
        }
        return table;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isEnd() {
        return this.m_bEnd;
    }

    private Table getTable(int n) {
        if (n < 0) {
            return null;
        }
        int nCount = 0;
        int nCur = 0;
        int k = 0;
        Table table = new Table(this.m_colNames);
        Object[] objs = new Object[this.m_colNames.length];
        if (this.m_cellSet != null) {
            if (this.m_cellSet.getAxes().size() == 2) {
                for (Position row : (CellSetAxis)this.m_cellSet.getAxes().get(1)) {
                    if (this.m_nIndex > ++nCur) continue;
                    k = 0;
                    for (Member member : row.getMembers()) {
                        objs[k++] = member.getName();
                    }
                    for (Position column : (CellSetAxis)this.m_cellSet.getAxes().get(0)) {
                        Cell cell = this.m_cellSet.getCell(new Position[]{column, row});
                        objs[k++] = cell.getFormattedValue();
                    }
                    table.newLast(objs);
                    if (nCount++ >= n - 1) break;
                }
                this.m_nIndex += nCount;
            } else if (this.m_cellSet.getAxes().size() == 1) {
                for (Position column : (CellSetAxis)this.m_cellSet.getAxes().get(0)) {
                    Cell cell = this.m_cellSet.getCell(new Position[]{column});
                    objs[k++] = cell.getFormattedValue();
                }
                table.newLast(objs);
            }
        }
        return table;
    }
}

