/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.olap4j.function;

import com.raqsoft.dm.Context;
import com.raqsoft.dm.IResource;
import com.raqsoft.lib.olap4j.function.OlapConnUtil;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.metadata.Member;

public class MdxQueryUtil
implements IResource {
    public OlapConnection m_olapConn = null;

    public OlapConnection getOlapConn(Context ctx, String server, String catalog, String user, String password, int retry) {
        int temp = retry;
        while (this.m_olapConn == null && retry-- > 0) {
            try {
                if (temp > retry) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.m_olapConn = OlapConnUtil.getOlapConn(server, catalog, user, password);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ctx.addResource((IResource)this);
        return this.m_olapConn;
    }

    public CellSet query(String mdx) throws SQLException {
        if (this.m_olapConn != null) {
            OlapStatement stmt = null;
            stmt = this.m_olapConn.createStatement();
            CellSet cellSet = null;
            if (stmt != null) {
                cellSet = stmt.executeOlapQuery(mdx);
            }
            if (cellSet != null) {
                try {
                    cellSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        stmt = null;
                    }
                }
                finally {
                    stmt = null;
                }
            }
            return cellSet;
        }
        return null;
    }

    public CellSet qcursor(String mdx) throws SQLException {
        if (this.m_olapConn != null) {
            OlapStatement stmt = null;
            stmt = this.m_olapConn.createStatement();
            CellSet cellSet = null;
            if (stmt != null) {
                cellSet = stmt.executeOlapQuery(mdx);
            }
            if (cellSet != null) {
                try {
                    cellSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        stmt = null;
                    }
                }
                finally {
                    stmt = null;
                }
            }
            return cellSet;
        }
        return null;
    }

    public void print(CellSet cellSet, PrintWriter writer) {
        if (cellSet != null && cellSet.getAxes().size() == 2) {
            for (Position row : (CellSetAxis)cellSet.getAxes().get(1)) {
                for (Member member : row.getMembers()) {
                    writer.print(String.valueOf(member.getName()) + "\t");
                }
                for (Position column : (CellSetAxis)cellSet.getAxes().get(0)) {
                    Cell cell = cellSet.getCell(new Position[]{column, row});
                    writer.print(String.valueOf(cell.getFormattedValue()) + "\t");
                }
                writer.println();
            }
            writer.flush();
        }
    }

    public void close() {
        try {
            try {
                if (this.m_olapConn != null) {
                    this.m_olapConn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.m_olapConn = null;
            }
        }
        finally {
            this.m_olapConn = null;
        }
    }
}

