/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.sap2_1_1;

import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.DataStruct;
import com.raqsoft.dm.IResource;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Sequence;
import com.raqsoft.dm.Table;
import com.raqsoft.dm.cursor.ICursor;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTable;

public class ImmCursor
extends ICursor {
    private Context m_ctx;
    private boolean bEnd = false;
    private JCoTable m_jcoTable;

    public ImmCursor(JCoTable bt, Context ctx) {
        this.m_jcoTable = bt;
        this.m_ctx = ctx;
        ctx.addResource((IResource)this);
    }

    public synchronized void close() {
        super.close();
        try {
            if (this.m_ctx != null) {
                this.m_ctx.removeResource((IResource)this);
                this.m_ctx = null;
            }
            this.bEnd = true;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    protected long skipOver(long n) {
        if (this.m_jcoTable == null) {
            System.out.println("jcoTalbe is null");
            return 0L;
        }
        int nCount = 0;
        do {
            if ((long)(++nCount) < n) continue;
            this.m_jcoTable.nextRow();
            break;
        } while (this.m_jcoTable.nextRow());
        if ((long)nCount < n) {
            this.close();
        }
        return nCount;
    }

    public Sequence get(int n) {
        if (this.m_jcoTable == null) {
            System.out.println("jcoTalbe is null");
            return null;
        }
        Table tb = null;
        int colSize = 0;
        String[] colNames = null;
        JCoRecordMetaData meta = this.m_jcoTable.getRecordMetaData();
        if (meta != null) {
            colSize = meta.getFieldCount();
            colNames = new String[colSize];
            int i = 0;
            while (i < colSize) {
                colNames[i] = meta.getName(i);
                ++i;
            }
        }
        if (colNames != null) {
            DataStruct ds = new DataStruct(colNames);
            tb = new Table(ds, colNames.length);
        }
        int nCount = 0;
        do {
            Record r = tb.newLast();
            ++nCount;
            int j = 0;
            while (j < colSize) {
                r.setNormalFieldValue(j, this.m_jcoTable.getValue(j));
                ++j;
            }
            if (nCount < n) continue;
            this.m_jcoTable.nextRow();
            break;
        } while (this.m_jcoTable.nextRow());
        if (tb == null) {
            this.close();
            return null;
        }
        if (tb.length() < n && n < 99999) {
            this.close();
        }
        return tb;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isEnd() {
        return this.bEnd;
    }
}

