/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.sap2_1_1.function;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.expression.Function;
import com.raqsoft.expression.IParam;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.sap2_1_1.ImDriverCli;
import com.raqsoft.lib.sap2_1_1.function.RfcManager;
import com.raqsoft.resources.EngineMessage;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;

public class ImFunction
extends Function {
    protected int m_paramSize = 0;
    protected boolean m_bCursor = false;
    protected boolean m_bFunctionParam = false;
    protected ImDriverCli m_driver = null;
    protected String[] m_colNames;
    protected String[] m_paramTypes;
    protected Context m_ctx;

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        this.m_ctx = ctx;
        return this;
    }

    protected void setParamSize(int paramSize) {
        this.m_paramSize = paramSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("hive_client" + mm.getMessage("function.missingParam"));
        }
        this.m_bFunctionParam = false;
        int size = this.param.getSubSize();
        int paramSize = 1 + (size - 2) * 2;
        Object cli = new Object();
        Object[] objs = new Object[paramSize];
        int idx = 0;
        int i = 0;
        while (i < size) {
            MessageManager mm;
            if (this.param.getSub(i) == null) {
                mm = EngineMessage.get();
                throw new RQException("hive_client" + mm.getMessage("function.invalidParam"));
            }
            if (i == 0) {
                cli = this.param.getSub(i).getLeafExpression().calculate(ctx);
                if (!(cli instanceof ImDriverCli)) {
                    mm = EngineMessage.get();
                    throw new RQException("hive_client" + mm.getMessage("function.paramTypeError"));
                }
                this.m_driver = (ImDriverCli)cli;
            } else if (this.param.getSub(i).isLeaf()) {
                objs[idx] = this.param.getSub(i).getLeafExpression().calculate(ctx);
                if (objs[idx] == null || !(objs[idx] instanceof String)) {
                    throw new RQException("hive param " + objs[i - 1] + " type is not String");
                }
                ++idx;
            } else if (this.param.getSub(i).getType() == ':') {
                if (!this.m_bCursor) {
                    this.m_bFunctionParam = true;
                }
                IParam sub = this.param.getSub(i);
                int nChildSize = sub.getSubSize();
                int j = 0;
                while (j < nChildSize) {
                    IParam subChild = sub.getSub(j);
                    if (subChild != null) {
                        objs[idx++] = subChild.getLeafExpression().calculate(ctx);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.m_driver == null) {
            throw new RQException("m_driver is null");
        }
        if (objs.length < 1) {
            throw new RQException("param is empty");
        }
        return this.doQuery(objs);
    }

    protected Object doQuery(Object[] objs) {
        return null;
    }

    protected JCoFunction doJCoFunction(Object[] objs) {
        JCoFunction function = null;
        RfcManager manager = this.m_driver.getRfcManager();
        function = manager.getFunction(objs[0].toString());
        if (function == null) {
            System.out.println("getFunction" + objs[0] + " false");
        } else if ((objs.length - 1) % 2 != 0) {
            System.out.println("excute params is not key:value");
        } else {
            if (this.m_bFunctionParam) {
                int i = 1;
                while (i < objs.length) {
                    String key = objs[i].toString();
                    String val = objs[i + 1].toString();
                    JCoParameterList list = function.getImportParameterList();
                    if (list == null) {
                        System.out.println("excute getImportParameterList is null");
                        break;
                    }
                    list.setValue(key, val);
                    i += 2;
                }
            }
            manager.execute(function);
        }
        return function;
    }

    protected JCoParameterList doJcoOutputParam(Object[] objs) {
        JCoParameterList outputParam = null;
        JCoFunction function = this.doJCoFunction(objs);
        if (function == null) {
            System.out.println("getFunction" + objs[0] + " false");
        } else {
            outputParam = function.getTableParameterList();
        }
        return outputParam;
    }

    protected JCoTable doJcoTable(Object[] objs) {
        JCoTable tb = null;
        JCoParameterList outputParam = this.doJcoOutputParam(objs);
        if (outputParam == null) {
            System.out.println("getTableParameterList" + objs[0] + " false");
        } else {
            tb = outputParam.getTable(objs[1].toString());
        }
        return tb;
    }
}

