/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.sap2_1_1.function;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.DataStruct;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.sap2_1_1.function.ImFunction;
import com.raqsoft.resources.EngineMessage;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;

public class ImGetParam
extends ImFunction {
    private JCoFunction m_function = null;

    @Override
    public Node optimize(Context ctx) {
        super.optimize(ctx);
        return this;
    }

    @Override
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("getparam " + mm.getMessage("param is null"));
        }
        int size = this.param.getSubSize();
        if (size != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("getparam " + mm.getMessage("param size is not 2"));
        }
        Object func = this.param.getSub(0).getLeafExpression().calculate(ctx);
        if (!(func instanceof JCoFunction)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("getparam " + mm.getMessage("function.paramTypeError"));
        }
        this.m_function = (JCoFunction)func;
        Object[] objs = new Object[]{this.param.getSub(1).getLeafExpression().calculate(ctx)};
        return this.doQuery(objs);
    }

    @Override
    public Object doQuery(Object[] objs) {
        Table tb = null;
        JCoParameterList outputList = this.m_function.getExportParameterList();
        if (outputList == null) {
            System.out.println("getTableParameterList" + objs[0] + " false");
        } else {
            String key = objs[objs.length - 1].toString();
            Object val = outputList.getValue(key);
            if (val instanceof JCoStructure) {
                JCoStructure structure = (JCoStructure)val;
                JCoMetaData meta = structure.getMetaData();
                int colSize = meta.getFieldCount();
                this.m_colNames = new String[colSize];
                DataStruct ds = new DataStruct(this.m_colNames);
                tb = new Table(ds, this.m_colNames.length);
                int i = 0;
                while (i < colSize) {
                    this.m_colNames[i] = meta.getName(i);
                    ++i;
                }
                Record r = tb.newLast();
                int i2 = 0;
                while (i2 < structure.getFieldCount()) {
                    r.setNormalFieldValue(i2, structure.getValue(i2));
                    ++i2;
                }
            } else {
                this.m_colNames = new String[]{"value"};
                DataStruct ds = new DataStruct(this.m_colNames);
                tb = new Table(ds, this.m_colNames.length);
                Record r = tb.newLast();
                r.setNormalFieldValue(0, val);
            }
        }
        return tb;
    }
}

