/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.sap2_1_1.function;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.Context;
import com.raqsoft.dm.DataStruct;
import com.raqsoft.dm.Record;
import com.raqsoft.dm.Table;
import com.raqsoft.expression.Node;
import com.raqsoft.lib.sap2_1_1.function.ImFunction;
import com.raqsoft.resources.EngineMessage;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTable;

public class ImTable
extends ImFunction {
    private JCoFunction m_function = null;

    @Override
    public Node optimize(Context ctx) {
        super.optimize(ctx);
        return this;
    }

    @Override
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("getparam " + mm.getMessage("param is null"));
        }
        int size = this.param.getSubSize();
        if (size != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("getparam " + mm.getMessage("param size is not 2"));
        }
        Object func = this.param.getSub(0).getLeafExpression().calculate(ctx);
        if (!(func instanceof JCoFunction)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("getparam " + mm.getMessage("function.paramTypeError"));
        }
        this.m_function = (JCoFunction)func;
        Object[] objs = new Object[]{this.param.getSub(1).getLeafExpression().calculate(ctx)};
        return this.doQuery(objs);
    }

    @Override
    public Object doQuery(Object[] objs) {
        Table tb = null;
        boolean bOK = false;
        String sMsg = "";
        JCoParameterList outputParam = this.m_function.getTableParameterList();
        if (outputParam == null) {
            sMsg = "getTableParameterList" + objs[0] + " false";
            System.out.println(sMsg);
        } else {
            JCoTable bt = outputParam.getTable(objs[0].toString());
            if (bt == null) {
                sMsg = "getTable" + objs[0] + " false";
                System.out.println(sMsg);
            } else {
                int colSize = 0;
                JCoRecordMetaData meta = bt.getRecordMetaData();
                if (meta != null) {
                    colSize = meta.getFieldCount();
                    this.m_colNames = new String[colSize];
                    int i = 0;
                    while (i < colSize) {
                        this.m_colNames[i] = meta.getName(i);
                        ++i;
                    }
                }
                DataStruct ds = new DataStruct(this.m_colNames);
                tb = new Table(ds, this.m_colNames.length);
                int i = 0;
                while (i < bt.getNumRows()) {
                    bt.setRow(i);
                    Record r = tb.newLast();
                    int j = 0;
                    while (j < colSize) {
                        r.setNormalFieldValue(j, bt.getValue(j));
                        ++j;
                    }
                    ++i;
                }
                bOK = true;
            }
        }
        if (!bOK) {
            this.m_driver.close();
            throw new RQException(sMsg);
        }
        return tb;
    }
}

