/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.sap2_1_1.function;

import com.raqsoft.lib.sap2_1_1.function.IMultiStepJob;
import com.raqsoft.lib.sap2_1_1.function.RfcSessionReference;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JcoMutiThread
extends Thread {
    public static Hashtable<IMultiStepJob, RfcSessionReference> sessions = new Hashtable();
    public static ThreadLocal<RfcSessionReference> localSessionReference = new ThreadLocal();
    private BlockingQueue<IMultiStepJob> queue;
    private CountDownLatch doneSignal;
    private boolean isSapBusy = false;

    public JcoMutiThread(CountDownLatch doneSignal, BlockingQueue<IMultiStepJob> queue) {
        this.doneSignal = doneSignal;
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            try {
                IMultiStepJob job;
                while ((job = this.queue.poll(10L, TimeUnit.SECONDS)) != null) {
                    RfcSessionReference sesRef;
                    if (this.isSapBusy) {
                        Thread.sleep(5000L);
                    }
                    if ((sesRef = sessions.get(job)) == null) {
                        sesRef = new RfcSessionReference();
                        sessions.put(job, sesRef);
                    }
                    localSessionReference.set(sesRef);
                    try {
                        this.isSapBusy = job.runNextStep();
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                    if (this.isSapBusy) {
                        this.queue.add(job);
                    } else {
                        sessions.remove(job);
                        job.cleanUp();
                    }
                    localSessionReference.set(null);
                }
            }
            catch (InterruptedException interruptedException) {
                this.doneSignal.countDown();
            }
        }
        finally {
            this.doneSignal.countDown();
        }
    }
}

