/*
 * Decompiled with CFR 0.152.
 */
package com.raqsoft.lib.sap2_1_1.function;

import com.raqsoft.common.MessageManager;
import com.raqsoft.common.RQException;
import com.raqsoft.dm.FileObject;
import com.raqsoft.lib.sap2_1_1.function.JCOProvider;
import com.raqsoft.resources.EngineMessage;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public final class RfcManager {
    private static final String ABAP_AS_POOLED = "ABAP_AS_POOL";
    private JCOProvider provider;
    private JCoDestination destination;

    static {
        try {
            String jcoPath = System.getProperty("JAVA_SAPJCO");
            if (jcoPath == null) {
                String path = System.getProperty("user.dir");
                path = path.replace("\\bin", "\\lib");
                System.setProperty("JAVA_SAPJCO=", path);
            }
        }
        catch (IllegalStateException e) {
            System.out.println(e.getMessage());
        }
    }

    public RfcManager() {
    }

    public RfcManager(String fileName, String charset) {
        FileObject fo = new FileObject(fileName);
        if (charset != null) {
            fo.setCharset(charset);
        }
        this.init(fo);
    }

    public void init(FileObject fo) {
        try {
            if (fo == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("fileName:" + fo.getFileName() + " is not existed");
            }
            Properties props = new Properties();
            if (fo.getCharset() != null) {
                InputStreamReader ist = new InputStreamReader(fo.getInputStream(), fo.getCharset());
                props.load(ist);
            } else {
                props.load(fo.getInputStream());
            }
            this.provider = new JCOProvider();
            if (!Environment.isDestinationDataProviderRegistered()) {
                Environment.registerDestinationDataProvider((DestinationDataProvider)this.provider);
            }
            this.provider.changePropertiesForABAP_AS(ABAP_AS_POOLED, props);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RfcManager(String user, String passwd, String ashost, String sysnr, String client, String lang) {
        try {
            Properties props = new Properties();
            props.setProperty("jco.client.user", user);
            props.setProperty("jco.client.passwd", passwd);
            props.setProperty("jco.client.ashost", ashost);
            props.setProperty("jco.client.client", client);
            props.setProperty("jco.client.sysnr", sysnr);
            props.setProperty("jco.client.lang", lang);
            props.setProperty("jco.destination.peak_limit", "3");
            props.setProperty("jco.destination.pool_capacity", "11");
            this.provider = new JCOProvider();
            if (!Environment.isDestinationDataProviderRegistered()) {
                Environment.registerDestinationDataProvider((DestinationDataProvider)this.provider);
            }
            this.provider.changePropertiesForABAP_AS(ABAP_AS_POOLED, props);
        }
        catch (IllegalStateException e) {
            System.out.println(e.getMessage());
        }
    }

    public JCoDestination getDestination() throws JCoException {
        if (this.destination == null) {
            this.destination = JCoDestinationManager.getDestination((String)ABAP_AS_POOLED);
        }
        return this.destination;
    }

    public void execute(JCoFunction function) {
        System.out.println("SAP Function Name : " + function.getName());
        try {
            function.execute(this.getDestination());
        }
        catch (JCoException e) {
            e.printStackTrace();
        }
    }

    public JCoFunction getFunction(String functionName) {
        JCoFunction function = null;
        try {
            function = this.getDestination().getRepository().getFunctionTemplate(functionName).getFunction();
        }
        catch (JCoException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return function;
    }

    public void close() {
        if (this.provider != null) {
            this.provider.changePropertiesForABAP_AS(ABAP_AS_POOLED, null);
            Environment.unregisterDestinationDataProvider((DestinationDataProvider)this.provider);
            this.provider = null;
        }
    }
}

