/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.annotation;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndex;
import com.frameworkset.orm.annotation.NameParserException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.tokenizer.TextGrammarParser;

public class ESIndexWrapper {
    private static TextGrammarParser.GrammarTokenBuilder<NameGrammarToken> nameGrammarTokenBuilder = new NameGrammarTokenBuilder();
    private NameInfo nameInfo;
    private TypeInfo typeInfo;
    private String index;
    private String type;
    private ESIndex esIndex;
    private boolean useBatchContextIndexName;
    private boolean useBatchContextIndexType;

    public boolean isUseBatchContextIndexName() {
        return this.useBatchContextIndexName;
    }

    public void setUseBatchContextIndexName(boolean useBatchContextIndexName) {
        this.useBatchContextIndexName = useBatchContextIndexName;
    }

    public boolean isUseBatchContextIndexType() {
        return this.useBatchContextIndexType;
    }

    public void setUseBatchContextIndexType(boolean useBatchContextIndexType) {
        this.useBatchContextIndexType = useBatchContextIndexType;
    }

    public NameInfo getNameInfo() {
        return this.nameInfo;
    }

    public void setNameInfo(NameInfo nameInfo) {
        this.nameInfo = nameInfo;
    }

    public ESIndex getEsIndex() {
        return this.esIndex;
    }

    public void setEsIndex(ESIndex esIndex) {
        this.esIndex = esIndex;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.getNameInfo().getName();
    }

    public List<NameGrammarToken> getNameTokens() {
        return this.getNameInfo().getTokens();
    }

    public boolean isOnlyCurrentDateTimestamp() {
        return this.getNameInfo().isOnlyCurrentDateTimestamp();
    }

    private static Map<String, String> parserVarinfo(String var) {
        int idx = var.indexOf("=");
        HashMap<String, String> varinfo = new HashMap<String, String>();
        if (idx > 0) {
            String[] arr = var.split(",");
            for (int i = 0; i < arr.length; ++i) {
                String e = arr[i];
                String[] attr = e.split("=");
                if (attr.length == 1) {
                    throw new NameParserException("varible syntax error:" + var + "," + e + " must be a express like xxx=vvvv");
                }
                varinfo.put(attr[0], attr[1]);
            }
        } else {
            idx = var.indexOf(",");
            if (idx > 0) {
                String[] datas = var.split(",");
                varinfo.put("field", datas[0].trim());
                varinfo.put("dateformat", datas[1].trim());
            } else {
                varinfo.put("field", var);
            }
        }
        return varinfo;
    }

    public ESIndexWrapper(ESIndex esIndex) {
        this.esIndex = esIndex;
        this.useBatchContextIndexName = esIndex.useBatchContextIndexName();
        this.useBatchContextIndexType = esIndex.useBatchContextIndexType();
        this.initInfo(esIndex.name(), esIndex.type());
    }

    public ESIndexWrapper(String indexPattern, String typePattern) {
        this.initInfo(indexPattern, typePattern);
    }

    private void initInfo(String name, String type) {
        NameGrammarToken token;
        int i;
        this.index = name;
        this.type = type;
        if (type != null && type.equals("")) {
            type = null;
        }
        this.nameInfo = new NameInfo();
        List<NameGrammarToken> tokens = TextGrammarParser.parser(this.index, '{', '}', nameGrammarTokenBuilder);
        boolean varibled = false;
        int varcount = 0;
        NameGrammarToken one = null;
        for (i = 0; tokens != null && i < tokens.size(); ++i) {
            token = tokens.get(i);
            if (!token.varibletoken()) continue;
            varibled = true;
            ++varcount;
            if (one != null) continue;
            one = token;
        }
        if (varibled) {
            this.nameInfo.tokens = tokens;
            if (varcount == 1 && one.getFieldName() == null) {
                this.nameInfo.onlyCurrentDateTimestamp = true;
            }
        } else {
            this.nameInfo.name = this.index;
        }
        if (type != null) {
            varcount = 0;
            one = null;
            this.typeInfo = new TypeInfo();
            tokens = TextGrammarParser.parser(type, '{', '}', nameGrammarTokenBuilder);
            varibled = false;
            for (i = 0; tokens != null && i < tokens.size(); ++i) {
                token = tokens.get(i);
                if (!token.varibletoken()) continue;
                varibled = true;
                ++varcount;
                if (one != null) continue;
                one = token;
            }
            if (varibled) {
                this.typeInfo.tokens = tokens;
            } else {
                this.typeInfo.type = type;
            }
        }
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public static class NameInfo {
        protected String name;
        protected boolean onlyCurrentDateTimestamp;
        private List<NameGrammarToken> tokens;

        public String getName() {
            return this.name;
        }

        public boolean isOnlyCurrentDateTimestamp() {
            return this.onlyCurrentDateTimestamp;
        }

        public List<NameGrammarToken> getTokens() {
            return this.tokens;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("name:").append(this.name).append(",onlyCurrentDateTimestamp:").append(this.onlyCurrentDateTimestamp);
            if (this.tokens != null) {
                builder.append(",tokens:").append(this.tokens.toString());
            }
            return builder.toString();
        }
    }

    public static class NameGrammarToken
    extends TextGrammarParser.GrammarToken {
        protected String fieldName;
        protected DateFormateMeta dateFormateMeta;
        protected String dateformat;

        @Override
        public void after() {
            try {
                if (this.varibletoken()) {
                    Map varinfo = ESIndexWrapper.parserVarinfo(this.text);
                    this.fieldName = (String)varinfo.get("field");
                    this.dateformat = (String)varinfo.get("dateformat");
                    if (this.dateformat != null) {
                        this.dateFormateMeta = DateFormateMeta.buildDateFormateMeta(this.dateformat);
                    }
                }
            }
            catch (Exception e) {
                throw new NameParserException(this.toString(), e);
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public DateFormateMeta getDateFormateMeta() {
            return this.dateFormateMeta;
        }

        public String getDateformat() {
            return this.dateformat;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("fieldName=").append(this.fieldName).append("|");
            builder.append("dateformat=").append(this.dateformat).append("|");
            builder.append(super.toString());
            return builder.toString();
        }
    }

    public static class TypeInfo {
        private String type;
        private List<NameGrammarToken> tokens;

        public String getType() {
            return this.type;
        }

        public List<NameGrammarToken> getTokens() {
            return this.tokens;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("type:").append(this.type);
            if (this.tokens != null) {
                builder.append(",tokens:").append(this.tokens.toString());
            }
            return builder.toString();
        }
    }

    public static class NameGrammarTokenBuilder
    implements TextGrammarParser.GrammarTokenBuilder<NameGrammarToken> {
        @Override
        public NameGrammarToken buildGrammarToken() {
            return new NameGrammarToken();
        }
    }

    public static interface GetVariableValue {
        public Object getValue(String var1);

        public BatchContext getBatchContext();

        public void setBatchContext(BatchContext var1);
    }
}

