/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import java.math.BigDecimal;

public abstract class ValueCastUtil {
    public static int toInt(Object value, int defaultValue) throws Exception {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    public static long toLong(Object value, long defaultValue) throws Exception {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(String.valueOf(value));
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value.equals("true");
    }

    public static String toString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public static Integer integerValue(Object num, Integer defaultValue) {
        return ValueCastUtil.intValue(num, defaultValue);
    }

    public static Long longValue(Object num, Long defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Long) {
            return (Long)num;
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).longValue();
        }
        if (num instanceof Double) {
            return ((Double)num).longValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).longValue();
        }
        if (num instanceof Float) {
            return ((Float)num).longValue();
        }
        if (num instanceof Short) {
            return ((Short)num).longValue();
        }
        return Long.parseLong(num.toString());
    }

    public static Integer intValue(Object num, Integer defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Integer) {
            return (Integer)num;
        }
        if (num instanceof Long) {
            return ((Long)num).intValue();
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).intValue();
        }
        if (num instanceof Double) {
            return ((Double)num).intValue();
        }
        if (num instanceof Float) {
            return ((Float)num).intValue();
        }
        if (num instanceof Short) {
            return ((Short)num).intValue();
        }
        return Integer.parseInt(num.toString());
    }

    public static Float floatValue(Object num, Float defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Float) {
            return (Float)num;
        }
        if (num instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)num).floatValue());
        }
        if (num instanceof Double) {
            return Float.valueOf(((Double)num).floatValue());
        }
        if (num instanceof Integer) {
            return Float.valueOf(((Integer)num).floatValue());
        }
        if (num instanceof Long) {
            return Float.valueOf(((Long)num).floatValue());
        }
        if (num instanceof Short) {
            return Float.valueOf(((Short)num).floatValue());
        }
        return Float.valueOf(Float.parseFloat(num.toString()));
    }

    public static String stringValue(Object num, String defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof String) {
            return (String)num;
        }
        return String.valueOf(num);
    }

    public static Double doubleValue(Object num, Double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Double) {
            return (Double)num;
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).doubleValue();
        }
        if (num instanceof Float) {
            return ((Float)num).doubleValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).doubleValue();
        }
        if (num instanceof Long) {
            return ((Long)num).doubleValue();
        }
        if (num instanceof Short) {
            return ((Short)num).doubleValue();
        }
        return Double.parseDouble(num.toString());
    }
}

