/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.frameworkset.util.DataFormat;

public class DataFormatUtil {
    public static String DataFormatUtilKey = "org.bboss.dataformat";
    private static final ThreadLocal<DataFormat> dateformatThreadLocal = new ThreadLocal();

    public static DataFormat initDateformatThreadLocal() {
        DataFormat dataFormat = dateformatThreadLocal.get();
        if (dataFormat == null) {
            dataFormat = new DataFormat();
            dateformatThreadLocal.set(dataFormat);
        } else {
            dataFormat.increament();
        }
        return dataFormat;
    }

    public static DataFormat getDateformatThreadLocal() {
        return dateformatThreadLocal.get();
    }

    public static void releaseDateformatThreadLocal() {
        DataFormat dataFormat = dateformatThreadLocal.get();
        if (dataFormat == null) {
            return;
        }
        if (dataFormat.reachroot()) {
            dateformatThreadLocal.set(null);
        }
        dataFormat.decreament();
    }

    public static SimpleDateFormat getSimpleDateFormat(HttpServletRequest request, String dateFormat) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            if (request == null) {
                return new SimpleDateFormat(dateFormat);
            }
            dataFormatUtil = (DataFormat)request.getAttribute(DataFormatUtilKey);
            if (dataFormatUtil == null) {
                dataFormatUtil = new DataFormat();
                request.setAttribute(DataFormatUtilKey, (Object)dataFormatUtil);
            }
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat);
        return temp;
    }

    public static Date getDate(HttpServletRequest request, String dateFormat, String date) throws ParseException {
        SimpleDateFormat temp = null;
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            if (request == null) {
                temp = new SimpleDateFormat(dateFormat);
            } else {
                dataFormatUtil = (DataFormat)request.getAttribute(DataFormatUtilKey);
                if (dataFormatUtil == null) {
                    dataFormatUtil = new DataFormat();
                    request.setAttribute(DataFormatUtilKey, (Object)dataFormatUtil);
                }
                temp = dataFormatUtil.getSimpleDateFormat(dateFormat);
            }
        } else {
            temp = dataFormatUtil.getSimpleDateFormat(dateFormat);
        }
        return temp.parse(date);
    }

    public static SimpleDateFormat getSimpleDateFormat(HttpServletRequest request, String dateFormat, Locale locale, TimeZone timeZone) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            if (request == null) {
                SimpleDateFormat format;
                SimpleDateFormat simpleDateFormat = format = locale == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, locale);
                if (timeZone != null) {
                    format.setTimeZone(timeZone);
                }
                return format;
            }
            dataFormatUtil = (DataFormat)request.getAttribute(DataFormatUtilKey);
            if (dataFormatUtil == null) {
                dataFormatUtil = new DataFormat();
                request.setAttribute(DataFormatUtilKey, (Object)dataFormatUtil);
            }
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale, timeZone);
        return temp;
    }

    public static SimpleDateFormat getSimpleDateFormat(HttpServletRequest request, String dateFormat, Locale locale, String timeZone) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            if (request == null) {
                SimpleDateFormat format;
                SimpleDateFormat simpleDateFormat = format = locale == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, locale);
                if (timeZone != null) {
                    format.setTimeZone(TimeZone.getTimeZone(timeZone));
                }
                return format;
            }
            dataFormatUtil = (DataFormat)request.getAttribute(DataFormatUtilKey);
            if (dataFormatUtil == null) {
                dataFormatUtil = new DataFormat();
                request.setAttribute(DataFormatUtilKey, (Object)dataFormatUtil);
            }
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale, timeZone);
        return temp;
    }

    public static SimpleDateFormat getSimpleDateFormat(HttpServletRequest request, String dateFormat, String locale, String timeZone) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            if (request == null) {
                SimpleDateFormat format;
                SimpleDateFormat simpleDateFormat = format = locale == null || locale.equals("") ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, new Locale(locale));
                if (timeZone != null) {
                    format.setTimeZone(TimeZone.getTimeZone(timeZone));
                }
                return format;
            }
            dataFormatUtil = (DataFormat)request.getAttribute(DataFormatUtilKey);
            if (dataFormatUtil == null) {
                dataFormatUtil = new DataFormat();
                request.setAttribute(DataFormatUtilKey, (Object)dataFormatUtil);
            }
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale, timeZone);
        return temp;
    }

    public static DecimalFormat getDecimalFormat(HttpServletRequest request, String decimalFormat) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            if (request == null) {
                return new DecimalFormat(decimalFormat);
            }
            dataFormatUtil = (DataFormat)request.getAttribute(DataFormatUtilKey);
            if (dataFormatUtil == null) {
                dataFormatUtil = new DataFormat();
                request.setAttribute(DataFormatUtilKey, (Object)dataFormatUtil);
            }
        }
        DecimalFormat temp = dataFormatUtil.getDecimalFormat(decimalFormat);
        return temp;
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateFormat) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            return new SimpleDateFormat(dateFormat);
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat);
        return temp;
    }

    public static Date getDate(String dateFormat, String date) throws ParseException {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        SimpleDateFormat temp = null;
        temp = dataFormatUtil != null ? dataFormatUtil.getSimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat);
        return temp.parse(date);
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateFormat, Locale locale, TimeZone timeZone) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            SimpleDateFormat format;
            SimpleDateFormat simpleDateFormat = format = locale == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, locale);
            if (timeZone != null) {
                format.setTimeZone(timeZone);
            }
            return format;
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale, timeZone);
        return temp;
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateFormat, Locale locale) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            SimpleDateFormat format = locale == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, locale);
            return format;
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale);
        return temp;
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateFormat, Locale locale, String timeZone) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            SimpleDateFormat format;
            SimpleDateFormat simpleDateFormat = format = locale == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, locale);
            if (timeZone != null) {
                format.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return format;
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale, timeZone);
        return temp;
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateFormat, String locale, String timeZone) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            SimpleDateFormat format;
            SimpleDateFormat simpleDateFormat = format = locale == null || locale.equals("") ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, new Locale(locale));
            if (timeZone != null) {
                format.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return format;
        }
        SimpleDateFormat temp = dataFormatUtil.getSimpleDateFormat(dateFormat, locale, timeZone);
        return temp;
    }

    public static DecimalFormat getDecimalFormat(String decimalFormat) {
        DataFormat dataFormatUtil = DataFormatUtil.getDateformatThreadLocal();
        if (dataFormatUtil == null) {
            return new DecimalFormat(decimalFormat);
        }
        DecimalFormat temp = dataFormatUtil.getDecimalFormat(decimalFormat);
        return temp;
    }
}

