/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.frameworkset.util.EditorInf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.ParameterNameDiscoverer;
import org.frameworkset.util.ReflectionUtils;
import org.frameworkset.util.annotations.MapKey;
import org.frameworkset.util.annotations.MethodInfo;
import org.frameworkset.util.annotations.Scope;
import org.frameworkset.util.annotations.wraper.AttributeWraper;
import org.frameworkset.util.annotations.wraper.CookieValueWraper;
import org.frameworkset.util.annotations.wraper.PagerParamWraper;
import org.frameworkset.util.annotations.wraper.PathVariableWraper;
import org.frameworkset.util.annotations.wraper.RequestBodyWraper;
import org.frameworkset.util.annotations.wraper.RequestHeaderWraper;
import org.frameworkset.util.annotations.wraper.RequestParamWraper;

public class MethodParameter {
    private static final Method methodParameterAnnotationsMethod = ClassUtils.getMethodIfAvailable(Method.class, "getParameterAnnotations", new Class[0]);
    private static final Method constructorParameterAnnotationsMethod = ClassUtils.getMethodIfAvailable(Constructor.class, "getParameterAnnotations", new Class[0]);
    private Method method;
    private MethodInfo methodInfo;
    private EditorInf editor;
    private Constructor constructor;
    private final int parameterIndex;
    private Class parameterType;
    private Class[] parameterElementTypes;
    private Object[] parameterAnnotations;
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private boolean isrequestbody;
    private String parameterName;
    private String origineRequestParamName;
    private boolean namevariabled = false;
    private List<ClassUtil.Var> requestParamNameToken;
    private boolean dataBeanBind;
    private Scope requestScope = null;
    private int nestingLevel = 1;
    private Map typeIndexesPerLevel;
    private Map typeVariableMap;
    private String paramNamePrefix;
    private RequestParamWraper requestParam;
    private RequestHeaderWraper requestHeader;
    private AttributeWraper attribute;
    private PagerParamWraper pagerParam;
    private RequestBodyWraper requestBody;
    private MapKey mapKey;
    private boolean primaryType;
    private boolean multiAnnotations = false;
    private List<MethodParameter> multiAnnotationParams;
    private Object lock = new Object();
    private boolean required = false;
    private Object defaultValue;
    private PathVariableWraper pathVariable;
    private CookieValueWraper cookieValue;

    public void setOrigineRequestParamName(String origineRequestParamName) {
        this.origineRequestParamName = origineRequestParamName;
    }

    public Class[] getParameterElementTypes() {
        this.initParameterTypes();
        return this.parameterElementTypes;
    }

    public Class getParameterElementType() {
        this.initParameterTypes();
        return this.parameterElementTypes != null && this.parameterElementTypes.length > 0 ? this.parameterElementTypes[0] : null;
    }

    public void setNamevariabled(boolean namevariabled) {
        this.namevariabled = namevariabled;
    }

    public boolean isNamevariabled() {
        return this.namevariabled;
    }

    public String getOrigineRequestParamName() {
        return this.origineRequestParamName;
    }

    public List<ClassUtil.Var> getRequestParamNameToken() {
        return this.requestParamNameToken;
    }

    public void setRequestParamNameToken(List<ClassUtil.Var> requestParamNameToken) {
        this.requestParamNameToken = requestParamNameToken;
    }

    public MethodParameter(Method method, int parameterIndex) {
        this(method, parameterIndex, 1);
    }

    public MethodParameter(Method method, int parameterIndex, int nestingLevel) {
        Assert.notNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public MethodParameter(Constructor constructor, int parameterIndex) {
        this(constructor, parameterIndex, 1);
    }

    public MethodParameter(Constructor constructor, int parameterIndex, int nestingLevel) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.constructor = constructor;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public MethodParameter(MethodParameter original) {
        Assert.notNull(original, "Original must not be null");
        this.method = original.method;
        this.constructor = original.constructor;
        this.parameterIndex = original.parameterIndex;
        this.parameterType = original.parameterType;
        this.parameterAnnotations = original.parameterAnnotations;
        this.typeVariableMap = original.typeVariableMap;
        this.parameterElementTypes = original.parameterElementTypes;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    void setParameterType(Class parameterType) {
        this.parameterType = parameterType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParameterTypes() {
        if (this.parameterType == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.parameterType == null) {
                    if (this.method != null) {
                        this.parameterType = this.method.getParameterTypes()[this.parameterIndex];
                        this.parameterElementTypes = ClassUtils.genericParameterTypes(this.method, this.parameterIndex);
                    } else if (this.constructor != null) {
                        this.parameterType = this.constructor.getParameterTypes()[this.parameterIndex];
                        this.parameterElementTypes = ClassUtils.genericParameterTypes(this.constructor, this.parameterIndex);
                    }
                }
            }
        }
    }

    public Class getParameterType() {
        this.initParameterTypes();
        return this.parameterType;
    }

    public Object[] getParameterAnnotations() {
        if (this.parameterAnnotations != null) {
            return this.parameterAnnotations;
        }
        if (methodParameterAnnotationsMethod == null) {
            return null;
        }
        Object[][] annotationArray = this.method != null ? (Object[][])ReflectionUtils.invokeMethod(methodParameterAnnotationsMethod, this.method) : (Object[][])ReflectionUtils.invokeMethod(constructorParameterAnnotationsMethod, this.constructor);
        this.parameterAnnotations = annotationArray[this.parameterIndex];
        return this.parameterAnnotations;
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public String getMethodParameterName() {
        String parameterName = null;
        if (parameterName == null && this.parameterNameDiscoverer != null) {
            String[] parameterNames;
            String[] stringArray = parameterNames = this.method != null ? this.parameterNameDiscoverer.getParameterNames(this.method) : this.parameterNameDiscoverer.getParameterNames(this.constructor);
            if (parameterNames != null) {
                parameterName = parameterNames[this.parameterIndex];
            }
            this.parameterNameDiscoverer = null;
        }
        return parameterName;
    }

    public String getRequestParameterName() {
        return this.parameterName;
    }

    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(this.nestingLevel);
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public void setTypeIndexForCurrentLevel(int typeIndex) {
        this.getTypeIndexesPerLevel().put(this.nestingLevel, typeIndex);
    }

    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    public Integer getTypeIndexForLevel(int nestingLevel) {
        return (Integer)this.getTypeIndexesPerLevel().get(nestingLevel);
    }

    private Map getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap(4);
        }
        return this.typeIndexesPerLevel;
    }

    public static MethodParameter forMethodOrConstructor(Object methodOrConstructor, int parameterIndex) {
        if (methodOrConstructor instanceof Method) {
            return new MethodParameter((Method)methodOrConstructor, parameterIndex);
        }
        if (methodOrConstructor instanceof Constructor) {
            return new MethodParameter((Constructor)methodOrConstructor, parameterIndex);
        }
        throw new IllegalArgumentException("Given object [" + methodOrConstructor + "] is neither a Method nor a Constructor");
    }

    public EditorInf getEditor() {
        return this.editor;
    }

    public void setEditor(EditorInf editor) {
        this.editor = editor;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setDataBeanBind(boolean dataBeanBind) {
        this.dataBeanBind = dataBeanBind;
    }

    public boolean isDataBeanBind() {
        return this.dataBeanBind;
    }

    public void setDataBindScope(Scope requestScope) {
        this.requestScope = requestScope;
    }

    public Scope getDataBindScope() {
        return this.requestScope;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isMultiAnnotations() {
        return this.multiAnnotations;
    }

    public void setMultiAnnotations(boolean multiAnnotations) {
        this.multiAnnotations = multiAnnotations;
    }

    public List<MethodParameter> getMultiAnnotationParams() {
        return this.multiAnnotationParams;
    }

    public void setMultiAnnotationParams(List<MethodParameter> multiAnnotationParams) {
        if (multiAnnotationParams != null && multiAnnotationParams.size() > 0) {
            this.setMultiAnnotations(true);
        }
        this.multiAnnotationParams = multiAnnotationParams;
    }

    public Map getTypeVariableMap() {
        return this.typeVariableMap;
    }

    protected void setTypeVariableMap(Map typeVariableMap) {
        this.typeVariableMap = typeVariableMap;
    }

    public String getParamNamePrefix() {
        return this.paramNamePrefix;
    }

    public void setParamNamePrefix(String paramNamePrefix) {
        this.paramNamePrefix = paramNamePrefix;
    }

    public RequestParamWraper getRequestParam() {
        return this.requestParam;
    }

    public void setRequestParam(RequestParamWraper requestParam) {
        this.requestParam = requestParam;
    }

    public void setPathVariable(PathVariableWraper param) {
        this.pathVariable = param;
    }

    public PathVariableWraper getPathVariable() {
        return this.pathVariable;
    }

    public CookieValueWraper getCookieValue() {
        return this.cookieValue;
    }

    public void setCookieValue(CookieValueWraper cookieValue) {
        this.cookieValue = cookieValue;
    }

    public AttributeWraper getAttribute() {
        return this.attribute;
    }

    public void setAttribute(AttributeWraper attribute) {
        this.attribute = attribute;
    }

    public RequestHeaderWraper getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(RequestHeaderWraper requestHeader) {
        this.requestHeader = requestHeader;
    }

    public void setMapKey(MapKey mapKey) {
        this.mapKey = mapKey;
    }

    public MapKey getMapKey() {
        return this.mapKey;
    }

    public boolean isPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(boolean isPrimaryType) {
        this.primaryType = isPrimaryType;
    }

    public PagerParamWraper getPagerParam() {
        return this.pagerParam;
    }

    public void setPagerParam(PagerParamWraper pagerParam) {
        this.pagerParam = pagerParam;
    }

    public boolean isIsrequestbody() {
        return this.isrequestbody;
    }

    public void setIsrequestbody(boolean isrequestbody) {
        this.isrequestbody = isrequestbody;
    }

    public RequestBodyWraper getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBodyWraper requestBody) {
        this.requestBody = requestBody;
    }

    private boolean innerRequestBody() {
        if (this.multiAnnotationParams == null || this.multiAnnotationParams.size() == 0) {
            return false;
        }
        for (MethodParameter p : this.multiAnnotationParams) {
            if (p.getRequestBody() == null) continue;
            return true;
        }
        return false;
    }

    public boolean requestbody() {
        return this.isrequestbody || this.innerRequestBody();
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public void setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }
}

