/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockedRejectedExecutionHandler
implements RejectedExecutionHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicInteger rejectCounts = new AtomicInteger();
    private long blockedWaitTimeout;
    private int warnMultsRejects = 1000;
    private String message;

    public BlockedRejectedExecutionHandler(String message, long blockedWaitTimeout) {
        this(message, blockedWaitTimeout, 1000);
    }

    public BlockedRejectedExecutionHandler(String message, long blockedWaitTimeout, int warnMultsRejects) {
        this.blockedWaitTimeout = blockedWaitTimeout;
        this.message = message;
        this.warnMultsRejects = warnMultsRejects;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        int t;
        int counts = this.rejectCounts.incrementAndGet();
        if (this.logger.isWarnEnabled() && (t = counts % this.warnMultsRejects) == 0) {
            this.logger.warn("Task[" + this.message + "] blocked " + counts + " times.");
        }
        try {
            if (this.blockedWaitTimeout <= 0L) {
                executor.getQueue().put(r);
            } else {
                boolean result = executor.getQueue().offer(r, this.blockedWaitTimeout, TimeUnit.MILLISECONDS);
                if (!result) {
                    throw new RejectedExecutionException("Task[" + this.message + "] rejected: wait timeout after " + this.blockedWaitTimeout + " MILLISECONDS.");
                }
            }
        }
        catch (InterruptedException e1) {
            throw new RejectedExecutionException(e1);
        }
    }
}

