/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.tokenizer;

import java.util.ArrayList;
import java.util.List;

public class TextGrammarParser {
    private static final GrammarTokenBuilder<GrammarToken> defaultGrammarTokenBuilder = new GrammarTokenBuilder<GrammarToken>(){

        @Override
        public GrammarToken buildGrammarToken() {
            return new GrammarToken();
        }
    };

    private static boolean tplstart(char value, char[] pre, String text, int textsize, int curpos) {
        boolean tplstart = true;
        int k = 0;
        for (int i = 1; i < pre.length; ++i) {
            k = curpos + i;
            if (k < textsize && text.charAt(k) == pre[i]) continue;
            tplstart = false;
            break;
        }
        return tplstart;
    }

    private static boolean tplend(char value, char[] end, String text, int textsize, int curpos) {
        boolean tplstart = true;
        int k = 0;
        for (int i = 1; i < end.length; ++i) {
            k = curpos + i;
            if (k < textsize && text.charAt(k) == end[i]) continue;
            tplstart = false;
            break;
        }
        return tplstart;
    }

    public static List<GrammarToken> parser(String content, char tokenpre, char tokenend) {
        return TextGrammarParser.parser(content, new char[]{tokenpre}, tokenend, Character.valueOf(tokenpre), defaultGrammarTokenBuilder);
    }

    public static <T extends GrammarToken> List<T> parser(String content, char tokenpre, char tokenend, GrammarTokenBuilder<T> grammarTokenBuilder) {
        return TextGrammarParser.parser(content, new char[]{tokenpre}, tokenend, Character.valueOf(tokenpre), grammarTokenBuilder);
    }

    public static <T extends GrammarToken> List<T> parser(String content, char[] pre, char tokenend, Object tokenpre, GrammarTokenBuilder<T> grammarTokenBuilder) {
        StringBuilder builder = new StringBuilder();
        StringBuilder tplbuilder = new StringBuilder();
        ArrayList<GrammarToken> tokens = new ArrayList<GrammarToken>();
        int size = content.length();
        boolean tplstart = false;
        for (int i = 0; i < size; ++i) {
            char c = content.charAt(i);
            if (c == pre[0]) {
                if (TextGrammarParser.tplstart(c, pre, content, size, i)) {
                    if (tplstart) {
                        builder.append(tokenpre).append(tplbuilder.toString());
                        tplbuilder.setLength(0);
                    } else {
                        tplstart = true;
                    }
                    i = i + pre.length - 1;
                    continue;
                }
                if (tplstart) {
                    tplbuilder.append(c);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == tokenend) {
                if (tplstart) {
                    if (tplbuilder.length() > 0) {
                        GrammarToken stringtoken;
                        if (builder.length() > 0) {
                            stringtoken = (GrammarToken)grammarTokenBuilder.buildGrammarToken();
                            stringtoken.position = tokens.size();
                            stringtoken.text = builder.toString();
                            stringtoken.type = 0;
                            builder.setLength(0);
                            stringtoken.after();
                            tokens.add(stringtoken);
                        }
                        stringtoken = (GrammarToken)grammarTokenBuilder.buildGrammarToken();
                        stringtoken.position = tokens.size();
                        String txt = tplbuilder.toString();
                        int pos = txt.indexOf(":");
                        String defaultValue = null;
                        if (pos > 0) {
                            defaultValue = txt.substring(pos + 1);
                            txt = txt.substring(0, pos);
                            stringtoken.setDefaultValue(defaultValue);
                        }
                        stringtoken.text = txt;
                        stringtoken.type = 1;
                        tplbuilder.setLength(0);
                        stringtoken.after();
                        tokens.add(stringtoken);
                    } else {
                        builder.append(tokenpre).append(tokenend);
                    }
                    tplstart = false;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (tplstart) {
                tplbuilder.append(c);
                continue;
            }
            builder.append(c);
        }
        if (tplbuilder.length() > 0) {
            builder.append(tokenpre).append(tplbuilder.toString());
        }
        tplbuilder = null;
        if (builder.length() > 0) {
            GrammarToken stringtoken = (GrammarToken)grammarTokenBuilder.buildGrammarToken();
            stringtoken.position = tokens.size();
            stringtoken.text = builder.toString();
            stringtoken.type = 0;
            builder.setLength(0);
            stringtoken.after();
            tokens.add(stringtoken);
        }
        builder = null;
        return tokens;
    }

    public static <T extends GrammarToken> List<T> parser(String content, String tokenpre, char tokenend, GrammarTokenBuilder<T> grammarTokenBuilder) {
        return TextGrammarParser.parser(content, tokenpre.toCharArray(), tokenend, tokenpre, grammarTokenBuilder);
    }

    public static List<GrammarToken> parser(String content, String tokenpre, char tokenend) {
        return TextGrammarParser.parser(content, tokenpre.toCharArray(), tokenend, tokenpre, defaultGrammarTokenBuilder);
    }

    public static List<GrammarToken> parser(String content, String tokenPre, String tokenEnd) {
        StringBuilder builder = new StringBuilder();
        StringBuilder tplbuilder = new StringBuilder();
        ArrayList<GrammarToken> tokens = new ArrayList<GrammarToken>();
        int size = content.length();
        char[] pre = tokenPre.toCharArray();
        char[] end = tokenEnd.toCharArray();
        boolean tplstart = false;
        for (int i = 0; i < size; ++i) {
            char c = content.charAt(i);
            if (c == pre[0]) {
                if (TextGrammarParser.tplstart(c, pre, content, size, i)) {
                    if (tplstart) {
                        builder.append(tokenPre).append(tplbuilder.toString());
                        tplbuilder.setLength(0);
                    } else {
                        tplstart = true;
                    }
                    i = i + pre.length - 1;
                    continue;
                }
                if (tplstart) {
                    tplbuilder.append(c);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == end[0]) {
                if (TextGrammarParser.tplend(c, end, content, size, i)) {
                    if (tplstart) {
                        if (tplbuilder.length() > 0) {
                            String txt;
                            GrammarToken stringtoken;
                            if (builder.length() > 0) {
                                stringtoken = new GrammarToken();
                                stringtoken.position = tokens.size();
                                stringtoken.text = builder.toString();
                                stringtoken.type = 0;
                                builder.setLength(0);
                                tokens.add(stringtoken);
                            }
                            stringtoken = new GrammarToken();
                            stringtoken.position = tokens.size();
                            stringtoken.text = txt = tplbuilder.toString();
                            stringtoken.type = 1;
                            tplbuilder.setLength(0);
                            tokens.add(stringtoken);
                        } else {
                            builder.append(tokenPre).append(tokenEnd);
                        }
                        tplstart = false;
                        i = i + end.length - 1;
                        continue;
                    }
                    builder.append(c);
                    continue;
                }
                if (tplstart) {
                    tplbuilder.append(c);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (tplstart) {
                tplbuilder.append(c);
                continue;
            }
            builder.append(c);
        }
        if (tplbuilder.length() > 0) {
            builder.append(tokenPre).append(tplbuilder.toString());
        }
        tplbuilder = null;
        if (builder.length() > 0) {
            GrammarToken stringtoken = new GrammarToken();
            stringtoken.position = tokens.size();
            stringtoken.text = builder.toString();
            stringtoken.type = 0;
            builder.setLength(0);
            tokens.add(stringtoken);
        }
        builder = null;
        return tokens;
    }

    public static interface GrammarTokenBuilder<T extends GrammarTokenInf> {
        public T buildGrammarToken();
    }

    public static interface GrammarTokenInf {
        public int getPosition();

        public void setPosition(int var1);

        public String getText();

        public void setText(String var1);

        public int getType();

        public void setType(int var1);

        public boolean texttoken();

        public boolean varibletoken();

        public String getDefaultValue();

        public void setDefaultValue(String var1);

        public void after();
    }

    public static class GrammarToken
    implements GrammarTokenInf {
        public static final int TextPlain = 0;
        public static final int VARIABLE = 1;
        protected int position;
        protected String text;
        protected String defaultValue;
        protected int type;

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public void setType(int type) {
            this.type = type;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("text=").append(this.text).append("|");
            builder.append("position=").append(this.position).append("|");
            builder.append("type=").append(this.type == 0 ? "TextPlain" : "VARIABLE").append("\r\n");
            return builder.toString();
        }

        @Override
        public boolean texttoken() {
            return this.type == 0;
        }

        @Override
        public boolean varibletoken() {
            return this.type == 1;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void after() {
        }
    }
}

