/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.UNmodify;
import org.frameworkset.spi.assemble.SynchronizedMethod;
import org.frameworkset.spi.assemble.Transactions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AOPMethods
implements Serializable,
UNmodify {
    private static Logger log = LoggerFactory.getLogger(Transactions.class);
    private List<SynchronizedMethod> aopMethods = new ArrayList<SynchronizedMethod>();
    private Map aopMethodInfoIDX = new HashMap();
    public static final SynchronizedMethod NULL = new SynchronizedMethod();

    public SynchronizedMethod isTransactionMethod(Method method, String uuid) {
        return this.containMethod(method, uuid);
    }

    public SynchronizedMethod isAsyncMethod(Method method, String uuid) {
        return this.containMethod(method, uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SynchronizedMethod containMethod(Method method, String uuid) {
        if (this.aopMethods == null || this.aopMethods.size() == 0) {
            return null;
        }
        try {
            SynchronizedMethod match;
            if (uuid == null) {
                uuid = SynchronizedMethod.buildMethodUUID(method);
            }
            if ((match = (SynchronizedMethod)this.aopMethodInfoIDX.get(uuid)) == null) {
                AOPMethods aOPMethods = this;
                synchronized (aOPMethods) {
                    match = (SynchronizedMethod)this.aopMethodInfoIDX.get(uuid);
                    if (match != null) {
                        if (match == NULL) {
                            return null;
                        }
                        return match;
                    }
                    for (int i = 0; i < this.aopMethods.size(); ++i) {
                        SynchronizedMethod m = this.aopMethods.get(i);
                        if (!m.match(method, uuid)) continue;
                        this.aopMethodInfoIDX.put(uuid, m);
                        return m;
                    }
                    this.aopMethodInfoIDX.put(uuid, NULL);
                    return null;
                }
            }
            if (match == NULL) {
                return null;
            }
            return match;
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
            return null;
        }
    }

    public int size() {
        return this.aopMethods.size();
    }

    public void addTransactionMethod(SynchronizedMethod method) {
        if (this.containTransactionMethod(method)) {
            return;
        }
        this.aopMethods.add(method);
    }

    private boolean containTransactionMethod(SynchronizedMethod method) {
        if (this.aopMethods == null || this.aopMethods.size() == 0) {
            return false;
        }
        for (SynchronizedMethod method_ : this.aopMethods) {
            if (!method_.getUUID().equals(method.getUUID())) continue;
            return true;
        }
        return false;
    }

    public List<SynchronizedMethod> getTransactionMethods() {
        return this.aopMethods;
    }

    @Override
    public void unmodify() {
        this.aopMethods = Collections.unmodifiableList(this.aopMethods);
    }
}

