/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.proxy.Interceptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.ProviderInterceptor;
import org.frameworkset.spi.UNmodify;
import org.frameworkset.spi.assemble.AOPMethods;
import org.frameworkset.spi.assemble.InterceptorInfo;
import org.frameworkset.spi.assemble.ProviderManagerInfo;
import org.frameworkset.spi.assemble.SynchronizedMethod;
import org.frameworkset.spi.assemble.Transactions;
import org.frameworkset.spi.interceptor.DummyInterceptorFacttory;
import org.frameworkset.spi.interceptor.DumyInterceptor;
import org.frameworkset.spi.interceptor.InterceptorChain;
import org.frameworkset.spi.interceptor.InterceptorFacttory;
import org.frameworkset.spi.interceptor.InterceptorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTXManager
implements Serializable,
UNmodify {
    private static Logger log = LoggerFactory.getLogger(ProviderManagerInfo.class);
    private static InterceptorFacttory interceptorFacttory;
    protected Transactions txs;
    protected List<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
    protected boolean callorder_sequence = false;
    protected AOPMethods asyncMethods;
    protected boolean usedCustomInterceptor = false;
    protected String transactionInterceptorClass;
    private Object lock_ = new Object();
    private boolean loadAsyncAnnotation = false;
    private Object InterceptorChainLock = new Object();
    private Interceptor nullintercptor = new DumyInterceptor();
    private Map<String, Interceptor> methodInterceptorMap = new HashMap<String, Interceptor>();
    private Object lock = new Object();
    private boolean loadTXAnnotation = false;

    public void setTransactions(Transactions txs) {
        this.txs = txs;
    }

    public SynchronizedMethod isTransactionMethod(Method method, String muuid) {
        this.loadTXAnnotation();
        if (this.txs == null) {
            return null;
        }
        return this.txs.isTransactionMethod(method, muuid);
    }

    public SynchronizedMethod isAsyncMethod(Method method, String muuid) {
        this.loadAsyncAnnotation();
        if (this.asyncMethods == null) {
            return null;
        }
        return this.asyncMethods.isAsyncMethod(method, muuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAsyncAnnotation() {
        if (this.loadAsyncAnnotation) {
            return;
        }
        Object object = this.lock_;
        synchronized (object) {
            if (this.loadAsyncAnnotation) {
                return;
            }
            try {
                this.initAsyncMethods();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadAsyncAnnotation = true;
        }
    }

    public boolean enableAsyncCall() {
        this.loadAsyncAnnotation();
        return this.asyncMethods != null && this.asyncMethods.size() > 0;
    }

    protected void setAsyncMethods(AOPMethods asyncMethods) {
        this.asyncMethods = asyncMethods;
    }

    public Interceptor getSynTransactionInterceptor(Method method, String muuid) {
        if (this.enableInterceptor()) {
            if (muuid == null) {
                muuid = SynchronizedMethod.buildMethodUUID(method);
            }
            if (!this.callorder_sequence) {
                Interceptor intercptor = this.getChainInterceptor(method, muuid);
                if (this.enableTransaction()) {
                    if (intercptor != null) {
                        SynchronizedMethod synmethod = this.txs.isTransactionMethod(method, muuid);
                        if (synmethod == null) {
                            return intercptor;
                        }
                        Interceptor wrapInterceptor = interceptorFacttory.getInterceptor(synmethod);
                        InterceptorChain inteceptor = new InterceptorChain(wrapInterceptor, intercptor, true);
                        return inteceptor;
                    }
                    SynchronizedMethod synmethod = this.txs.isTransactionMethod(method, muuid);
                    if (synmethod == null) {
                        return null;
                    }
                    Interceptor wrapInterceptor = interceptorFacttory.getInterceptor(synmethod);
                    return wrapInterceptor;
                }
                return intercptor;
            }
            Interceptor intercptor = this.getSequenceInterceptor(method, muuid);
            return intercptor;
        }
        if (this.enableTransaction()) {
            SynchronizedMethod synmethod = this.txs.isTransactionMethod(method, muuid);
            if (synmethod == null) {
                return null;
            }
            return interceptorFacttory.getInterceptor(synmethod);
        }
        return null;
    }

    public Interceptor getTransactionInterceptor(Method method, String muuid) {
        if (this.enableTransaction()) {
            SynchronizedMethod synmethod = this.txs.isTransactionMethod(method, muuid);
            if (synmethod == null) {
                return null;
            }
            Interceptor wrapInterceptor = interceptorFacttory.getInterceptor(synmethod);
            return wrapInterceptor;
        }
        return null;
    }

    public Interceptor getChainInterceptor(Method method, String methoduuid) {
        return this._getInterceptor(method, methoduuid, false);
    }

    private Interceptor getSequenceInterceptor(Method method, String methoduuid) {
        return this._getInterceptor(method, methoduuid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTXAnnotation() {
        if (this.loadTXAnnotation) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.loadTXAnnotation) {
                return;
            }
            try {
                this.initTransactions();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadTXAnnotation = true;
        }
    }

    public boolean enableTransaction() {
        this.loadTXAnnotation();
        return this.txs != null && this.txs.size() > 0;
    }

    protected abstract void initAsyncMethods();

    protected abstract void initTransactions();

    public boolean enableInterceptor() {
        return this.interceptors != null && this.interceptors.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interceptor _getInterceptor(Method method, String methoduuid, boolean sequence) {
        Interceptor intercptorChain;
        if (!this.enableInterceptor()) {
            return null;
        }
        if (methoduuid == null) {
            methoduuid = SynchronizedMethod.buildMethodUUID(method);
        }
        if ((intercptorChain = this.methodInterceptorMap.get(methoduuid)) != null) {
            if (intercptorChain == this.nullintercptor) {
                return null;
            }
            return intercptorChain;
        }
        Object object = this.InterceptorChainLock;
        synchronized (object) {
            intercptorChain = this.methodInterceptorMap.get(methoduuid);
            if (intercptorChain != null) {
                if (intercptorChain == this.nullintercptor) {
                    return null;
                }
                return intercptorChain;
            }
            intercptorChain = !sequence ? this._getChainInterceptor(method, methoduuid) : this._getSequenceInterceptor(method, methoduuid);
            if (intercptorChain == null) {
                this.methodInterceptorMap.put(methoduuid, this.nullintercptor);
            } else {
                this.methodInterceptorMap.put(methoduuid, intercptorChain);
            }
            return intercptorChain;
        }
    }

    private Interceptor _getSequenceInterceptor(Method method, String muuid) {
        this.loadTXAnnotation();
        if (this.enableInterceptor()) {
            int size = this.interceptors.size();
            ArrayList<Interceptor> _t = new ArrayList<Interceptor>(size);
            for (int i = 0; i < size; ++i) {
                try {
                    InterceptorInfo it = this.interceptors.get(i);
                    if (!it.allWillBeIntercept() || it.isInterceptMethod(method, muuid) == null) continue;
                    Interceptor transactionInterceptor = (Interceptor)it.getBean();
                    if (transactionInterceptor instanceof ProviderInterceptor) {
                        ((ProviderInterceptor)transactionInterceptor).setProviderManagerInfo(this);
                    }
                    _t.add(transactionInterceptor);
                    continue;
                }
                catch (Exception ne) {
                    log.error("", (Throwable)ne);
                }
            }
            if (this.enableTransaction()) {
                SynchronizedMethod synmethod = this.txs.isTransactionMethod(method, muuid);
                if (synmethod == null) {
                    return new InterceptorWrapper(_t);
                }
                Interceptor wrapInterceptor = interceptorFacttory.getInterceptor(synmethod);
                InterceptorWrapper wraper = new InterceptorWrapper(wrapInterceptor, _t);
                return wraper;
            }
            InterceptorWrapper wraper = new InterceptorWrapper(_t);
            return wraper;
        }
        SynchronizedMethod synmethod = this.txs.isTransactionMethod(method, muuid);
        if (synmethod == null) {
            return null;
        }
        Interceptor wrapInterceptor = interceptorFacttory.getInterceptor(synmethod);
        return wrapInterceptor;
    }

    private Interceptor _getChainInterceptor(Method method, String methoduuid) {
        if (this.enableInterceptor()) {
            int size = this.interceptors.size();
            Interceptor next = null;
            for (int i = size - 1; i >= 0; --i) {
                try {
                    InterceptorInfo it = this.interceptors.get(i);
                    if (!it.allWillBeIntercept() && it.isInterceptMethod(method, methoduuid) == null) continue;
                    Interceptor transactionInterceptor = (Interceptor)it.getBean();
                    if (transactionInterceptor instanceof ProviderInterceptor) {
                        ((ProviderInterceptor)transactionInterceptor).setProviderManagerInfo(this);
                    }
                    if (next != null) {
                        InterceptorChain chain = new InterceptorChain(transactionInterceptor, next);
                        next = chain;
                        continue;
                    }
                    next = transactionInterceptor;
                    continue;
                }
                catch (Exception ne) {
                    log.info("", (Throwable)ne);
                }
            }
            return next;
        }
        return null;
    }

    public void setTransactionInterceptorClass(String transactionInterceptorClass) {
        this.transactionInterceptorClass = transactionInterceptorClass;
    }

    public boolean usedCustomInterceptor() {
        return this.usedCustomInterceptor;
    }

    public void addInterceptor(InterceptorInfo interceptorinfo) {
        this.interceptors.add(interceptorinfo);
        this.usedCustomInterceptor = true;
    }

    public List getInterceptors() {
        return this.interceptors;
    }

    public boolean isCallorder_sequence() {
        return this.callorder_sequence;
    }

    public void setCallorder_sequence(boolean callorder_sequence) {
        this.callorder_sequence = callorder_sequence;
    }

    public String getTransactionInterceptorClass() {
        return this.transactionInterceptorClass;
    }

    public List getTransactionMethods() {
        this.loadTXAnnotation();
        if (this.txs != null) {
            return this.txs.getTransactionMethods();
        }
        return null;
    }

    @Override
    public void unmodify() {
        this.interceptors = Collections.unmodifiableList(this.interceptors);
    }

    static {
        try {
            interceptorFacttory = (InterceptorFacttory)Class.forName("org.frameworkset.spi.interceptor.InterceptorFacttoryImpl").newInstance();
        }
        catch (Exception e) {
            log.debug("class org.frameworkset.spi.interceptor.InterceptorFacttoryImpl not found in classpath,use DummyInterceptorFacttory. ");
            interceptorFacttory = new DummyInterceptorFacttory();
        }
    }
}

