/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble.callback;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.assemble.AssembleUtil;
import org.frameworkset.spi.assemble.ManagerImport;
import org.frameworkset.spi.assemble.callback.AssembleCallback;
import org.frameworkset.spi.assemble.callback.AssembleCallbackException;
import org.frameworkset.spi.assemble.callback.AssembleCallbackResolver;
import org.frameworkset.util.AntPathMatcher;
import org.frameworkset.util.PathMatcher;

public class DefaultAssembleCallbackResolver
implements AssembleCallbackResolver {
    private Map<String, AssembleCallback> docAssembleCallbacks = new HashMap<String, AssembleCallback>();
    private static final PathMatcher pathMatcher = new AntPathMatcher();

    @Override
    public AssembleCallback resolverAssembleCallback(String docbasetype) {
        AssembleCallback assembleCallback = this.docAssembleCallbacks.get(docbasetype);
        return assembleCallback != null ? assembleCallback : AssembleUtil.defaultAssembleCallback;
    }

    @Override
    public void registAssembleCallback(AssembleCallback assembleCallback) {
        this.docAssembleCallbacks.put(assembleCallback.getDocbaseType(), assembleCallback);
    }

    @Override
    public List<ManagerImport> getManagerImports(ManagerImport docbaseImport) throws AssembleCallbackException {
        String docbaseType = docbaseImport.isClasspathBase() ? "classpath::" : "web::";
        String docbase = docbaseImport.getDocbase();
        String contextFile = docbaseImport.getFile();
        AssembleCallback assembleCallback = this.resolverAssembleCallback(docbaseImport.isClasspathBase() ? "classpath::" : "web::");
        if (assembleCallback == null) {
            throw new AssembleCallbackException("GetManagerImports(" + docbaseType + "," + docbase + "," + contextFile + "):\u83b7\u53d6docbaseType[" + docbaseType + "]\u5931\u8d25,AssembleCallback is null.");
        }
        String absoluteParentPath = assembleCallback.getDocbasePath(docbase);
        ArrayList<ManagerImport> managerImports = new ArrayList<ManagerImport>();
        if (contextFile.indexOf("*") == -1 && contextFile.indexOf("?") == -1) {
            ManagerImport managerimport = new ManagerImport();
            managerimport.setFile(contextFile);
            managerimport.setRealPath(SimpleStringUtil.getRealPath((String)absoluteParentPath, (String)contextFile));
            managerimport.setWebbased(docbaseImport.isWebBase());
            managerImports.add(managerimport);
            return managerImports;
        }
        if (docbaseImport.isClasspathBase()) {
            throw new AssembleCallbackException("GetManagerImports(" + docbaseType + "," + docbase + "," + contextFile + "):classpath\u4e0a\u4e0b\u6587\u73af\u5883\u4e2d\u7684\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u901a\u8fc7*,?\u8fdb\u884c\u6279\u91cf\u914d\u7f6e\u5bfc\u5165.");
        }
        File parent = new File(absoluteParentPath);
        if (!parent.exists()) {
            throw new AssembleCallbackException("GetManagerImports(" + docbaseType + "," + docbase + "," + contextFile + ")\u5931\u8d25\uff1a" + absoluteParentPath + " do not exist.");
        }
        String docContextFilePattern = contextFile;
        FileFilter fileFilter = docbaseImport.isWebBase() ? new WebContextFileFilter(managerImports, absoluteParentPath, docContextFilePattern) : new ClassPathContextFileFilter(managerImports, absoluteParentPath, docContextFilePattern);
        this.getSubFolderManagerImports(parent, fileFilter);
        return managerImports;
    }

    private void getSubFolderManagerImports(File parent, FileFilter fileFilter) {
        File[] files = parent.listFiles(fileFilter);
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            this.getSubFolderManagerImports(file, fileFilter);
        }
    }

    @Override
    public List<ManagerImport> getManagerImports(String docbaseType, String docbase, String contextFile) throws AssembleCallbackException {
        ManagerImport docbaseImport = new ManagerImport();
        if (docbase != null) {
            if (docbaseType == null) {
                docbaseImport.setDocbase(docbase);
            } else if (docbase.startsWith(docbaseType)) {
                docbaseImport.setDocbase(docbase);
            } else {
                docbaseImport.setDocbase(docbaseType + docbase);
            }
        }
        docbaseImport.setFile(contextFile);
        return this.getManagerImports(docbaseImport);
    }

    static class WebContextFileFilter
    implements FileFilter {
        private String absoluteParentPathPattern;
        private String[] contextFilePattern;
        private String absoluteParentPath;
        private String absoluteWEBINFPath;
        List<ManagerImport> managerImports;
        private String[] ignoreDirs = new String[]{".svn", "classes"};
        private String[] includeDirs = new String[]{"WEB-INF"};
        private String[] includeFiles = new String[]{".xml"};

        WebContextFileFilter(List<ManagerImport> managerImports, String absoluteParentPath, String contextFilePattern) {
            this.absoluteParentPathPattern = absoluteParentPath.endsWith("/") ? absoluteParentPath + "*" : absoluteParentPath + "/*";
            String[] patterns = contextFilePattern.split(",");
            this.contextFilePattern = new String[patterns.length];
            int i = 0;
            for (String pattern : patterns) {
                this.contextFilePattern[i] = pattern.trim().startsWith("/") ? pattern.trim().substring(1) : pattern.trim();
                ++i;
            }
            this.absoluteParentPath = absoluteParentPath;
            this.absoluteWEBINFPath = SimpleStringUtil.getRealPath((String)absoluteParentPath, (String)"WEB-INF");
            this.managerImports = managerImports;
        }

        @Override
        public boolean accept(File pathname) {
            if (this.contextFilePattern == null || this.contextFilePattern.length == 0) {
                return false;
            }
            String path = pathname.getAbsolutePath();
            path = path.replace('\\', '/');
            String weblogicPath = "/" + path;
            if (pathname.isDirectory()) {
                boolean isWEBINFPath;
                boolean bl = isWEBINFPath = path.startsWith(this.absoluteWEBINFPath) || weblogicPath.startsWith(this.absoluteWEBINFPath);
                if (!isWEBINFPath) {
                    return false;
                }
                return !SimpleStringUtil.containKey((String[])this.ignoreDirs, (String)pathname.getName());
            }
            if (!pathname.getName().endsWith(".xml")) {
                return false;
            }
            String subpath = pathMatcher.extractPathWithinPattern(this.absoluteParentPathPattern, path);
            for (String pattern : this.contextFilePattern) {
                if (!pathMatcher.match(pattern, subpath)) continue;
                ManagerImport managerimport = new ManagerImport();
                managerimport.setFile(subpath);
                managerimport.setRealPath(SimpleStringUtil.getRealPath((String)this.absoluteParentPath, (String)subpath));
                managerimport.setWebbased(true);
                this.managerImports.add(managerimport);
                break;
            }
            return false;
        }
    }

    static class ClassPathContextFileFilter
    implements FileFilter {
        private String absoluteParentPathPattern;
        private String[] contextFilePattern;
        private String absoluteParentPath;
        private String absoluteWEBINFPath;
        List<ManagerImport> managerImports;
        private String[] ignoreDirs = new String[]{".svn", "classes"};
        private String[] includeDirs = new String[]{"WEB-INF"};
        private String[] includeFiles = new String[]{".xml"};

        ClassPathContextFileFilter(List<ManagerImport> managerImports, String absoluteParentPath, String contextFilePattern) {
            this.absoluteParentPathPattern = absoluteParentPath.endsWith("/") ? absoluteParentPath + "*" : absoluteParentPath + "/*";
            String[] patterns = contextFilePattern.split(",");
            this.contextFilePattern = new String[patterns.length];
            int i = 0;
            for (String pattern : patterns) {
                this.contextFilePattern[i] = pattern.trim().startsWith("/") ? pattern.trim().substring(1) : pattern.trim();
                ++i;
            }
            this.absoluteParentPath = absoluteParentPath;
            this.absoluteWEBINFPath = SimpleStringUtil.getRealPath((String)absoluteParentPath, (String)"WEB-INF");
            this.managerImports = managerImports;
        }

        @Override
        public boolean accept(File pathname) {
            if (this.contextFilePattern == null || this.contextFilePattern.length == 0) {
                return false;
            }
            String path = pathname.getAbsolutePath();
            path = path.replace('\\', '/');
            if (pathname.isDirectory()) {
                if (SimpleStringUtil.containKey((String[])this.ignoreDirs, (String)pathname.getName())) {
                    return false;
                }
                return false;
            }
            if (!pathname.getName().endsWith(".xml")) {
                return false;
            }
            String subpath = pathMatcher.extractPathWithinPattern(this.absoluteParentPathPattern, path);
            for (String pattern : this.contextFilePattern) {
                if (!pathMatcher.match(pattern, subpath)) continue;
                ManagerImport managerimport = new ManagerImport();
                managerimport.setFile(subpath);
                managerimport.setRealPath(SimpleStringUtil.getRealPath((String)this.absoluteParentPath, (String)subpath));
                managerimport.setWebbased(true);
                this.managerImports.add(managerimport);
                break;
            }
            return false;
        }
    }
}

