/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.util.SimpleStringUtil;
import java.io.Serializable;
import org.frameworkset.spi.support.MessageSourceResolvable;
import org.frameworkset.util.ObjectUtils;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    private final String[] codes;
    private final Object[] arguments;
    private final String defaultMessage;

    public DefaultMessageSourceResolvable(String code) {
        this(new String[]{code}, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes) {
        this(codes, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, String defaultMessage) {
        this(codes, null, defaultMessage);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments) {
        this(codes, arguments, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments, String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    @Override
    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected final String resolvableToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("codes [").append(SimpleStringUtil.arrayToDelimitedString((Object[])this.codes, (String)","));
        buf.append("]; arguments [" + SimpleStringUtil.arrayToDelimitedString((Object[])this.arguments, (String)","));
        buf.append("]; default message [").append(this.defaultMessage).append(']');
        return buf.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.resolvableToString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MessageSourceResolvable)) {
            return false;
        }
        MessageSourceResolvable otherResolvable = (MessageSourceResolvable)other;
        return ObjectUtils.nullSafeEquals((Object)this.getCodes(), (Object)otherResolvable.getCodes()) && ObjectUtils.nullSafeEquals((Object)this.getArguments(), (Object)otherResolvable.getArguments()) && ObjectUtils.nullSafeEquals((Object)this.getDefaultMessage(), (Object)otherResolvable.getDefaultMessage());
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object[])this.getCodes());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object[])this.getArguments());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getDefaultMessage());
        return hashCode;
    }
}

