/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.GetCUDResult;
import com.frameworkset.common.poolman.ListSQLParams;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.PagineOrderby;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.SQLInfoDBUtil;
import com.frameworkset.common.poolman.SQLParams;
import com.frameworkset.common.poolman.SetSQLParamException;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.FieldRowHandler;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.util.ListInfo;
import com.frameworkset.util.ValueObjectUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLInfoExecutor {
    private static Logger log = LoggerFactory.getLogger(SQLInfoExecutor.class);
    public static int DEFAULT_BATCHSIZE = -1;

    public static void addSQLParam(SQLParams sqlparams, String name, Object value, String type, String dataformat) throws SetSQLParamException {
        sqlparams.addSQLParam(name, value, type, dataformat);
    }

    public static void init(SQLParams sqlparams, SQLInfo statement, String pretoken, String endtoken, String action) {
        sqlparams.setOldsql(statement);
        if (action != null) {
            if (action.equals("insert")) {
                sqlparams.setAction(0);
            } else if (action.equals("delete")) {
                sqlparams.setAction(2);
            } else if (action.equals("update")) {
                sqlparams.setAction(1);
            }
        }
        sqlparams.setPretoken(pretoken);
        sqlparams.setEndtoken(endtoken);
    }

    public static void insertBeans(String dbname, SQLInfo sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbname, sql, beans, 0, null);
    }

    public static void insertBeans(String dbname, SQLInfo sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbname, sql, beans, 0, getCUDResult);
    }

    public static void execute(String dbname, SQLInfo sql, List beans, boolean isBatchOptimize, int action) throws SQLException {
        SQLInfoExecutor.execute(dbname, sql, beans, isBatchOptimize, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String dbname, SQLInfo sql, List beans, boolean isBatchOptimize, int action, GetCUDResult getCUDResult) throws SQLException {
        block16: {
            Connection con = null;
            if (beans == null || beans.size() == 0) {
                return;
            }
            try {
                con = DBUtil.getConection(dbname);
                if (beans.size() < DEFAULT_BATCHSIZE || DEFAULT_BATCHSIZE == -1) {
                    List<SQLParams> batchsqlparams = SQLParams.convertBeansToSqlParams(beans, sql, dbname, action, con);
                    if (batchsqlparams == null) {
                        return;
                    }
                    PreparedDBUtil dbutil = new PreparedDBUtil();
                    dbutil.setBatchOptimize(isBatchOptimize);
                    dbutil.setPrepareDBName(dbname);
                    dbutil.addPreparedBatch(new ListSQLParams(batchsqlparams, sql));
                    dbutil.executePreparedBatch(con, getCUDResult);
                    break block16;
                }
                int start = 0;
                int totalsize = beans.size();
                int left = totalsize - start;
                int end = 0;
                int step = 0;
                do {
                    List<SQLParams> batchsqlparams;
                    if ((batchsqlparams = SQLParams.convertBeansToSqlParams(beans, sql, dbname, action, con, start, end = left >= DEFAULT_BATCHSIZE ? start + DEFAULT_BATCHSIZE : totalsize, step = left >= DEFAULT_BATCHSIZE ? DEFAULT_BATCHSIZE : left)) == null) {
                        break;
                    }
                    PreparedDBUtil dbutil = new PreparedDBUtil();
                    dbutil.setBatchOptimize(isBatchOptimize);
                    dbutil.setPrepareDBName(dbname);
                    dbutil.addPreparedBatch(new ListSQLParams(batchsqlparams, sql));
                    dbutil.executePreparedBatch(con, getCUDResult);
                } while ((left = totalsize - (start += DEFAULT_BATCHSIZE)) > 0);
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Object CUDexecute(String dbname, SQLInfo sql, Object bean, int action) throws SQLException {
        return SQLInfoExecutor.CUDexecute(dbname, sql, bean, action, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object CUDexecute(String dbname, SQLInfo sql, Object bean, int action, boolean getCUDResult) throws SQLException {
        Connection con = null;
        try {
            SQLParams batchsqlparams;
            if (action == 0) {
                con = DBUtil.getConection(dbname);
            }
            if ((batchsqlparams = SQLParams.convertBeanToSqlParams(bean, sql, dbname, action, con)) == null) {
                Object var7_7 = null;
                return var7_7;
            }
            SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
            if (action == 0) {
                dbutil.preparedInsert(batchsqlparams, dbname, sql);
                Object object = dbutil.executePrepared(con, getCUDResult);
                return object;
            }
            if (action == 1) {
                dbutil.preparedUpdate(batchsqlparams, dbname, sql);
                Object object = dbutil.executePrepared(con, getCUDResult);
                return object;
            }
            if (action != 2) throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u64cd\u4f5c\uff1a" + action);
            dbutil.preparedDelete(batchsqlparams, dbname, sql);
            Object object = dbutil.executePrepared(con, getCUDResult);
            return object;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static <T> void executeBatch(String dbname, SQLInfo sql, List<T> datas, int batchsize, BatchHandler<T> batchHandler) throws SQLException {
        if (datas == null || datas.size() == 0) {
            return;
        }
        StatementInfo stmtInfo = null;
        PreparedStatement statement = null;
        Object resources = null;
        Connection con_ = null;
        try {
            con_ = DBUtil.getConection(dbname);
            stmtInfo = new StatementInfo(dbname, null, false, con_, false);
            stmtInfo.init();
            JDBCPool pool = SQLManager.getInstance().getPool(dbname);
            boolean showsql = pool.getJDBCPoolMetadata().isShowsql();
            if (showsql && log.isDebugEnabled()) {
                log.debug("Execute JDBC prepared batch statement:" + sql.getSql());
            }
            statement = stmtInfo.prepareStatement(sql.getSql());
            if (batchsize <= 1) {
                for (int i = 0; i < datas.size(); ++i) {
                    T param = datas.get(i);
                    batchHandler.handler(statement, param, i);
                    statement.addBatch();
                }
                statement.executeBatch();
            } else {
                int point = batchsize - 1;
                int count = 0;
                for (int i = 0; i < datas.size(); ++i) {
                    T param = datas.get(i);
                    batchHandler.handler(statement, param, i);
                    statement.addBatch();
                    if (count > 0 && count % point == 0) {
                        statement.executeBatch();
                        statement.clearBatch();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count > 0) {
                    statement.executeBatch();
                }
            }
        }
        catch (BatchUpdateException error) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(error);
            }
            throw error;
        }
        catch (Exception e) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
        }
    }

    public static void execute(String dbname, SQLInfo sql, List beans, int action) throws SQLException {
        SQLInfoExecutor.execute(dbname, sql, beans, false, action, null);
    }

    public static void execute(String dbname, SQLInfo sql, List beans, int action, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.execute(dbname, sql, beans, false, action, getCUDResult);
    }

    protected static Object execute(String dbname, SQLInfo sql, int action, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        if (action == 0) {
            dbutil.preparedInsert(dbname, sql);
        } else if (action == 2) {
            dbutil.preparedDelete(dbname, sql);
        } else if (action == 1) {
            dbutil.preparedUpdate(dbname, sql);
        } else {
            dbutil.preparedUpdate(dbname, sql);
        }
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePrepared();
    }

    protected static void executeBatch(String dbname, SQLInfo sql, int action, Object fields_) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        if (action == 0) {
            dbutil.preparedInsert(dbname, sql);
        } else if (action == 2) {
            dbutil.preparedDelete(dbname, sql);
        } else if (action == 1) {
            dbutil.preparedUpdate(dbname, sql);
        } else {
            dbutil.preparedUpdate(dbname, sql);
        }
        if (fields_ != null) {
            short[] fields;
            Class<?> componetType = fields_.getClass().getComponentType();
            if (componetType == Integer.TYPE) {
                int[] fields2 = (int[])fields_;
                if (fields2 != null && fields2.length > 0) {
                    for (int i = 0; i < fields2.length; ++i) {
                        int field = fields2[i];
                        dbutil.setInt(1, field);
                        dbutil.addPreparedBatch();
                    }
                }
            } else if (componetType == Long.TYPE) {
                long[] fields3 = (long[])fields_;
                if (fields3 != null && fields3.length > 0) {
                    for (int i = 0; i < fields3.length; ++i) {
                        long field = fields3[i];
                        dbutil.setLong(1, field);
                        dbutil.addPreparedBatch();
                    }
                }
            } else if (componetType == String.class) {
                String[] fields4 = (String[])fields_;
                if (fields4 != null && fields4.length > 0) {
                    for (int i = 0; i < fields4.length; ++i) {
                        String field = fields4[i];
                        dbutil.setString(1, field);
                        dbutil.addPreparedBatch();
                    }
                }
            } else if (componetType == Short.TYPE && (fields = (short[])fields_) != null && fields.length > 0) {
                for (int i = 0; i < fields.length; ++i) {
                    short field = fields[i];
                    dbutil.setShort(1, field);
                    dbutil.addPreparedBatch();
                }
            }
        }
        dbutil.executePreparedBatch();
    }

    public static Object update(SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(null, sql, 1, fields);
    }

    public static Object delete(SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(null, sql, 2, fields);
    }

    public static void deleteByKeys(SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 2, fields);
    }

    public static void deleteByKeysWithDBName(String dbname, SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 2, fields);
    }

    public static void updateByKeys(SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 1, fields);
    }

    public static void updateByKeysWithDBName(String dbname, SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 1, fields);
    }

    public static void deleteByLongKeys(SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 2, fields);
    }

    public static void deleteByLongKeysWithDBName(String dbname, SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 2, fields);
    }

    public static void updateByLongKeys(SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 1, fields);
    }

    public static void updateByLongKeysWithDBName(String dbname, SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 1, fields);
    }

    public static void deleteByKeys(SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 2, fields);
    }

    public static void deleteByKeysWithDBName(String dbname, SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 2, fields);
    }

    public static void updateByKeys(SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 1, fields);
    }

    public static void updateByKeysWithDBName(String dbname, SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 1, fields);
    }

    public static void deleteByShortKeys(SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 2, fields);
    }

    public static void deleteByShortKeysWithDBName(String dbname, SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 2, fields);
    }

    public static void updateByShortKeys(SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(null, sql, 1, fields);
    }

    public static void updateByShortKeysWithDBName(String dbname, SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbname, sql, 1, fields);
    }

    public static Object insert(SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(null, sql, 0, fields);
    }

    public static Object updateWithDBName(String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbname, sql, 1, fields);
    }

    public static Object deleteWithDBName(String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbname, sql, 2, fields);
    }

    public static Object insertWithDBName(String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbname, sql, 0, fields);
    }

    public static void updateBeans(String dbname, SQLInfo sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbname, sql, beans, 1, null);
    }

    public static void updateBeans(String dbname, SQLInfo sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbname, sql, beans, 1, GetCUDResult2);
    }

    public static void deleteBeans(String dbname, SQLInfo sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbname, sql, beans, 2);
    }

    public static void deleteBeans(String dbname, SQLInfo sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbname, sql, beans, 2, GetCUDResult2);
    }

    public static void insertBean(String dbname, SQLInfo sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfoExecutor.CUDexecute(dbname, sql, bean, 0, false);
    }

    public static void insertBean(String dbname, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        if (getCUDResult == null) {
            SQLInfoExecutor.CUDexecute(dbname, sql, bean, 0, false);
        } else {
            GetCUDResult getCUDResult_ = (GetCUDResult)SQLInfoExecutor.CUDexecute(dbname, sql, bean, 0, true);
            getCUDResult.setGetCUDResult(getCUDResult_);
        }
    }

    public static void updateBean(String dbname, SQLInfo sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfoExecutor.CUDexecute(dbname, sql, bean, 1, false);
    }

    public static void updateBean(String dbname, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        if (getCUDResult != null) {
            GetCUDResult getCUDResult_ = (GetCUDResult)SQLInfoExecutor.CUDexecute(dbname, sql, bean, 1, true);
            getCUDResult.setGetCUDResult(getCUDResult_);
        } else {
            SQLInfoExecutor.CUDexecute(dbname, sql, bean, 1, false);
        }
    }

    public static void updateBean(SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.updateBean(null, sql, bean, getCUDResult);
    }

    public static void deleteBean(SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.deleteBean(null, sql, bean, getCUDResult);
    }

    public static void deleteBean(String dbname, SQLInfo sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfoExecutor.CUDexecute(dbname, sql, bean, 2, false);
    }

    public static void deleteBean(String dbname, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        if (getCUDResult != null) {
            GetCUDResult getCUDResult_ = (GetCUDResult)SQLInfoExecutor.CUDexecute(dbname, sql, bean, 2, true);
            getCUDResult.setGetCUDResult(getCUDResult_);
        } else {
            SQLInfoExecutor.CUDexecute(dbname, sql, bean, 2, false);
        }
    }

    public static void insertBeans(SQLInfo sql, List beans) throws SQLException {
        SQLInfoExecutor.insertBeans(null, sql, beans);
    }

    public static void insertBeans(SQLInfo sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.insertBeans(null, sql, beans, getCUDResult);
    }

    public static void updateBeans(SQLInfo sql, List beans) throws SQLException {
        SQLInfoExecutor.updateBeans(null, sql, beans);
    }

    public static void deleteBeans(SQLInfo sql, List beans) throws SQLException {
        SQLInfoExecutor.deleteBeans(null, sql, beans);
    }

    public static void insertBean(SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.insertBean((String)null, sql, bean);
    }

    public static void insertBean(SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.insertBean(null, sql, bean, getCUDResult);
    }

    public static void updateBean(SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.updateBean((String)null, sql, bean);
    }

    public static void deleteBean(SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.deleteBean((String)null, sql, bean);
    }

    public static <T> List<T> queryList(Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListWithDBName(beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBName(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setMaxPageItems(pagesize);
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        return datas;
    }

    public static ListInfo moreListInfoWithDBName(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsize(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize, totalsize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesql(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelectWithTotalsizesql(dbname, sql, offset, pagesize, totalsizesql);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfo(Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName(beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsize(Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsize(beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesql(Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesql(beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObject(Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryObjectWithDBName(beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBName(Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForList(beanType);
    }

    public static <T> T queryObjectWithDBName(Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForObject(beanType);
    }

    public static <T> List<T> queryListByRowHandler(RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListWithDBNameByRowHandler(rowhandler, beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize, totalsize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelectWithTotalsizesql(dbname, sql, offset, pagesize, totalsizesql);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoByRowHandler(RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByRowHandler(RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByRowHandler(RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObjectByRowHandler(RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryObjectWithDBNameByRowHandler(rowhandler, beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForList(beanType, rowhandler);
    }

    public static <T> T queryObjectWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForObject(beanType, rowhandler);
    }

    public static void queryByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoExecutor.queryWithDBNameByNullRowHandler(rowhandler, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize, totalsize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelectWithTotalsizesql(dbname, sql, offset, pagesize, totalsizesql);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static void queryWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(rowhandler);
    }

    public static <T> List<T> queryListBean(Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListBeanWithDBName(beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, totalsize);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBName(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelectWithTotalsizesql(params, dbname, sql, offset, pagesize, totalsizesql);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBName(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoBeanWithDBName(Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.setMore(true);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBean(Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBName(beanType, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBean(Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBName(beanType, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBean(Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBName(beanType, null, sql, offset, pagesize, -1L, bean);
    }

    public static String queryField(SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryFieldWithDBName(null, sql, fields);
    }

    public static String queryFieldBean(SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryFieldBeanWithDBName(null, sql, bean);
    }

    public static String queryFieldBeanWithDBName(String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        dbutil.executePrepared();
        if (dbutil.size() > 0) {
            return dbutil.getString(0, 0);
        }
        return null;
    }

    public static String queryFieldWithDBName(String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePrepared();
        if (dbutil.size() > 0) {
            return dbutil.getString(0, 0);
        }
        return null;
    }

    public static <T> T queryTField(Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryTFieldWithDBName(null, beanType, sql, fields);
    }

    public static <T> T queryTFieldBean(Class<T> type, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryTFieldBeanWithDBName(null, type, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(String dbname, Class<T> type, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryTFieldBeanWithDBName(dbname, type, null, sql, bean);
    }

    public static <T> T queryTFieldWithDBName(String dbname, Class<T> type, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryTFieldWithDBName(dbname, type, (FieldRowHandler)null, sql, fields);
    }

    public static <T> T queryTField(Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryTFieldWithDBName(null, type, fieldRowHandler, sql, fields);
    }

    public static <T> T queryTFieldBean(Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryTFieldBeanWithDBName(null, type, fieldRowHandler, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        if (fieldRowHandler == null) {
            dbutil.executePrepared();
            if (dbutil.size() > 0) {
                return (T)ValueObjectUtil.typeCast((Object)dbutil.getObject(0, 0), type);
            }
            return (T)ValueObjectUtil.getDefaultValue(type);
        }
        return dbutil.executePreparedForObject(type, fieldRowHandler);
    }

    public static <T> T queryTFieldWithDBName(String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        if (fieldRowHandler == null) {
            dbutil.executePrepared();
            if (dbutil.size() > 0) {
                return (T)ValueObjectUtil.typeCast((Object)dbutil.getObject(0, 0), type);
            }
            return (T)ValueObjectUtil.getDefaultValue(type);
        }
        return dbutil.executePreparedForObject(type, fieldRowHandler);
    }

    public static <T> T queryObjectBean(Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryObjectBeanWithDBName(beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBName(Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForList(beanType);
    }

    public static <T> T queryObjectBeanWithDBName(Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForObject(beanType);
    }

    public static <T> List<T> queryListBeanByRowHandler(RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, totalsize);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.setMore(true);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelectWithTotalsizesql(params, dbname, sql, offset, pagesize, totalsizesql);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, -1L, bean);
    }

    public static <T> T queryObjectBeanByRowHandler(RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryObjectBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForList(beanType, rowhandler);
    }

    public static <T> T queryObjectBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForObject(beanType, rowhandler);
    }

    public static void queryBeanByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.queryBeanWithDBNameByNullRowHandler(rowhandler, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, totalsize);
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelectWithTotalsizesql(params, dbname, sql, offset, pagesize, totalsizesql);
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        dbutil.executePreparedWithRowHandler(rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, -1L, bean);
    }

    public static void queryBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        dbutil.executePreparedWithRowHandler(rowhandler);
    }
}

