/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.handle.RowHandlerException;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.orm.adapter.DB;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.util.ClassUtil;

public class PoolManResultSetMetaData
implements ResultSetMetaData,
Serializable {
    private int _columnCount;
    private String[] _columnTypeName;
    private String[] _columnClassName;
    private int[] _scale;
    private String[] _columnLabel;
    private String[] _columnLabel_upper;
    private String[] _columnLabel_lower;
    private boolean[] _autoIncrement;
    private int[] _columnDisplaySize;
    private String[] _catalogName;
    private String[] _columnName;
    private boolean[] _writable;
    private boolean[] _searchable;
    private int[] _columnType;
    private boolean[] _currency;
    private String[] _tableName;
    private int[] _nullable;
    private boolean[] _signed;
    private boolean[] _readOnly;
    private boolean[] _definitelyWritable;
    private int[] _precision;
    private String[] _schemaName;
    private boolean[] _caseSensitive;
    private String[] columnJavaName;
    private Map samecols;
    private String _sqlReason;
    private String _sqlState;
    private int _sqlVendorCode;
    public static final String col_uuid_split = "#$_";

    public static PoolManResultSetMetaData getCopy(JDBCPool pool, ResultSetMetaData original) throws SQLException {
        if (original instanceof PoolManResultSetMetaData) {
            return (PoolManResultSetMetaData)original;
        }
        return new PoolManResultSetMetaData(pool, original);
    }

    public static PoolManResultSetMetaData getCopy(ResultSetMetaData original) throws SQLException {
        if (original instanceof PoolManResultSetMetaData) {
            return (PoolManResultSetMetaData)original;
        }
        return new PoolManResultSetMetaData(null, original);
    }

    public static String buildUUColname(String name, int id) {
        return name + col_uuid_split + id;
    }

    private PoolManResultSetMetaData(JDBCPool pool, ResultSetMetaData other) throws SQLException {
        int c;
        DB db = pool.getDbAdapter();
        this._columnCount = other.getColumnCount();
        this._columnTypeName = new String[this._columnCount];
        this._columnClassName = new String[this._columnCount];
        this._scale = new int[this._columnCount];
        this._columnLabel = new String[this._columnCount];
        this._columnLabel_upper = new String[this._columnCount];
        this._columnLabel_lower = new String[this._columnCount];
        this._autoIncrement = new boolean[this._columnCount];
        this._columnDisplaySize = new int[this._columnCount];
        this._catalogName = new String[this._columnCount];
        this._columnName = new String[this._columnCount];
        this._writable = new boolean[this._columnCount];
        this._searchable = new boolean[this._columnCount];
        this._columnType = new int[this._columnCount];
        this._currency = new boolean[this._columnCount];
        this._tableName = new String[this._columnCount];
        this._nullable = new int[this._columnCount];
        this._signed = new boolean[this._columnCount];
        this._readOnly = new boolean[this._columnCount];
        this._definitelyWritable = new boolean[this._columnCount];
        this._precision = new int[this._columnCount];
        this._schemaName = new String[this._columnCount];
        this._caseSensitive = new boolean[this._columnCount];
        this.samecols = new HashMap();
        if (PoolManConfiguration.isColumnNameMapping()) {
            this.columnJavaName = new String[this._columnCount];
        }
        HashMap<String, WrapInteger> testM = new HashMap<String, WrapInteger>();
        String columnLabel = null;
        String columnName = null;
        for (c = 0; c < this._columnCount; ++c) {
            String label;
            WrapInteger wi;
            int rc = c + 1;
            this._columnTypeName[c] = other.getColumnTypeName(rc);
            if (this._columnClassName != null) {
                try {
                    this._columnClassName[c] = other.getColumnClassName(rc);
                }
                catch (SQLException x) {
                    this._columnClassName = null;
                    this._sqlReason = x.getMessage();
                    this._sqlState = x.getSQLState();
                    this._sqlVendorCode = x.getErrorCode();
                }
                catch (Throwable e) {
                    this._columnClassName = null;
                }
            }
            this._scale[c] = other.getScale(rc);
            this._columnName[c] = columnName = other.getColumnName(rc);
            columnLabel = other.getColumnLabel(rc);
            if (columnLabel == null || columnLabel.equals("")) {
                columnLabel = columnName;
            }
            this._columnLabel[c] = columnLabel;
            this._columnLabel_upper[c] = columnLabel.toUpperCase();
            this._columnLabel_lower[c] = columnLabel.toLowerCase();
            if (PoolManConfiguration.isColumnNameMapping()) {
                this.columnJavaName[c] = ClassUtil.genJavaName((String)columnLabel);
            }
            if ((wi = (WrapInteger)testM.get(label = pool.getDbAdapter().columnLableUpperCase(pool.getJDBCPoolMetadata()) ? this._columnLabel_upper[c] : columnLabel)) == null) {
                wi = new WrapInteger(1, c, label);
                testM.put(label, wi);
            } else {
                wi.increament(c);
            }
            this._autoIncrement[c] = other.isAutoIncrement(rc);
            this._columnDisplaySize[c] = other.getColumnDisplaySize(rc);
            try {
                this._catalogName[c] = other.getCatalogName(rc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._catalogName[c] == null) {
                this._catalogName[c] = "";
            }
            if (db != null) {
                this._writable[c] = db.isWritebable(other, rc);
                this._searchable[c] = db.isSearchable(other, rc);
                this._signed[c] = db.isSigned(other, rc);
                this._definitelyWritable[c] = db.isDefinitelyWritable(other, rc);
            } else {
                try {
                    this._writable[c] = other.isWritable(rc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this._searchable[c] = other.isSearchable(rc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this._signed[c] = other.isSigned(rc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this._definitelyWritable[c] = other.isDefinitelyWritable(rc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._columnType[c] = other.getColumnType(rc);
            this._currency[c] = other.isCurrency(rc);
            try {
                this._tableName[c] = other.getTableName(rc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._tableName[c] == null) {
                this._tableName[c] = "";
            }
            this._nullable[c] = other.isNullable(rc);
            this._readOnly[c] = other.isReadOnly(rc);
            try {
                this._precision[c] = other.getPrecision(rc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this._schemaName[c] = other.getSchemaName(rc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._schemaName[c] == null) {
                this._schemaName[c] = "";
            }
            this._caseSensitive[c] = false;
        }
        for (c = 0; c < this._columnCount; ++c) {
            String name = db.columnLableUpperCase(pool.getJDBCPoolMetadata()) ? this._columnLabel_upper[c] : this._columnLabel[c];
            WrapInteger wi = (WrapInteger)testM.get(name);
            if (!wi.containsamecol() || this.samecols.containsKey(name)) continue;
            this.samecols.put(name, wi);
        }
        testM = null;
    }

    public Map getSamecols() {
        return this.samecols;
    }

    public WrapInteger getSameColumns(int colIndex) {
        return this.getSameColumns(this.getColumnLabelUpper(colIndex));
    }

    public WrapInteger getSameColumnsByIndex(int colIndex) {
        return this.getSameColumns(this.getColumnLabelUpperByIndex(colIndex));
    }

    public WrapInteger getSameColumns(String colName) {
        return (WrapInteger)this.samecols.get(colName);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._columnCount;
    }

    public int getColumnCounts() {
        return this._columnCount;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this._columnTypeName[column - 1];
    }

    public String getColumnTypeNameByIndex(int column) throws SQLException {
        return this._columnTypeName[column];
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (this._columnClassName == null) {
            throw new SQLException(this._sqlReason, this._sqlState, this._sqlVendorCode);
        }
        return this._columnClassName[column - 1];
    }

    public String getColumnClassNameByIndex(int column) throws SQLException {
        if (this._columnClassName == null) {
            throw new SQLException(this._sqlReason, this._sqlState, this._sqlVendorCode);
        }
        return this._columnClassName[column];
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this._scale[column - 1];
    }

    public int getScaleByIndex(int column) throws SQLException {
        return this._scale[column];
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this._columnLabel[column - 1];
    }

    public String getColumnLabelByIndex(int column) throws SQLException {
        return this._columnLabel[column];
    }

    public String getColumnLabelUpper(int column) {
        return this._columnLabel_upper[column - 1];
    }

    public String getColumnLabelUpperByIndex(int column) {
        return this._columnLabel_upper[column];
    }

    public String getColumnLabelLower(int column) {
        return this._columnLabel_lower[column - 1];
    }

    public String getColumnLabelLowerByIndex(int column) {
        return this._columnLabel_lower[column];
    }

    public String getColumnJavaName(int column) {
        return this.columnJavaName[column - 1];
    }

    public String getColumnJavaNameByIndex(int column) {
        return this.columnJavaName[column];
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this._autoIncrement[column - 1];
    }

    public boolean isAutoIncrementByIndex(int column) throws SQLException {
        return this._autoIncrement[column];
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this._columnDisplaySize[column - 1];
    }

    public int getColumnDisplaySizeByIndex(int column) throws SQLException {
        return this._columnDisplaySize[column];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this._catalogName[column - 1];
    }

    public String getCatalogNameByIndex(int column) throws SQLException {
        return this._catalogName[column];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this._columnName[column - 1];
    }

    public String getColumnNameByIndex(int column) throws SQLException {
        return this._columnName[column];
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this._writable[column - 1];
    }

    public boolean isWritableByIndex(int column) throws SQLException {
        return this._writable[column];
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this._searchable[column - 1];
    }

    public boolean isSearchableByIndex(int column) throws SQLException {
        return this._searchable[column];
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this._columnType[column - 1];
    }

    public int getColumnTypeByIndex(int column) throws SQLException {
        return this._columnType[column];
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this._currency[column - 1];
    }

    public boolean isCurrencyByIndex(int column) throws SQLException {
        return this._currency[column];
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this._tableName[column - 1];
    }

    public String getTableNameByIndex(int column) throws SQLException {
        return this._tableName[column];
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this._nullable[column - 1];
    }

    public int isNullableByIndex(int column) throws SQLException {
        return this._nullable[column];
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this._signed[column - 1];
    }

    public boolean isSignedByIndex(int column) throws SQLException {
        return this._signed[column];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this._readOnly[column - 1];
    }

    public boolean isReadOnlyByIndex(int column) throws SQLException {
        return this._readOnly[column];
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this._definitelyWritable[column - 1];
    }

    public boolean isDefinitelyWritableByIndex(int column) throws SQLException {
        return this._definitelyWritable[column];
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this._precision[column - 1];
    }

    public int getPrecisionByIndex(int column) throws SQLException {
        return this._precision[column];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this._schemaName[column - 1];
    }

    public String getSchemaNameByIndex(int column) throws SQLException {
        return this._schemaName[column];
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this._caseSensitive[column - 1];
    }

    public boolean isCaseSensitiveByIndex(int column) throws SQLException {
        return this._caseSensitive[column];
    }

    public String[] get_columnLabel_upper() {
        return this._columnLabel_upper;
    }

    public String toString() {
        if (this._columnLabel == null || this._columnLabel.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        boolean flag = false;
        for (String name : this._columnLabel) {
            if (!flag) {
                ret.append(name);
                flag = true;
                continue;
            }
            ret.append(",").append(name);
        }
        return ret.toString();
    }

    public String toDetailString() {
        if (this._columnLabel == null || this._columnLabel.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        int i = 0;
        for (String name : this._columnLabel) {
            if (i == 0) {
                ret.append("columnname=").append(name).append("||").append("sqltype=").append(this._columnTypeName[i]).append("||javatype=").append(this._columnClassName[i]);
            } else {
                ret.append("\r\ncolumnname=").append(name).append("||").append("sqltype=").append(this._columnTypeName[i]).append("||javatype=").append(this._columnClassName[i]);
            }
            ++i;
        }
        return ret.toString();
    }

    public int seekIndex(String colName) {
        String temp = colName.toUpperCase();
        String[] columnLabel_uppers = this.get_columnLabel_upper();
        for (int i = 0; i < columnLabel_uppers.length; ++i) {
            if (!columnLabel_uppers[i].equals(temp)) continue;
            return i;
        }
        throw new RowHandlerException("\u67e5\u8be2\u7ed3\u679c\u4e2d\u4e0d\u5b58\u5728\u5217[" + colName + "].");
    }

    public String getCatalogName(String colName) throws SQLException {
        return this.getCatalogNameByIndex(this.seekIndex(colName));
    }

    public String getColumnClassName(String colName) throws SQLException {
        return this.getColumnClassNameByIndex(this.seekIndex(colName));
    }

    public int getColumnDisplaySize(String colName) throws SQLException {
        return this.getColumnDisplaySizeByIndex(this.seekIndex(colName));
    }

    public String getColumnLabel(String colName) throws SQLException {
        return this.getColumnLabelByIndex(this.seekIndex(colName));
    }

    public String getColumnLabelUpper(String colName) throws SQLException {
        return this.getColumnLabelUpperByIndex(this.seekIndex(colName));
    }

    public String getColumnName(String colName) throws SQLException {
        return this.getColumnNameByIndex(this.seekIndex(colName));
    }

    public int getColumnType(String colName) throws SQLException {
        return this.getColumnTypeByIndex(this.seekIndex(colName));
    }

    public String getColumnTypeName(String colName) throws SQLException {
        return this.getColumnTypeNameByIndex(this.seekIndex(colName));
    }

    public int getPrecision(String colName) throws SQLException {
        return this.getPrecisionByIndex(this.seekIndex(colName));
    }

    public int getScale(String colName) throws SQLException {
        return this.getScaleByIndex(this.seekIndex(colName));
    }

    public String getSchemaName(String colName) throws SQLException {
        return this.getSchemaNameByIndex(this.seekIndex(colName));
    }

    public String getTableName(String colName) throws SQLException {
        return this.getTableNameByIndex(this.seekIndex(colName));
    }

    public boolean isAutoIncrement(String colName) throws SQLException {
        return this.isAutoIncrementByIndex(this.seekIndex(colName));
    }

    public boolean isCaseSensitive(String colName) throws SQLException {
        return this.isCaseSensitiveByIndex(this.seekIndex(colName));
    }

    public boolean isCurrency(String colName) throws SQLException {
        return this.isCurrencyByIndex(this.seekIndex(colName));
    }

    public boolean isDefinitelyWritable(String colName) throws SQLException {
        return this.isDefinitelyWritableByIndex(this.seekIndex(colName));
    }

    public int isNullable(String colName) throws SQLException {
        return this.isNullableByIndex(this.seekIndex(colName));
    }

    public boolean isReadOnly(String colName) throws SQLException {
        return this.isReadOnlyByIndex(this.seekIndex(colName));
    }

    public boolean isSearchable(String colName) throws SQLException {
        return this.isSearchableByIndex(this.seekIndex(colName));
    }

    public boolean isSigned(String colName) throws SQLException {
        return this.isSignedByIndex(this.seekIndex(colName));
    }

    public boolean isWritable(String colName) throws SQLException {
        return this.isWritableByIndex(this.seekIndex(colName));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String[] getColumnJavaName() {
        return this.columnJavaName;
    }

    public String[] get_columnLabel() {
        return this._columnLabel;
    }

    public int[] get_columnType() {
        return this._columnType;
    }

    public String[] getColumnLabelLower() {
        return this._columnLabel_lower;
    }

    public static class WrapInteger {
        private String columnName;
        Map indexs = new HashMap();
        int count = 1;

        public String getColumnName(int index) {
            return (String)this.indexs.get(new Integer(index));
        }

        public WrapInteger(int count, int index, String columnName) {
            this.count = count;
            this.indexs.put(new Integer(index), columnName);
            this.columnName = columnName;
        }

        public void increament(int index) {
            ++this.count;
            this.indexs.put(new Integer(index), PoolManResultSetMetaData.buildUUColname(this.columnName, index));
        }

        public boolean containsamecol() {
            return this.count > 1;
        }

        public Map getIndexs() {
            return this.indexs;
        }

        public int getCount() {
            return this.count;
        }
    }
}

