/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.sql.PrimaryKeyCacheManager;
import com.frameworkset.common.poolman.util.JDBCPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManager {
    private static Logger log = LoggerFactory.getLogger(PoolManager.class);
    protected HashMap pools = new HashMap(1);
    protected List<String> poolnames = new ArrayList<String>();
    protected JDBCPool defaultpool = null;

    protected PoolManager() {
    }

    public List<String> getAllPoolNames() {
        return this.poolnames;
    }

    public JDBCPool getPool(String name) {
        if (name == null) {
            return this.defaultpool;
        }
        if (this.pools.containsKey(name)) {
            try {
                return (JDBCPool)this.pools.get(name);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("ERROR: Could not locate " + name + ". This usually means that the " + "poolman.xml" + " file could not be found, or that it does not contain configuration data for a pool with a name equal to " + name);
        return null;
    }

    public JDBCPool getPoolIfExist(String name) {
        return this.getPoolIfExist(name, false);
    }

    public JDBCPool getPoolIfExist(String name, boolean remove) {
        if (name == null) {
            return this.defaultpool;
        }
        if (!remove) {
            try {
                if (this.pools.containsKey(name)) {
                    return (JDBCPool)this.pools.get(name);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                BaseTableManager.removePrimaryKeyCache(name);
                if (this.defaultpool != null && name.equals(this.defaultpool.getDBName())) {
                    this.defaultpool = null;
                }
                return (JDBCPool)this.pools.remove(name);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean exist(String name) {
        return this.pools.containsKey(name);
    }

    public void addPool(String id, JDBCPool newpool) {
        this.pools.put(id, newpool);
        if (!this.poolnames.contains(id)) {
            this.poolnames.add(id);
        }
        if (this.defaultpool == null) {
            this.defaultpool = newpool;
        } else if (this.defaultpool.getDBName().equals(newpool.getDBName())) {
            try {
                this.defaultpool.stopPool();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            this.defaultpool = newpool;
        }
    }

    public void removePool(String id) {
        if (this.pools.containsKey(id)) {
            int oh;
            int th = this.defaultpool.hashCode();
            if (th == (oh = this.pools.get(id).hashCode())) {
                this.defaultpool = null;
            }
            this.pools.remove(id);
            this.poolnames.remove(id);
        }
    }

    public Object requestObject() {
        try {
            return this.defaultpool.requestConnection();
        }
        catch (Exception e) {
            System.out.println("ERROR: Could not request object, returning NULL:");
            return null;
        }
    }

    public Object requestObject(String poolname) {
        JDBCPool pool = null;
        try {
            pool = (JDBCPool)this.pools.get(poolname);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (pool != null) {
            try {
                return pool.requestConnection();
            }
            catch (Exception e) {
                log.error("Could not request object, returning NULL:", (Throwable)e);
            }
        }
        return null;
    }

    public void destroyPools() {
        if (this.pools != null) {
            for (Map.Entry entry : this.pools.entrySet()) {
                JDBCPool pool = (JDBCPool)entry.getValue();
                try {
                    pool.closeAllResources();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.pools.clear();
            this.pools = null;
        }
        this.defaultpool = null;
        this.poolnames = null;
        try {
            PrimaryKeyCacheManager.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

