/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.util;

import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.util.VariableHandler;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.cache.EdenConcurrentCache;
import org.frameworkset.cache.MissingStaticCache;
import org.frameworkset.persitent.util.SQLBaseCache;
import org.frameworkset.persitent.util.SQLInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLCache
extends SQLBaseCache {
    private static final Logger logger = LoggerFactory.getLogger(SQLCache.class);
    private Map<String, EdenConcurrentCache<String, VariableHandler.SQLStruction>> parserTPLSQLStructions = new HashMap<String, EdenConcurrentCache<String, VariableHandler.SQLStruction>>();
    private Map<String, EdenConcurrentCache<String, VariableHandler.SQLStruction>> parserTPLTotalsizeSQLStructions = new HashMap<String, EdenConcurrentCache<String, VariableHandler.SQLStruction>>();
    protected Map<String, EdenConcurrentCache<String, PoolManResultSetMetaData>> metas = new HashMap<String, EdenConcurrentCache<String, PoolManResultSetMetaData>>();
    protected Map<String, MissingStaticCache<String, PoolManResultSetMetaData>> missingCacheMetas;

    public SQLCache(String sqlfile, int resultMetaCacheSize, int perKeySqlStructionCacheSize) {
        super(sqlfile, resultMetaCacheSize, perKeySqlStructionCacheSize);
    }

    @Override
    public void clear() {
        this.metas.clear();
        this.parserTPLSQLStructions.clear();
        this.parserTPLTotalsizeSQLStructions.clear();
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolManResultSetMetaData getPoolManResultSetMetaData(boolean cacheSql, JDBCPool db, String dbname, String sqlkey, ResultSetMetaData rsmetadata) throws SQLException {
        PoolManResultSetMetaData meta = null;
        if (cacheSql) {
            EdenConcurrentCache dbmetas = this.metas.get(dbname);
            if (dbmetas == null) {
                Map<String, EdenConcurrentCache<String, PoolManResultSetMetaData>> map = this.metas;
                synchronized (map) {
                    dbmetas = this.metas.get(dbname);
                    if (dbmetas == null) {
                        dbmetas = new EdenConcurrentCache(this.resultMetaCacheSize);
                        this.metas.put(dbname, (EdenConcurrentCache<String, PoolManResultSetMetaData>)dbmetas);
                    }
                }
            }
            meta = (PoolManResultSetMetaData)dbmetas.get((Object)sqlkey);
            boolean outOfSize = false;
            boolean newMeta = false;
            long missing = 0L;
            if (meta == null) {
                try {
                    this.metaLock.lock();
                    meta = (PoolManResultSetMetaData)dbmetas.get((Object)sqlkey);
                    if (meta == null) {
                        newMeta = true;
                        missing = dbmetas.increamentMissing();
                        meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
                        outOfSize = dbmetas.put((Object)sqlkey, (Object)meta);
                    }
                }
                finally {
                    this.metaLock.unlock();
                }
            }
            if (!newMeta && this.needRefreshMeta(meta, rsmetadata)) {
                meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
                outOfSize = dbmetas.put((Object)sqlkey, (Object)meta);
            }
            if (outOfSize && logger.isWarnEnabled() && dbmetas.needLogWarn(missing, this.warnInterval)) {
                this.logMetaWarn(logger, sqlkey, dbmetas.getMaxSize(), missing);
            }
        } else {
            meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VariableHandler.SQLStruction _getVTPLSQLStruction(boolean isTotalSize, SQLInfo sqlinfo, String newsql, String okey, int cacheSize) {
        VariableHandler.SQLStruction urlStruction = null;
        if (sqlinfo.isCacheSql()) {
            Map<String, EdenConcurrentCache<String, VariableHandler.SQLStruction>> _parserTPLSQLStructions = !isTotalSize ? this.parserTPLSQLStructions : this.parserTPLTotalsizeSQLStructions;
            String ikey = newsql;
            EdenConcurrentCache sqlstructionMap = _parserTPLSQLStructions.get(okey);
            if (sqlstructionMap == null) {
                try {
                    this.vtplLock.lock();
                    sqlstructionMap = _parserTPLSQLStructions.get(okey);
                    if (sqlstructionMap == null) {
                        sqlstructionMap = new EdenConcurrentCache(cacheSize);
                        _parserTPLSQLStructions.put(okey, (EdenConcurrentCache<String, VariableHandler.SQLStruction>)sqlstructionMap);
                    }
                }
                finally {
                    this.vtplLock.unlock();
                }
            }
            urlStruction = (VariableHandler.SQLStruction)sqlstructionMap.get((Object)ikey);
            boolean outOfSize = false;
            long missing = 0L;
            if (urlStruction == null) {
                try {
                    this.vtplLock.lock();
                    urlStruction = (VariableHandler.SQLStruction)sqlstructionMap.get((Object)ikey);
                    if (urlStruction == null) {
                        missing = sqlstructionMap.increamentMissing();
                        urlStruction = VariableHandler.parserSQLStruction((String)newsql);
                        outOfSize = sqlstructionMap.put((Object)ikey, (Object)urlStruction);
                    }
                }
                finally {
                    this.vtplLock.unlock();
                }
                if (outOfSize && logger.isWarnEnabled() && sqlstructionMap.needLogWarn(missing, this.warnInterval)) {
                    this.logSqlStructionWarn(logger, ikey, sqlstructionMap.getMaxSize(), okey, missing);
                }
            }
        } else {
            urlStruction = VariableHandler.parserSQLStruction((String)newsql);
        }
        return urlStruction;
    }
}

