/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.jndi;

import com.frameworkset.common.poolman.util.JDBCPool;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    public static String INITIAL_CONTEXT_FACTORY = "INITIAL_CONTEXT_FACTORY".toLowerCase();
    private static Logger log = LoggerFactory.getLogger(ContextUtil.class);

    public static Context finaContext(Hashtable environment, ClassLoader loader) {
        Context ctx = null;
        try {
            if (environment != null) {
                ctx = new InitialContext(environment);
                if (ContextUtil.isTomcat(loader)) {
                    ctx = (Context)ctx.lookup("java:comp/env");
                }
            } else {
                ctx = new InitialContext();
                if (ContextUtil.isTomcat(loader)) {
                    ctx = (Context)ctx.lookup("java:comp/env");
                }
            }
            ContextUtil.testJNDI(ctx);
        }
        catch (NoInitialContextException e) {
            try {
                System.setProperty("java.naming.factory.initial", "com.frameworkset.common.poolman.jndi.DummyContextFactory");
                ctx = new InitialContext();
            }
            catch (NamingException e1) {
                log.warn("Find Context ignored:", (Throwable)e1);
            }
        }
        catch (NamingException e) {
            log.info("Find Context failed and ignored:" + e.getMessage());
        }
        catch (Exception e) {
            log.info("Find Context failed and ignored:" + e.getMessage());
        }
        return ctx;
    }

    public static String handleJndiName(String jndiname) {
        if (ContextUtil.isTomcat(JDBCPool.class.getClassLoader()) && jndiname != null && jndiname.startsWith("java:comp/env/")) {
            return jndiname.substring("java:comp/env/".length());
        }
        return jndiname;
    }

    private static void testJNDI(Context ctx) throws NamingException {
        ctx.rebind("test", (Object)"1");
        ctx.unbind("test");
    }

    public static boolean isTomcat(ClassLoader classLoader) {
        try {
            while (true) {
                if (classLoader.getClass().getName().startsWith("org.apache.catalina.")) {
                    return true;
                }
                ClassLoader classLoader_ = classLoader.getParent();
                if (classLoader_ == null || classLoader_ == classLoader) break;
                classLoader = classLoader_;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

