/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.monitor.AbandonedTraceExt;
import com.frameworkset.common.poolman.sql.PoolManDataSource;
import com.frameworkset.orm.transaction.TXDataSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceUtil {
    public static final String DATASOURCE_BEAN_NAME = "datasource";
    private static Logger log = LoggerFactory.getLogger(DatasourceUtil.class);

    public static DataSource getDataSource(String sourcefile) {
        DefaultApplicationContext context = DefaultApplicationContext.getApplicationContext((String)sourcefile);
        return (DataSource)context.getTBeanObject(DATASOURCE_BEAN_NAME, DataSource.class);
    }

    public static Map<String, Object> getDataSourceParameters(String sourcefile) {
        DefaultApplicationContext context = DefaultApplicationContext.getApplicationContext((String)sourcefile);
        Pro pro = context.getProBean(DATASOURCE_BEAN_NAME);
        List list = pro.getReferences();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Pro param = (Pro)list.get(i);
            parameters.put(param.getName(), param.getValue());
        }
        return parameters;
    }

    private static DataSource getSRCDataSource(TXDataSource ds) {
        return ds.getSRCDataSource();
    }

    public static void increamentMaxTotalConnections(DataSource datasource, int nums) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        String name = null;
        if (datasource_ instanceof PoolManDataSource) {
            PoolManDataSource temp = (PoolManDataSource)datasource_;
            name = temp.getPoolName();
            datasource_ = temp.getInnerDataSource();
        }
        try {
            if (datasource_ != null) {
                Method getMaxTotal = datasource_.getClass().getMethod("getMaxTotal", new Class[0]);
                Method setMaxTotal = datasource_.getClass().getMethod("setMaxTotal", Integer.TYPE);
                if (getMaxTotal != null && setMaxTotal != null) {
                    int maxTotal = (Integer)getMaxTotal.invoke((Object)datasource_, new Object[0]);
                    int newmaxTotal = maxTotal + nums;
                    setMaxTotal.invoke((Object)datasource_, newmaxTotal);
                    if (name != null) {
                        log.info("Increament MaxTotal Connections from " + maxTotal + " to " + newmaxTotal + " for datasource[" + name + "]");
                    }
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static List<AbandonedTraceExt> getGoodTraceObjects(DataSource datasource) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        if (datasource_ instanceof PoolManDataSource) {
            PoolManDataSource temp = (PoolManDataSource)datasource_;
            datasource_ = temp.getInnerDataSource();
        }
        try {
            Method getTraceObjects;
            if (datasource_ != null && (getTraceObjects = datasource_.getClass().getMethod("getGoodTraceObjects", new Class[0])) != null) {
                List dd = (List)getTraceObjects.invoke((Object)datasource_, new Object[0]);
                return dd;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new ArrayList<AbandonedTraceExt>();
    }

    public static boolean closeDS(DataSource datasource) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        if (datasource_ != null) {
            try {
                Method close = datasource_.getClass().getMethod("close", new Class[0]);
                if (close != null) {
                    close.invoke((Object)datasource_, new Object[0]);
                    return true;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getNumIdle(DataSource datasource) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        if (datasource_ instanceof PoolManDataSource) {
            PoolManDataSource temp = (PoolManDataSource)datasource_;
            datasource_ = temp.getInnerDataSource();
        }
        try {
            Method getNumIdle;
            if (datasource_ != null && (getNumIdle = datasource_.getClass().getMethod("_getNumIdle", new Class[0])) != null) {
                return (Integer)getNumIdle.invoke((Object)datasource_, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1;
    }

    public static int getNumActive(DataSource datasource) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        if (datasource_ instanceof PoolManDataSource) {
            PoolManDataSource temp = (PoolManDataSource)datasource_;
            datasource_ = temp.getInnerDataSource();
        }
        try {
            Method getNumActive;
            if (datasource_ != null && (getNumActive = datasource_.getClass().getMethod("_getNumActive", new Class[0])) != null) {
                return (Integer)getNumActive.invoke((Object)datasource_, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1;
    }

    public static long getMaxActiveNumTime(DataSource datasource) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        if (datasource_ instanceof PoolManDataSource) {
            PoolManDataSource temp = (PoolManDataSource)datasource_;
            datasource_ = temp.getInnerDataSource();
        }
        try {
            Method getMaxActiveNumTime;
            if (datasource_ != null && (getMaxActiveNumTime = datasource_.getClass().getMethod("getMaxActiveNumTime", new Class[0])) != null) {
                return (Long)getMaxActiveNumTime.invoke((Object)datasource_, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1L;
    }

    public static int getMaxNumActive(DataSource datasource) {
        DataSource datasource_ = null;
        datasource_ = datasource instanceof TXDataSource ? DatasourceUtil.getSRCDataSource((TXDataSource)datasource) : datasource;
        if (datasource_ instanceof PoolManDataSource) {
            PoolManDataSource temp = (PoolManDataSource)datasource_;
            datasource_ = temp.getInnerDataSource();
        }
        try {
            Method getMaxNumActive;
            if (datasource_ != null && (getMaxNumActive = datasource_.getClass().getMethod("getMaxNumActive", new Class[0])) != null) {
                return (Integer)getMaxNumActive.invoke((Object)datasource_, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1;
    }
}

