/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.security.DBInfoEncrypt;
import com.frameworkset.common.poolman.util.DatasourceUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class JDBCPoolMetaData
implements Serializable {
    protected String poolname;
    private boolean enableShutdownHook;
    transient JDBCPoolMetaData extenalInfo = null;
    private int initialObjects = 1;
    private int minimumSize = 0;
    private int maximumSize = Integer.MAX_VALUE;
    private int minEvictableIdleTimeMillis = 1800000;
    private int userTimeout = 60;
    private int timeBetweenEvictionRunsMillis = 60;
    private int numTestsPerEvictionRun = 5;
    private boolean emergencyCreates = true;
    private boolean columnLableUpperCase = true;
    private String maxWait = "30";
    private String datasourceFile;
    private String seqfunction;
    private String databaseProductName;
    private String driverName;
    private String databaseProductVersion;
    private String driverVersion;
    private Map<String, Object> datasourceParameters;
    private DBInfoEncrypt dbInfoEncrypt;
    private String dbInfoEncryptClass;
    private boolean usepool = true;
    private String logfile;
    private boolean debug = false;
    private String driver;
    private String URL;
    private String username;
    private String password;
    private boolean nativeResults = false;
    private String validationQuery;
    private String initialPoolSQL;
    private String initialConnectionSQL;
    private boolean external = false;
    private String externaljndiName;
    private boolean removeOnExceptions = false;
    private boolean poolingPreparedStatements = false;
    private int maxOpenPreparedStatements = -1;
    private Integer transactionIsolationLevel = null;
    private int transactionTimeout = 60;
    private boolean cacheEnabled = false;
    private int cacheSize = 5;
    private int cacheRefreshInterval = 30;
    private String JNDIName;
    private String interceptor = "com.frameworkset.common.poolman.interceptor.DummyInterceptor";
    private String idGenerator;
    private String jndiclass;
    private String jndiuser;
    private String jndipassword;
    private boolean RETURN_GENERATED_KEYS;
    private boolean enableBalance = false;
    private String balance = "random";
    private Integer queryfetchsize;
    private String jndiurl;
    private String keygenerate = "auto";
    private String dbtype = null;
    private String loadmetadata = "false";
    private boolean autoprimarykey = false;
    private boolean showsql = false;
    private boolean showsqlParams = false;
    private Properties connectionProperties;
    private boolean cachequerymetadata = false;
    private boolean robotquery = true;
    private boolean testWhileidle = false;
    private String removeAbandoned = "false";
    private boolean logAbandoned = false;
    private Boolean readOnly = null;
    private boolean enablejta = false;
    public static final String[] driver_names = new String[]{"driverClass", "driverClassName", "driver", "driver-class", "driverName"};
    boolean synsequence = false;

    public String getJndiclass() {
        return this.jndiclass;
    }

    public void setJndiclass(String jndiclass) {
        this.jndiclass = jndiclass;
    }

    public String getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }

    public String getDriver() {
        if (!SimpleStringUtil.isEmpty((String)this.driver)) {
            return this.driver;
        }
        if (this.datasourceParameters != null && this.datasourceParameters.size() > 0) {
            String dr = null;
            for (int i = 0; i < driver_names.length; ++i) {
                dr = (String)this.datasourceParameters.get(driver_names[i]);
                if (SimpleStringUtil.isEmpty((String)dr)) continue;
                this.driver = dr;
                break;
            }
            return this.driver;
        }
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbname() {
        return this.getName();
    }

    public void setDbname(String n) {
        this.setName(n);
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public void setJNDIName(String n) {
        this.JNDIName = n;
    }

    public boolean isNativeResults() {
        return this.nativeResults;
    }

    public void setNativeResults(boolean b) {
        this.nativeResults = b;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolingPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolingPreparedStatements) {
        this.poolingPreparedStatements = poolingPreparedStatements;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String sql) {
        this.validationQuery = sql;
    }

    public String getInitialPoolSQL() {
        return this.initialPoolSQL;
    }

    public void setInitialPoolSQL(String sql) {
        this.initialPoolSQL = sql;
    }

    public String getInitialConnectionSQL() {
        return this.initialConnectionSQL;
    }

    public void setInitialConnectionSQL(String sql) {
        this.initialConnectionSQL = sql;
    }

    public boolean isRemoveOnExceptions() {
        return this.removeOnExceptions;
    }

    public void setRemoveOnExceptions(boolean b) {
        this.removeOnExceptions = b;
    }

    public int getInitialConnections() {
        return this.getInitialObjects();
    }

    public void setInitialConnections(int n) {
        this.setInitialObjects(n);
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int n) {
        this.transactionTimeout = n;
    }

    public Integer getIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setIsolationLevel(Integer n) {
        this.transactionIsolationLevel = n;
    }

    public String getTxIsolationLevel() {
        return this.convertIsoToString(this.getIsolationLevel());
    }

    public void setTxIsolationLevel(String s) {
        this.setIsolationLevel(this.convertIsoToInt(s));
    }

    private int convertIsoToInt(String s) {
        if (s == null || s.equals("")) {
            return -100;
        }
        int n = 2;
        if ((s = s.toUpperCase().trim()).equals("NONE")) {
            n = 0;
        } else if (s.equals("READ_COMMITTED")) {
            n = 2;
        } else if (s.equals("READ_UNCOMMITTED")) {
            n = 1;
        } else if (s.equals("REPEATABLE_READ")) {
            n = 4;
        } else if (s.equals("SERIALIZABLE")) {
            n = 8;
        } else {
            System.out.println("Unrecognized isolation level " + s + " using default setting of " + this.convertIsoToString(n));
        }
        return n;
    }

    private String convertIsoToString(Integer n) {
        if (n == null) {
            return null;
        }
        String result = null;
        switch (n) {
            case 0: {
                result = "NONE";
                break;
            }
            case 2: {
                result = "READ_COMMITTED";
                break;
            }
            case 1: {
                result = "READ_UNCOMMITTED";
                break;
            }
            case 4: {
                result = "REPEATABLE_READ";
                break;
            }
            case 8: {
                result = "SERIALIZABLE";
                break;
            }
        }
        return result;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheRefreshInterval() {
        return this.cacheRefreshInterval;
    }

    public void setCacheRefreshInterval(int seconds) {
        this.cacheRefreshInterval = seconds;
    }

    public String getKeygenerate() {
        return this.keygenerate;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setKeygenerate(String keygenerate) {
        this.keygenerate = keygenerate;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getLoadmetadata() {
        return this.loadmetadata;
    }

    public void setLoadmetadata(String loadmetadata) {
        this.loadmetadata = loadmetadata;
    }

    public String getName() {
        return this.poolname;
    }

    public void setName(String name) {
        this.poolname = name;
    }

    public int getInitialObjects() {
        return this.initialObjects;
    }

    public void setInitialObjects(int n) {
        this.initialObjects = n;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int n) {
        this.minimumSize = n;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int n) {
        this.maximumSize = n;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        this.minEvictableIdleTimeMillis = n;
    }

    public int getUserTimeout() {
        return this.userTimeout;
    }

    public void setUserTimeout(int n) {
        this.userTimeout = n;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int n) {
        this.timeBetweenEvictionRunsMillis = n;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
    }

    public String getLogFile() {
        return this.logfile;
    }

    public void setLogFile(String filename) {
        this.logfile = filename;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setDebugging(boolean b) {
        this.debug = b;
    }

    public boolean isMaximumSoft() {
        return this.emergencyCreates;
    }

    public void setMaximumSoft(boolean b) {
        this.emergencyCreates = b;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getExternaljndiName() {
        return this.externaljndiName;
    }

    public void setExternaljndiName(String externaljndiName) {
        this.externaljndiName = externaljndiName;
    }

    public String getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(String maxWait) {
        this.maxWait = maxWait;
    }

    public String getRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(String removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public boolean isRobotquery() {
        return this.robotquery;
    }

    public void setRobotquery(boolean robotquery) {
        this.robotquery = robotquery;
    }

    public boolean isTestWhileidle() {
        return this.testWhileidle;
    }

    public void setTestWhileidle(boolean testWhileidle) {
        this.testWhileidle = testWhileidle;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean synsequence() {
        return this.synsequence;
    }

    public void setSynsequence(boolean synsequence) {
        this.synsequence = synsequence;
    }

    public int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public boolean getAutoprimarykey() {
        return this.autoprimarykey;
    }

    public void setAutoprimarykey(boolean autoprimarykey) {
        this.autoprimarykey = autoprimarykey;
    }

    public boolean isShowsql() {
        return this.showsql;
    }

    public void setShowsql(boolean showsql) {
        this.showsql = showsql;
    }

    public boolean cachequerymetadata() {
        return this.cachequerymetadata;
    }

    public void setCachequerymetadata(boolean cachequerymetadata) {
    }

    public void setExtenalInfo(JDBCPoolMetaData extenalInfo) {
        this.extenalInfo = extenalInfo;
        if (extenalInfo != null) {
            this.setDriver(extenalInfo.getDriver());
            this.setURL(extenalInfo.getURL());
            this.setUserName(extenalInfo.getUserName());
            this.setPassword(extenalInfo.getPassword());
            this.setNativeResults(extenalInfo.isNativeResults());
            this.setPoolPreparedStatements(extenalInfo.isPoolPreparedStatements());
            this.setValidationQuery(extenalInfo.getValidationQuery());
            this.setInitialPoolSQL(extenalInfo.getInitialPoolSQL());
            this.setInitialConnectionSQL(extenalInfo.getInitialConnectionSQL());
            this.setRemoveOnExceptions(extenalInfo.isRemoveOnExceptions());
            this.setInitialConnections(extenalInfo.getInitialConnections());
            this.setMinEvictableIdleTimeMillis(extenalInfo.getMinEvictableIdleTimeMillis());
            this.setTransactionTimeout(extenalInfo.getTransactionTimeout());
            this.setIsolationLevel(extenalInfo.getIsolationLevel());
            this.setTxIsolationLevel(extenalInfo.getTxIsolationLevel());
            this.setCacheEnabled(extenalInfo.isCacheEnabled());
            this.setCacheSize(extenalInfo.getCacheSize());
            this.setCacheRefreshInterval(extenalInfo.getCacheRefreshInterval());
            this.setKeygenerate(extenalInfo.getKeygenerate());
            this.setDbtype(extenalInfo.getDbtype());
            this.setLoadmetadata(extenalInfo.getLoadmetadata());
            this.setInitialObjects(extenalInfo.getInitialObjects());
            this.setMinimumSize(extenalInfo.getMinimumSize());
            this.setMaximumSize(extenalInfo.getMaximumSize());
            this.setMinEvictableIdleTimeMillis(extenalInfo.getMinEvictableIdleTimeMillis());
            this.setUserTimeout(extenalInfo.getUserTimeout());
            this.setTimeBetweenEvictionRunsMillis(extenalInfo.getTimeBetweenEvictionRunsMillis());
            this.setNumTestsPerEvictionRun(extenalInfo.getNumTestsPerEvictionRun());
            this.setMaximumSoft(extenalInfo.isMaximumSoft());
            this.setMaxWait(extenalInfo.getMaxWait());
            this.setRemoveAbandoned(extenalInfo.getRemoveAbandoned());
            this.setRobotquery(extenalInfo.isRobotquery());
            this.setTestWhileidle(extenalInfo.isTestWhileidle());
            this.setLogAbandoned(extenalInfo.isLogAbandoned());
            this.setReadOnly(extenalInfo.isReadOnly());
            this.setSynsequence(extenalInfo.synsequence());
            this.setMaxOpenPreparedStatements(extenalInfo.getMaxOpenPreparedStatements());
            this.setAutoprimarykey(extenalInfo.getAutoprimarykey());
            this.setCachequerymetadata(extenalInfo.cachequerymetadata());
            this.setDatabaseProductName(extenalInfo.getDatabaseProductName());
            this.setDatabaseProductVersion(extenalInfo.getDatabaseProductVersion());
            this.setDriverName(extenalInfo.getDriverName());
            this.setDriverVersion(extenalInfo.getDriverVersion());
            this.setJndiclass(extenalInfo.getJndiclass());
            this.setJndiurl(extenalInfo.getJndiurl());
            this.setJndiuser(extenalInfo.getJndiuser());
            this.setJndipassword(extenalInfo.getJndipassword());
            this.setUsepool(extenalInfo.isUsepool());
            this.dbInfoEncrypt = extenalInfo.getDbInfoEncrypt();
            this.dbInfoEncryptClass = extenalInfo.getDbInfoEncryptClass();
            this.setEnablejta(extenalInfo.isEnablejta());
            this.setDatasourceFile(extenalInfo.getDatasourceFile());
            this.setDatasourceParameters(this.getDatasourceParameters());
            this.setSeqfunction(extenalInfo.getSeqfunction());
            this.setRETURN_GENERATED_KEYS(extenalInfo.getRETURN_GENERATED_KEYS());
            this.setQueryfetchsize(extenalInfo.getQueryfetchsize());
            this.setShowsql(extenalInfo.isShowsql());
            this.setShowsqlParams(extenalInfo.isShowsqlParams());
            this.setConnectionProperties(extenalInfo.getConnectionProperties());
            this.setBalance(extenalInfo.getBalance());
            this.setEnableBalance(extenalInfo.isEnableBalance());
        }
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public boolean isUsepool() {
        return this.usepool;
    }

    public void setUsepool(boolean usepool) {
        this.usepool = usepool;
    }

    public String getJndiurl() {
        return this.jndiurl;
    }

    public void setJndiurl(String jndiurl) {
        this.jndiurl = jndiurl;
    }

    public String getJndiuser() {
        return this.jndiuser;
    }

    public void setJndiuser(String jndiuser) {
        this.jndiuser = jndiuser;
    }

    public String getJndipassword() {
        return this.jndipassword;
    }

    public void setJndipassword(String jndipassword) {
        this.jndipassword = jndipassword;
    }

    public boolean isEnablejta() {
        return this.enablejta;
    }

    public void setEnablejta(boolean enablejta) {
        this.enablejta = enablejta;
    }

    public String getDatasourceFile() {
        return this.datasourceFile;
    }

    public void setDatasourceFile(String datasourceFile) {
        this.datasourceFile = datasourceFile;
    }

    public Map<String, Object> getDatasourceParameters() {
        return this.datasourceParameters;
    }

    public void setDatasourceParameters(Map<String, Object> datasourceParameters) {
        this.datasourceParameters = datasourceParameters;
    }

    public void initDatasourceParameters() {
        if (!SimpleStringUtil.isEmpty((String)this.datasourceFile)) {
            this.datasourceParameters = DatasourceUtil.getDataSourceParameters(this.datasourceFile);
        }
    }

    public String getSeqfunction() {
        return this.seqfunction;
    }

    public void setSeqfunction(String seqfunction) {
        this.seqfunction = seqfunction;
    }

    public String getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(String idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean getRETURN_GENERATED_KEYS() {
        return this.RETURN_GENERATED_KEYS;
    }

    public void setRETURN_GENERATED_KEYS(boolean rETURN_GENERATED_KEYS) {
        this.RETURN_GENERATED_KEYS = rETURN_GENERATED_KEYS;
    }

    public Integer getQueryfetchsize() {
        return this.queryfetchsize;
    }

    public void setQueryfetchsize(Integer queryfetchsize) {
        this.queryfetchsize = queryfetchsize;
    }

    public String toString() {
        try {
            StringBuilder data = new StringBuilder();
            data.append("{\"url\":\"").append(this.getURL()).append("\",").append("\"driverName\":").append(this.driverName).append(",\"userName\":\"").append(this.username).append("\",\"dbname\":\"").append(this.getDbname()).append("\",").append("\"usepool\":").append(this.usepool).append(",\"driver\":\"").append(this.driver).append("\",").append("\"password\":\"******\",\"jndiname\":\"").append(this.getJNDIName()).append("\",").append("\"dbtype\":").append(this.dbtype).append(",\"loadmetadata\":\"").append(this.loadmetadata).append("\",\"minimumSize\":").append(this.minimumSize).append(",").append("\"maximumSize\":").append(this.maximumSize).append(",\"maximumSoft\":").append(this.isMaximumSoft()).append(",").append("\"datasourceFile\":").append(this.datasourceFile).append(",\"testWhileidle\":").append(this.testWhileidle).append(",").append("\"removeAbandoned\":\"").append(this.removeAbandoned).append("\",\"logAbandoned\":").append(this.logAbandoned).append(",\"readOnly\":").append(this.readOnly).append(",").append("\"enablejta\":").append(this.enablejta).append(",\"initialConnections\":").append(this.getInitialConnections()).append(",\"seqfunction\":").append(this.seqfunction).append(",").append("\"databaseProductName\":").append(this.databaseProductName).append(",\"databaseProductVersion\":").append(this.databaseProductVersion).append(",").append("\"driverVersion\":").append(this.driverVersion).append(",\"datasourceParameters\":").append(this.datasourceParameters).append(",\"validationQuery\":\"").append(this.validationQuery).append("\",\"queryfetchsize\":").append(this.queryfetchsize).append(",\"external\":").append(this.external).append(",").append("\"showsql\":").append(this.showsql).append("\"showsqlParams\":").append(this.showsqlParams).append(",\"externaljndiName\":").append(this.externaljndiName).append(",\"removeOnExceptions\":").append(this.removeOnExceptions).append(",").append("\"maxOpenPreparedStatements\":").append(this.maxOpenPreparedStatements).append(",\"userTimeout\":").append(this.userTimeout).append(",\"minEvictableIdleTimeMilli\":").append(this.getMinEvictableIdleTimeMillis()).append(",\"maxWait\":\"").append(this.maxWait).append("\"").append(",\"transactionTimeout\":").append(this.transactionTimeout).append(",\"timeBetweenEvictionRunsMillis\":").append(this.timeBetweenEvictionRunsMillis).append(",").append("\"numTestsPerEvictionRun\":").append(this.numTestsPerEvictionRun).append(",").append("\"interceptor\":\"").append(this.interceptor).append("\",").append("\"idGenerator\":").append(this.idGenerator).append(",\"jndiclass\":").append(this.jndiclass).append(",\"jndiuser\":").append(this.jndiuser).append(",").append("\"jndipassword\":******");
            if (this.getDbInfoEncrypt() != null) {
                data.append(",\"DbInfoEncrypt\":").append(this.getDbInfoEncrypt().getClass().getCanonicalName());
            } else {
                data.append(",\"DbInfoEncrypt\":");
            }
            if (this.getConnectionProperties() != null) {
                data.append(",\"properties\":").append(SimpleStringUtil.object2json((Object)this.getConnectionProperties()));
            }
            data.append(",\"balance\":").append(this.balance).append(",\"enableBalance\":\"").append(this.enableBalance);
            data.append(",\"jndiurl\":").append(this.jndiurl).append(",\"keygenerate\":\"").append(this.keygenerate).append("\",\"autoprimarykey\":").append(this.autoprimarykey).append(",\"robotquery\":").append(this.robotquery).append(",\"poolPreparedStatements\":").append(this.isPoolPreparedStatements()).append(",").append("\"return_GENERATED_KEYS\":").append(this.getRETURN_GENERATED_KEYS()).append(",\"txIsolationLevel\":").append(this.getTxIsolationLevel()).append("}");
            return data.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public DBInfoEncrypt getDbInfoEncrypt() {
        return this.dbInfoEncrypt;
    }

    public boolean isShowsqlParams() {
        return this.showsqlParams;
    }

    public void setShowsqlParams(boolean showsqlParams) {
        this.showsqlParams = showsqlParams;
    }

    public boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public void setEnableShutdownHook(boolean enableShutdownHook) {
        this.enableShutdownHook = enableShutdownHook;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public boolean isEnableBalance() {
        return this.enableBalance;
    }

    public void setEnableBalance(boolean enableBalance) {
        this.enableBalance = enableBalance;
    }

    public String getBalance() {
        return this.balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public boolean isColumnLableUpperCase() {
        return this.columnLableUpperCase;
    }

    public void setColumnLableUpperCase(boolean columnLableUpperCase) {
        this.columnLableUpperCase = columnLableUpperCase;
    }

    public String getDbInfoEncryptClass() {
        return this.dbInfoEncryptClass;
    }

    public void setDbInfoEncryptClass(String dbInfoEncryptClass) {
        this.dbInfoEncryptClass = dbInfoEncryptClass;
        if (this.dbInfoEncryptClass != null && !this.dbInfoEncryptClass.equals("")) {
            try {
                this.dbInfoEncrypt = (DBInfoEncrypt)Class.forName(dbInfoEncryptClass).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

