/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm;

import com.frameworkset.orm.ORMappingException;
import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.Table;
import com.frameworkset.orm.engine.transform.XmlToAppData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ORMappingManager
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(ORMappingManager.class);
    public static final String ANONYMITY_DATABASE_TYPE = "Default";
    public static final String ANONYMITY_DATABASE_NAME = "anonymity_database";
    private static ORMappingManager instance = null;
    private static final Map dataBases = Collections.synchronizedMap(new HashMap(10));
    private boolean locked = false;

    private ORMappingManager() {
    }

    public static void main(String[] args) {
        ORMappingManager ormappingmanager = new ORMappingManager();
    }

    private static void synchronizePersist() {
        File cachFile = new File(System.getProperty("basedir"), "ORMappingManager.Cache");
        cachFile.deleteOnExit();
    }

    private static void synchronizePersist(String path) {
        File cachFile = new File(path, "ORMappingManager.Cache");
        cachFile.deleteOnExit();
    }

    public static ORMappingManager getInstance() {
        if (instance == null) {
            try {
                log.debug("Restore persist object from ORMappingManager.Cache");
                instance = ORMappingManager.restore();
            }
            catch (Exception ex) {
                log.debug("No persist ORMappingManager instance or ORMappingManager instance not synchronizable with the persist object:" + ex.getMessage());
                ORMappingManager.synchronizePersist();
            }
            if (instance == null) {
                log.debug("Create instance of ORMappingManager.");
                instance = new ORMappingManager();
            }
        }
        return instance;
    }

    public static ORMappingManager getInstance(String path) {
        if (instance == null) {
            try {
                log.debug("Restore persist object from " + path + "/ORMappingManager.Cache");
                instance = ORMappingManager.restore(path);
            }
            catch (Exception ex) {
                log.debug("No persist ORMappingManager instance or ORMappingManager instance not synchronizable with the persist object:" + ex.getMessage());
                ORMappingManager.synchronizePersist(path);
            }
            if (instance == null) {
                log.debug("Create instance of ORMappingManager.");
                instance = new ORMappingManager();
            }
        }
        return instance;
    }

    public Database creatAnonymityDataBase() {
        log.debug("Get Anonymity database.");
        return (Database)dataBases.get(ANONYMITY_DATABASE_NAME);
    }

    public Database creatDataBase(String dbName, String dbType) {
        return this.creatAnonymityDataBase();
    }

    public Database creatDataBase(String dbName) {
        return this.creatAnonymityDataBase();
    }

    public Database creatDefaultDataBase() {
        return this.creatAnonymityDataBase();
    }

    public Database getDatabase(String dbName) throws ORMappingException {
        return this.getAnonymityDatabase();
    }

    public Database getAnonymityDatabase() throws ORMappingException {
        if (!dataBases.containsKey(ANONYMITY_DATABASE_NAME)) {
            throw new ORMappingException("Can not get ANONYMITY_DATABASE\uff01");
        }
        return (Database)dataBases.get(ANONYMITY_DATABASE_NAME);
    }

    public Database getDefaultDatabase() throws ORMappingException {
        return this.getAnonymityDatabase();
    }

    public Table creatTable() {
        return new Table();
    }

    public Table creatTable(String tableName) throws ORMappingException {
        return new Table(tableName);
    }

    public Column creatColumn() {
        log.debug("Creat column.");
        return new Column();
    }

    public Column creatColumn(String name) throws ORMappingException {
        if (name == null || name.trim().equals("")) {
            throw new ORMappingException("Can not creat culumn:column name is null or empty string");
        }
        log.debug("Creat column:name=" + name);
        return new Column(name);
    }

    public void cache() throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("ORMappingManager.Cache"));
        out.writeObject(instance);
        out.close();
    }

    public void cache(String cachePath) throws IOException {
        if (cachePath == null && cachePath.trim().length() == 0) {
            this.cache();
            return;
        }
        if (!cachePath.endsWith("/") || cachePath.endsWith("\\")) {
            cachePath.concat("/");
        }
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cachePath + "ORMappingManager.Cache"));
        out.writeObject(instance);
        out.close();
    }

    public static ORMappingManager restore() throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("ORMappingManager.Cache"));
        ORMappingManager w2 = (ORMappingManager)in.readObject();
        return w2;
    }

    public static ORMappingManager restore(String path) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("ORMappingManager.Cache"));
        ORMappingManager w2 = (ORMappingManager)in.readObject();
        return w2;
    }

    public void reset() {
        dataBases.clear();
        Database anonymityDatabase = new Database(ANONYMITY_DATABASE_TYPE);
        anonymityDatabase.setName(ANONYMITY_DATABASE_NAME);
        dataBases.put(ANONYMITY_DATABASE_NAME, anonymityDatabase);
    }

    public ORMappingManager restoreFromXml(String xmlPath) {
        File xmls = new File(xmlPath);
        if (!xmls.exists()) {
            xmls = new File(System.getProperty("basedir"), xmlPath);
        }
        if (!xmls.exists() || !xmls.isDirectory()) {
            log.debug("Database cache path must be directory!");
            return ORMappingManager.getInstance();
        }
        File[] schemas = xmls.listFiles(new SchemaFileFilter());
        if (schemas == null || schemas.length == 0) {
            log.debug("No database is found in directory " + xmls.getAbsolutePath() + "!");
            return ORMappingManager.getInstance();
        }
        for (int i = 0; i < schemas.length; ++i) {
            File schema = schemas[i];
            String filePath = "";
            filePath = schema.getAbsolutePath();
            if (schema.isDirectory()) {
                this.restoreFromXml(filePath);
                continue;
            }
            XmlToAppData xmlToAppData = new XmlToAppData(this.getDBType(schema.getName()));
            try {
                log.debug("Generate database from schema:" + filePath);
                Database db = xmlToAppData.parseFile(filePath);
                if (dataBases.containsKey(db.getName())) {
                    Database odb = (Database)dataBases.get(db.getName());
                    odb.addDataBase(db);
                    continue;
                }
                ORMappingManager.getInstance();
                dataBases.put(db.getName(), db);
                continue;
            }
            catch (EngineException ex) {
                log.error("Parse schema " + filePath + " error:" + ex.getMessage());
            }
        }
        return ORMappingManager.getInstance();
    }

    private String getDBType(String schema) {
        int ch = schema.indexOf("_");
        if (ch == -1) {
            return ANONYMITY_DATABASE_TYPE;
        }
        return schema.substring(0, ch);
    }

    private boolean containDataBase(File dir) {
        File[] files = dir.listFiles(new SchemaFileFilter());
        return files != null && files.length != 0;
    }

    public ORMappingManager cacheToXml(String xmlPath) throws ORMappingException {
        Collection databases;
        File xmls = new File(xmlPath);
        if (!xmls.exists()) {
            xmls = new File(System.getProperty("basedir"), xmlPath);
        }
        if (!xmls.exists() || !xmls.isDirectory()) {
            log.debug("Creat directory '" + xmlPath + "'");
            xmls.mkdirs();
        }
        if ((databases = dataBases.values()) != null) {
            for (Database db : databases) {
                File file = this.getSchemaFile(xmls, db.getDatabaseType(), db.getName());
                try {
                    log.debug("Save db metadata to schema file:" + file.getAbsolutePath() + "!");
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    out.write(db.toString().getBytes());
                    out.flush();
                }
                catch (IOException ex) {
                    log.debug("Save db metadata to schema file " + file.getAbsolutePath() + " failed!");
                }
            }
        }
        return instance;
    }

    public synchronized File getSchemaFile(File dir, String databaseType, String dbName) {
        String schemafileName = databaseType + "_" + dbName + ".xml";
        File schemafile = new File(dir, schemafileName);
        if (schemafile.exists()) {
            int i = 1;
            while ((schemafile = new File(dir, schemafileName = databaseType + "_" + dbName + "." + i + ".xml")).exists()) {
                ++i;
            }
        }
        return schemafile;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean locked() {
        return this.locked;
    }

    public void unlock() {
        this.locked = false;
    }

    static {
        if (!dataBases.containsKey(ANONYMITY_DATABASE_NAME)) {
            Database anonymityDatabase = new Database(ANONYMITY_DATABASE_TYPE);
            anonymityDatabase.setName(ANONYMITY_DATABASE_NAME);
            dataBases.put(ANONYMITY_DATABASE_NAME, anonymityDatabase);
        }
    }

    private class SchemaFileFilter
    implements FileFilter {
        private SchemaFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return pathname.getName().endsWith(".xml");
        }
    }
}

