/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.adapter;

import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.adapter.DBMM;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.frameworkset.persitent.datasource.BalanceDatasourceConfig;
import org.frameworkset.persitent.datasource.BalanceDatasourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBClickhouse
extends DBMM {
    private static Logger logger = LoggerFactory.getLogger(DBClickhouse.class);
    private static final String defaultFiledTodateFormat = "%Y-%m-%d %H:%i:%s";
    private static final String sql_sequence = "select nextval(?) as pk";
    public static final String[] JDBC_CLICKHOUSE_PREFIXS = new String[]{"jdbc:clickhouse://", "jdbc:clickhouse:http://", "jdbc:clickhouse:https://", "jdbc:ch:http://", "jdbc:ch:https://"};

    @Override
    public String sysdate() {
        return "sysdate()";
    }

    @Override
    public String getDBCatalog(Connection con) throws SQLException {
        return this._getDBCatalog(con);
    }

    @Override
    public String toUpperCase(String in) {
        return in;
    }

    @Override
    public String getSchema(JDBCPoolMetaData info, Connection con) throws SQLException {
        return con.getSchema();
    }

    @Override
    public String ignoreCase(String in) {
        return in;
    }

    @Override
    public String getIDMethodType() {
        return "autoincrement";
    }

    @Override
    public String getIDMethodSQL(Object obj) {
        return "SELECT LAST_INSERT_ID()";
    }

    @Override
    public long getNextValue(String sequence, Connection con, String dbname) throws SQLException {
        PreparedDBUtil dbutil = new PreparedDBUtil();
        dbutil.preparedSelect(dbname, sql_sequence);
        dbutil.setString(1, sequence);
        dbutil.executePrepared();
        return dbutil.getLong(0, 0);
    }

    @Override
    public long getNextValue(String seqfunctionname, String sequence, Connection con, String dbname) throws SQLException {
        PreparedDBUtil dbutil = new PreparedDBUtil();
        if (seqfunctionname == null || seqfunctionname.equals("")) {
            dbutil.preparedSelect(dbname, sql_sequence);
        } else {
            dbutil.preparedSelect(dbname, "select " + seqfunctionname + "(?)  as pk");
        }
        dbutil.setString(1, sequence);
        dbutil.executePrepared();
        return dbutil.getLong(0, 0);
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = con.createStatement();
        StringBuilder stmt = new StringBuilder();
        stmt.append("LOCK TABLE ").append(table).append(" WRITE");
        statement.executeUpdate(stmt.toString());
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
        Statement statement = con.createStatement();
        statement.executeUpdate("UNLOCK TABLES");
    }

    @Override
    public boolean supportsNativeLimit() {
        return true;
    }

    @Override
    public boolean supportsNativeOffset() {
        return true;
    }

    @Override
    public int getLimitStyle() {
        return 2;
    }

    @Override
    public String to_char(String date, String format) {
        StringBuilder ret = new StringBuilder();
        ret.append("date_format(").append(date).append(",'").append(format != null ? format : this.FORMART_ALL).append("')");
        return ret.toString();
    }

    @Override
    public String to_char(String date) {
        return this.to_char(date, this.FORMART_ALL);
    }

    @Override
    public String getDateString(Date date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String getDateString(Date date, String format) {
        return this.to_date(date, format);
    }

    @Override
    public String getDateString(String date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String getDateString(String date, String format) {
        return this.to_date(date, format);
    }

    @Override
    public String to_date(Date date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String to_date(Date date, String format) {
        if (date == null) {
            return null;
        }
        char delim = this.getStringDelimiter();
        return delim + new SimpleDateFormat(format == null ? this.date_format : format).format(date) + delim;
    }

    @Override
    public String to_date(String date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String to_date(String date, String format) {
        if (date == null) {
            return null;
        }
        char delim = this.getStringDelimiter();
        return delim + new SimpleDateFormat(format == null ? this.date_format : format).format(SimpleStringUtil.stringToDate((String)date, (String)format)) + delim;
    }

    @Override
    public String filedToDateFunction(String date) {
        if (date == null) {
            return null;
        }
        return "str_to_date(" + date + ",'" + defaultFiledTodateFormat + "')";
    }

    @Override
    public String filedToDateFunction(String date, String format) {
        if (date == null) {
            return null;
        }
        return "str_to_date(" + date + ",'" + format + "')";
    }

    @Override
    public String getIDMAXSql(String table_name, String table_id_name, String table_id_prefix, String type) {
        String maxSql = "select max(" + table_id_name + ") from " + table_name;
        if (type.equalsIgnoreCase("string") || type.equalsIgnoreCase("java.lang.string")) {
            maxSql = table_id_prefix != null && !table_id_prefix.trim().equals("") ? "select max(CAST(SUBSTRING(" + table_id_name + ",len(" + table_id_prefix + ") + 1) as DECIMAL))) from " + table_name : "select max(CAST(" + table_id_name + " as DECIMAL)) from " + table_name;
        }
        return maxSql;
    }

    @Override
    public DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared) {
        StringBuilder newsql = null;
        newsql = prepared ? new StringBuilder().append(sql).append(" limit ?,?") : new StringBuilder().append(sql).append(" limit ").append(offset).append(",").append(maxsize);
        return new DB.PagineSql(newsql.toString(), offset, maxsize, offset, maxsize, prepared).setRebuilded(true);
    }

    @Override
    public String getStringPagineSql(String sql) {
        StringBuilder newsql = new StringBuilder().append(sql).append(" limit ?,?");
        return newsql.toString();
    }

    @Override
    public String getStringPagineSql(String schema, String tablename, String pkname, String columns) {
        StringBuilder sqlbuilder = new StringBuilder();
        sqlbuilder.append("SELECT ");
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(columns);
        } else {
            sqlbuilder.append("* ");
        }
        sqlbuilder.append(" from   ");
        if (schema != null && !schema.equals("")) {
            sqlbuilder.append(schema).append(".");
        }
        sqlbuilder.append(tablename);
        sqlbuilder.append(" limit ?,?");
        return sqlbuilder.toString();
    }

    @Override
    public DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared, String orderBy) {
        StringBuilder newsql = null;
        newsql = prepared ? new StringBuilder().append(sql).append(" ").append(orderBy).append(" limit ?,?") : new StringBuilder().append(sql).append(" ").append(orderBy).append(" limit ").append(offset).append(",").append(maxsize);
        return new DB.PagineSql(newsql.toString(), offset, maxsize, offset, maxsize, prepared).setRebuilded(true);
    }

    @Override
    public String getStringPagineSql(String sql, String orderBy) {
        StringBuilder newsql = new StringBuilder().append(sql).append(" ").append(orderBy).append(" limit ?,?");
        return newsql.toString();
    }

    @Override
    public String getStringPagineSql(String schema, String tablename, String pkname, String columns, String orderBy) {
        StringBuilder sqlbuilder = new StringBuilder();
        sqlbuilder.append("SELECT ");
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(columns);
        } else {
            sqlbuilder.append("* ");
        }
        sqlbuilder.append(" from   ");
        if (schema != null && !schema.equals("")) {
            sqlbuilder.append(schema).append(".");
        }
        sqlbuilder.append(tablename);
        sqlbuilder.append(" ").append(orderBy).append(" limit ?,?");
        return sqlbuilder.toString();
    }

    @Override
    public void queryByNullRowHandler(NullRowHandler handler, String dbname, String pageinestatement, long offset, int pagesize) throws SQLException {
        SQLExecutor.queryWithDBNameByNullRowHandler(handler, dbname, pageinestatement, offset, pagesize);
    }

    @Override
    public void resetPostion(PreparedStatement statement, int startidx, int endidx, long offset, int maxsize) throws SQLException {
        statement.setLong(startidx, offset);
        statement.setLong(endidx, maxsize);
    }

    @Override
    public Object getLONGVARBINARY(CallableStatement cstmt, int parameterIndex) throws SQLException {
        return cstmt.getBlob(parameterIndex);
    }

    @Override
    public Object getLONGVARCHAR(CallableStatement cstmt, int parameterIndex) throws SQLException {
        return cstmt.getClob(parameterIndex);
    }

    @Override
    public Object getLONGVARCHAR(ResultSet res, int parameterIndex) throws SQLException {
        return res.getClob(parameterIndex);
    }

    @Override
    public Object getLONGVARBINARY(ResultSet res, int parameterIndex) throws SQLException {
        return res.getBlob(parameterIndex);
    }

    @Override
    public Object getLONGVARBINARY(CallableStatement cstmt, String parameterIndex) throws SQLException {
        return cstmt.getBlob(parameterIndex);
    }

    @Override
    public Object getLONGVARCHAR(CallableStatement cstmt, String parameterIndex) throws SQLException {
        return cstmt.getClob(parameterIndex);
    }

    @Override
    public Object getLONGVARCHAR(ResultSet res, String parameterIndex) throws SQLException {
        return res.getClob(parameterIndex);
    }

    @Override
    public Object getLONGVARBINARY(ResultSet res, String parameterIndex) throws SQLException {
        return res.getBlob(parameterIndex);
    }

    @Override
    public String concat(String ... concatString) {
        if (concatString == null || concatString.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        boolean i = false;
        for (String token : concatString) {
            if (!i) {
                ret.append("concat(").append(token);
                i = true;
                continue;
            }
            ret.append(" , ").append(token);
        }
        ret.append(")");
        return ret.toString();
    }

    @Override
    public String disableFK(String table, String FKName) {
        StringBuilder ret = new StringBuilder();
        ret.append("alter table ").append(table).append(" drop FOREIGN KEY ").append(FKName);
        return ret.toString();
    }

    @Override
    public String enableFK(String table, String FKName, String column, String FKTable, String FKColumn) {
        StringBuilder ret = new StringBuilder();
        ret.append("alter table ").append(table).append(" add constraint ").append(FKName).append(" foreign key (").append(column).append(") references ").append(FKTable).append(" (").append(FKColumn).append(")");
        return ret.toString();
    }

    @Override
    public boolean neadGetGenerateKeys() {
        return true;
    }

    @Override
    public void putFetchsize(PreparedStatement pstmt, Integer fetchSize) throws SQLException {
        if (fetchSize != null && fetchSize != 0) {
            pstmt.setFetchSize(fetchSize);
        }
    }

    @Override
    public void setRowId(Record record, ResultSet rs) throws SQLException {
    }

    @Override
    public Statement createStatement(Connection con, int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = con.createStatement();
        return stmt;
    }

    @Override
    public BalanceDatasourceConfig getBalanceDatasourceConfig(String url) throws SQLException {
        return BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, url, true);
    }

    @Override
    public ResultSet getImportedKeys(DatabaseMetaData metaData, String catalog, String schemaName, String tableName) throws SQLException {
        return null;
    }
}

