/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.model;

import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.Domain;
import com.frameworkset.orm.engine.model.ForeignKey;
import com.frameworkset.orm.engine.model.Inheritance;
import com.frameworkset.orm.engine.model.NameFactory;
import com.frameworkset.orm.engine.model.SchemaType;
import com.frameworkset.orm.engine.model.Table;
import com.frameworkset.orm.engine.model.TypeMap;
import com.frameworkset.orm.platform.Platform;
import com.frameworkset.orm.platform.PlatformDefaultImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class Column
implements Serializable {
    private static final SchemaType DEFAULT_TYPE = SchemaType.VARCHAR;
    private static Logger log = LoggerFactory.getLogger(Column.class);
    private String name;
    private String description;
    private Domain domain = new Domain();
    private String javaName = null;
    private String javaNamingMethod;
    private boolean isNotNull = false;
    private String javaType;
    private Table parentTable;
    private int position;
    private boolean isPrimaryKey = false;
    private boolean isUnique = false;
    private boolean isAutoIncrement = false;
    private List referrers;
    private String inheritanceType;
    private boolean isInheritance;
    private boolean isEnumeratedClasses;
    private List inheritanceList;
    private boolean needsTransactionInPostgres;
    private boolean correctGetters = false;
    private String inputValidator = null;

    public Column() {
        this(null);
    }

    public Column(String name) {
        this.name = name;
    }

    public static String makeList(List columns) {
        Object obj = columns.get(0);
        boolean isColumnList = obj instanceof Column;
        if (isColumnList) {
            obj = ((Column)obj).getName();
        }
        StringBuilder buf = new StringBuilder((String)obj);
        for (int i = 1; i < columns.size(); ++i) {
            obj = columns.get(i);
            if (isColumnList) {
                obj = ((Column)obj).getName();
            }
            buf.append(", ").append(obj);
        }
        return buf.toString();
    }

    public void loadFromXML(Attributes attrib) {
        String notNull;
        String dom = attrib.getValue("domain");
        if (StringUtils.isNotEmpty((String)dom)) {
            this.domain = new Domain(this.getTable().getDatabase().getDomain(dom));
        } else {
            this.domain = new Domain(this.getPlatform().getDomainForSchemaType(DEFAULT_TYPE));
            this.setType(attrib.getValue("type"));
        }
        this.name = attrib.getValue("name");
        this.javaName = attrib.getValue("javaName");
        this.javaType = attrib.getValue("javaType");
        if (this.javaType != null && this.javaType.length() == 0) {
            this.javaType = null;
        }
        this.javaNamingMethod = attrib.getValue("javaNamingMethod");
        if (this.javaNamingMethod == null) {
            this.javaNamingMethod = this.parentTable.getDatabase().getDefaultJavaNamingMethod();
        }
        String primaryKey = attrib.getValue("primaryKey");
        this.isPrimaryKey = "true".equals(primaryKey);
        if ("true".equals(primaryKey)) {
            this.isNotNull = true;
        }
        this.isNotNull = (notNull = attrib.getValue("required")) != null && "true".equals(notNull);
        String autoIncrement = attrib.getValue("autoIncrement");
        this.isAutoIncrement = "true".equals(autoIncrement) || this.isPrimaryKey() && "native".equals(this.getTable().getIdMethod()) && "identity".equals(this.getPlatform().getNativeIdMethod()) && !"false".equals(autoIncrement);
        this.domain.replaceDefaultValue(attrib.getValue("default"));
        this.domain.replaceSize(attrib.getValue("size"));
        this.domain.replaceScale(attrib.getValue("scale"));
        this.inheritanceType = attrib.getValue("inheritance");
        this.isInheritance = this.inheritanceType != null && !this.inheritanceType.equals("false");
        this.inputValidator = attrib.getValue("inputValidator");
        this.description = attrib.getValue("description");
    }

    public String getFullyQualifiedName() {
        return this.parentTable.getName() + '.' + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getJavaName() {
        if (this.javaName == null) {
            ArrayList<String> inputs = new ArrayList<String>(2);
            inputs.add(this.name);
            inputs.add(this.javaNamingMethod);
            try {
                this.javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs, false);
            }
            catch (EngineException e) {
                log.error("", (Throwable)((Object)e));
            }
        }
        return StringUtils.capitalize((String)this.javaName);
    }

    public String getGetterName() {
        if ("boolean".equalsIgnoreCase(this.getJavaNative()) && this.isCorrectGetters()) {
            return "is" + StringUtils.capitalize((String)this.getJavaName());
        }
        return "get" + StringUtils.capitalize((String)this.getJavaName());
    }

    public String getSetterName() {
        return "set" + StringUtils.capitalize((String)this.getJavaName());
    }

    public String getUncapitalisedJavaName() {
        return StringUtils.uncapitalize((String)this.getJavaName());
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int v) {
        this.position = v;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public Inheritance addInheritance(Attributes attrib) {
        Inheritance inh = new Inheritance();
        inh.loadFromXML(attrib);
        this.addInheritance(inh);
        return inh;
    }

    public void addInheritance(Inheritance inh) {
        inh.setColumn(this);
        if (this.inheritanceList == null) {
            this.inheritanceList = new ArrayList();
            this.isEnumeratedClasses = true;
        }
        this.inheritanceList.add(inh);
    }

    public List getChildren() {
        return this.inheritanceList;
    }

    public boolean isInheritance() {
        return this.isInheritance;
    }

    public boolean isEnumeratedClasses() {
        return this.isEnumeratedClasses;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public void setNotNull(boolean status) {
        this.isNotNull = status;
    }

    public String getNotNullString() {
        return this.getTable().getDatabase().getPlatform().getNullString(this.isNotNull());
    }

    public void setPrimaryKey(boolean pk) {
        this.isPrimaryKey = pk;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setUnique(boolean u) {
        this.isUnique = u;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean requiresTransactionInPostgres() {
        return this.needsTransactionInPostgres;
    }

    public boolean isForeignKey() {
        return this.getForeignKey() != null;
    }

    public boolean isMultipleFK() {
        ForeignKey fk = this.getForeignKey();
        if (fk != null) {
            for (ForeignKey key : this.parentTable.getForeignKeys()) {
                if (!key.getForeignTableName().equals(fk.getForeignTableName()) || key.getLocalColumns().contains(this.name)) continue;
                return true;
            }
        }
        return false;
    }

    public ForeignKey getForeignKey() {
        return this.parentTable.getForeignKey(this.name);
    }

    public String getRelatedTableName() {
        ForeignKey fk = this.getForeignKey();
        return fk == null ? null : fk.getForeignTableName();
    }

    public String getRelatedColumnName() {
        ForeignKey fk = this.getForeignKey();
        if (fk == null) {
            return null;
        }
        return fk.getLocalForeignMapping().get(this.name).toString();
    }

    public void addReferrer(ForeignKey fk) {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        this.referrers.add(fk);
    }

    public List getReferrers() {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        return this.referrers;
    }

    public void setType(String torqueType) {
        SchemaType type = SchemaType.getEnum(torqueType);
        if (type == null) {
            log.warn("SchemaType " + torqueType + " does not exist");
            type = DEFAULT_TYPE;
        }
        this.setType(type);
    }

    public void setType(SchemaType torqueType) {
        this.domain = new Domain(this.getPlatform().getDomainForSchemaType(torqueType));
        if (torqueType.equals(SchemaType.VARBINARY) || torqueType.equals(SchemaType.BLOB)) {
            this.needsTransactionInPostgres = true;
        }
    }

    public Object getType() {
        return TypeMap.getJdbcType(this.domain.getType()).getName();
    }

    public Object getTorqueType() {
        return this.domain.getType().getName();
    }

    public boolean isString() {
        return this.domain.getType().getName().indexOf("CHAR") != -1;
    }

    public boolean needEscapedValue() {
        String torqueType = this.domain.getType().getName();
        return torqueType != null && (torqueType.equals("VARCHAR") || torqueType.equals("LONGVARCHAR") || torqueType.equals("DATE") || torqueType.equals("DATETIME") || torqueType.equals("TIMESTAMP") || torqueType.equals("TIME") || torqueType.equals("CHAR") || torqueType.equals("CLOB"));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("    <column name=\"").append(this.name).append('\"');
        if (this.javaName != null) {
            result.append(" javaName=\"").append(this.javaName).append('\"');
        }
        if (this.isPrimaryKey) {
            result.append(" primaryKey=\"").append(this.isPrimaryKey).append('\"');
        }
        if (this.isNotNull) {
            result.append(" required=\"true\"");
        } else {
            result.append(" required=\"false\"");
        }
        result.append(" type=\"").append(this.domain.getType().getName()).append('\"');
        if (this.domain.getSize() != null) {
            result.append(" size=\"").append(this.domain.getSize()).append('\"');
        }
        if (this.domain.getScale() != null) {
            result.append(" scale=\"").append(this.domain.getScale()).append('\"');
        }
        if (this.domain.getDefaultValue() != null) {
            result.append(" default=\"").append(this.domain.getDefaultValue()).append('\"');
        }
        if (this.isInheritance()) {
            result.append(" inheritance=\"").append(this.inheritanceType).append('\"');
        }
        result.append(" />\n");
        return result.toString();
    }

    public String getSize() {
        return this.domain.getSize();
    }

    public void setSize(String newSize) {
        this.domain.setSize(newSize);
    }

    public String getScale() {
        return this.domain.getScale();
    }

    public void setScale(String newScale) {
        this.domain.setScale(newScale);
    }

    public String printSize() {
        return this.domain.printSize();
    }

    public String getDefaultSetting() {
        return this.domain.getDefaultSetting();
    }

    public void setDefaultValue(String def) {
        this.domain.setDefaultValue(def);
    }

    public String getDefaultValue() {
        return this.domain.getDefaultValue();
    }

    public String getInputValidator() {
        return this.inputValidator;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(boolean value) {
        this.isAutoIncrement = value;
    }

    public String getAutoIncrementString() {
        if (this.isAutoIncrement() && "native".equals(this.getTable().getIdMethod())) {
            return this.getPlatform().getAutoIncrement();
        }
        return "";
    }

    public void setTypeFromString(String typeName, String size) {
        String tn = typeName.toUpperCase();
        this.setType(tn);
        if (size != null) {
            this.domain.setSize(size);
        }
        if (tn.indexOf("CHAR") != -1) {
            this.domain.setType(SchemaType.VARCHAR);
        } else if (tn.indexOf("INT") != -1) {
            this.domain.setType(SchemaType.INTEGER);
        } else if (tn.indexOf("FLOAT") != -1) {
            this.domain.setType(SchemaType.FLOAT);
        } else if (tn.indexOf("DATE") != -1) {
            this.domain.setType(SchemaType.DATE);
        } else if (tn.indexOf("TIME") != -1) {
            this.domain.setType(SchemaType.TIMESTAMP);
        } else if (tn.indexOf("BINARY") != -1) {
            this.domain.setType(SchemaType.LONGVARBINARY);
        } else {
            this.domain.setType(SchemaType.VARCHAR);
        }
    }

    public String getJavaObject() {
        return TypeMap.getJavaObject(this.domain.getType());
    }

    public String getJavaPrimitive() {
        return TypeMap.getJavaNative(this.domain.getType());
    }

    public String getJavaNative() {
        String jtype = TypeMap.getJavaNativeObject(this.domain.getType());
        if (this.isUsePrimitive()) {
            jtype = TypeMap.getJavaNative(this.domain.getType());
        }
        return jtype;
    }

    public String getVillageMethod() {
        String vmethod = TypeMap.getVillageObjectMethod(this.domain.getType());
        if (this.isUsePrimitive()) {
            vmethod = TypeMap.getVillageMethod(this.domain.getType());
        }
        return vmethod;
    }

    public String getParameterParserMethod() {
        return TypeMap.getPPMethod(this.domain.getType());
    }

    public boolean isBooleanInt() {
        return TypeMap.isBooleanInt(this.domain.getType());
    }

    public boolean isBooleanChar() {
        return TypeMap.isBooleanChar(this.domain.getType());
    }

    public boolean isBit() {
        return TypeMap.isBit(this.domain.getType());
    }

    public boolean isPrimitive() {
        String t = this.getJavaNative();
        return "boolean".equals(t) || "byte".equals(t) || "short".equals(t) || "int".equals(t) || "long".equals(t) || "float".equals(t) || "double".equals(t) || "char".equals(t);
    }

    public boolean isUsePrimitive() {
        String s = this.getJavaType();
        return s != null && s.equals("primitive") || s == null && !"object".equals(this.getTable().getDatabase().getDefaultJavaType());
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    private Platform getPlatform() {
        try {
            Table table = this.getTable();
            Database dataBase = table.getDatabase();
            Platform platform = dataBase.getPlatform();
            return platform;
        }
        catch (Exception ex) {
            log.warn("could not load platform implementation");
            return new PlatformDefaultImpl();
        }
    }

    public String getSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(' ');
        sb.append(this.getDomain().getSqlType());
        if (this.getPlatform().hasSize(this.getDomain().getSqlType())) {
            sb.append(this.getDomain().printSize());
            sb.append(' ');
        }
        if (this.getDomain().getDefaultValue() != null) {
            sb.append("default ");
            if (TypeMap.isTextType(this.getDomain().getType())) {
                sb.append('\'').append(this.getDefaultValue()).append('\'');
            } else {
                sb.append(this.getDefaultValue());
            }
            sb.append(' ');
        }
        sb.append(this.getNotNullString());
        sb.append(' ');
        sb.append(this.getAutoIncrementString());
        return sb.toString();
    }

    public boolean isCorrectGetters() {
        return this.correctGetters;
    }

    public void setCorrectGetters(boolean correctGetters) {
        this.correctGetters = correctGetters;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }
}

