/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.model;

import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class Index
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(Index.class);
    private String indexName;
    private Table parentTable;
    private List indexColumns = new ArrayList(3);

    public Index() {
    }

    protected Index(Table table, List indexColumns) throws EngineException {
        this();
        this.setTable(table);
        if (!indexColumns.isEmpty()) {
            this.indexColumns = indexColumns;
            if (log.isDebugEnabled()) {
                log.debug("Created Index named " + this.getName() + " with " + indexColumns.size() + " columns");
            }
        } else {
            throw new EngineException("Cannot create a new Index using an empty list Column object");
        }
    }

    public void loadFromXML(Attributes attrib) {
        this.indexName = attrib.getValue("name");
    }

    public boolean isUnique() {
        return false;
    }

    public String getName() {
        return this.indexName;
    }

    public void setName(String name) {
        this.indexName = name;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public void addColumn(Attributes attrib) {
        this.indexColumns.add(attrib.getValue("name"));
    }

    public String getColumnList() {
        return Column.makeList(this.getColumns());
    }

    public List getColumns() {
        return this.indexColumns;
    }

    protected List getColumnNames() {
        ArrayList<String> names = new ArrayList<String>(this.indexColumns.size() + 2);
        for (Column c : this.getColumns()) {
            names.add(c.getName());
        }
        return names;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" <index name=\"").append(this.getName()).append("\"");
        result.append(">\n");
        for (int i = 0; i < this.indexColumns.size(); ++i) {
            result.append("  <index-column name=\"").append(this.indexColumns.get(i)).append("\"/>\n");
        }
        result.append(" </index>\n");
        return result.toString();
    }
}

