/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.interceptor;

import com.frameworkset.orm.transaction.TransactionManager;
import com.frameworkset.proxy.Interceptor;
import java.lang.reflect.Method;
import org.frameworkset.spi.assemble.SynchronizedMethod;

public final class TransactionInterceptor
implements Interceptor {
    private TransactionManager tm;
    private SynchronizedMethod synmethod;

    public TransactionInterceptor(SynchronizedMethod synmethod) {
        this.synmethod = synmethod;
    }

    public void after(Method method, Object[] args) throws Throwable {
        if (this.tm == null) {
            return;
        }
        this.tm.commit();
    }

    public void afterFinally(Method method, Object[] args) throws Throwable {
        if (this.tm != null) {
            this.tm.releasenolog();
            this.tm = null;
        }
    }

    public void afterThrowing(Method method, Object[] args) throws Throwable {
        this.afterThrowing(method, args, null);
    }

    public void afterThrowing(Method method, Object[] args, Throwable throwable) throws Throwable {
        if (this.tm == null) {
            return;
        }
        if (this.synmethod.isRollbackException(throwable)) {
            try {
                this.tm.rollback();
            }
            catch (Exception exception) {}
        } else {
            this.tm.commit();
        }
    }

    public void before(Method method, Object[] args) throws Throwable {
        if (this.synmethod != null) {
            this.tm = new TransactionManager();
            this.tm.begin(this.synmethod.getTxtype());
        }
    }
}

