/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.FileUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.Blob;
import java.sql.Clob;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.frameworkset.util.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil
extends SimpleStringUtil {
    public static final String COOKIE_PREFIX = "pager";
    private static Logger log = LoggerFactory.getLogger(StringUtil.class);
    private static Method httpOnlyMethod = null;
    private static String[] realIpHeaders = new String[]{"X-Forwarded-For", "x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP"};

    public static String getCookieValue(HttpServletRequest request, String name, String defaultvalue) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return defaultvalue;
        }
        String temp_ = null;
        for (Cookie temp : cookies) {
            if (!name.equals(temp.getName())) continue;
            temp_ = temp.getValue();
            break;
        }
        if (temp_ == null) {
            temp_ = defaultvalue;
        }
        return temp_;
    }

    public static String builderPagingSizeCookieName(String pagerContextId, String baseUri) {
        baseUri = baseUri.replace('/', '_');
        String cookieid = pagerContextId == null ? COOKIE_PREFIX + baseUri : COOKIE_PREFIX + baseUri + "_" + pagerContextId;
        return cookieid;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        return StringUtil.getCookieValue(request, name, null);
    }

    public static void addCookieValue(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxage) {
        StringUtil.addCookieValue(request, response, name, value, maxage, true);
    }

    public static void addCookieValue(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxage, boolean httponly, boolean secure) {
        StringUtil.addCookieValue(request, response, name, value, maxage, httponly, secure, null);
    }

    public static boolean hasHttpOnlyMethod() {
        return httpOnlyMethod != null;
    }

    public static void addCookieValue(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxage, boolean httponly, boolean secure, String domain) {
        StringUtil.addCookieValue(request, null, response, name, value, maxage, httponly, secure, domain);
    }

    public static void addCookieValue(HttpServletRequest request, String path, HttpServletResponse response, String name, String value, int maxage, boolean httponly, boolean secure, String domain) {
        try {
            if (path == null) {
                path = request.getContextPath();
            }
            if (path.equals("")) {
                path = "/";
            }
            Cookie loginPathCookie = null;
            loginPathCookie = new Cookie(name, value);
            loginPathCookie.setMaxAge(maxage);
            loginPathCookie.setPath(path);
            if (httpOnlyMethod != null) {
                httpOnlyMethod.invoke((Object)loginPathCookie, httponly);
            }
            loginPathCookie.setSecure(secure);
            if (domain != null) {
                loginPathCookie.setDomain(domain);
            }
            response.addCookie(loginPathCookie);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addCookieValue(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxage, boolean httponly) {
        StringUtil.addCookieValue(request, response, name, value, maxage, httponly, false);
    }

    public static void addCookieValue(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        StringUtil.addCookieValue(request, response, name, value, 86400);
    }

    public static String getRealPath(HttpServletRequest request, String path) {
        if (StringUtil.isHttpUrl((String)path)) {
            return path;
        }
        String contextPath = request.getContextPath();
        if (contextPath == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/") && !path.startsWith(contextPath + "/")) {
            if (!contextPath.equals("/")) {
                return contextPath + path;
            }
            return path;
        }
        return path;
    }

    public static String getRealPath(HttpServletRequest request, String path, boolean usebase) {
        if (StringUtil.isHttpUrl((String)path)) {
            return path;
        }
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("") || contextPath.equals("/")) {
            if (usebase) {
                if (StringUtil.isEmpty((String)path)) {
                    return "/";
                }
                return path.startsWith("/") ? path : "/" + path;
            }
            return path;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/") && !path.startsWith(contextPath + "/") && !contextPath.equals("/")) {
            path = contextPath + path;
        }
        return path;
    }

    public static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    public static void main(String[] args) {
        int maxlength = 16;
        String replace = "...";
        String outStr = "2010\u5e7402\u670804\u65e512\u65f6\u8bb8\uff0c\u4f55\u91d1\u7476\uff08\u5973\u30011987\u5e7406\u670818\u65e5\u751f\u3001\u8eab\u4efd\u8bc1\uff1a430981198706184686\u3001\u6e56\u5357\u7701\u6c85\u6c5f\u5e02\u6c85\u6c5f\u5e02\u5357\u5927\u81b3\u9547\u5eb7\u5b81\u6751\u5341\u4e8c\u6751\u6c11\u7ec424\u53f7\uff09\u62a5\u8b66\uff1a\u5176\u7ecf\u8425\u7684\u76ca\u9633\u5e02\u7535\u4fe1\u5bf9\u9762\u7684\u6674\u5929\u670d\u88c5\u5e97\u88ab\u76d7\u4e86\u3002\u63a5\u8b66\u540e\u6211\u6240\u6c11\u8b66\u7acb\u5373\u8d76\u81f3\u73b0\u573a\u4e86\u89e3\u7cfb\uff0c\u4eca\u65e5\u4e2d\u534812\u65f6\u8bb8\u4f55\u91d1\u7476\u4e0e\u6bcd\u4eb2\u9ec4\u5fd7\u5143\u5728\u5e97\u5185\u505a\u751f\u610f\uff0c\u6709\u4e24\u7537\u5b50\u8fdb\u5165\u5e97\u5185\uff0c\u5176\u4e2d\u4e00\u7537\u5b50\u4ee5\u642c\u5e97\u5185\u7684\u8bd5\u8863\u955c\u51fa\u53bb\u5438\u5f15\u6ce8\u610f\u529b\u3002\u53e6\u4e00\u7537\u5b50\u5c31\u8fdb\u884c\u76d7\u7a83\uff0c\u76d7\u53d6\u4e86\u5176\u5e97\u5185\u6536\u94f6\u53f0\u62bd\u5c49\u5185700\u5143\u4eba\u6c11\u5e01";
        System.out.println(StringUtil.getHandleString(maxlength, replace, false, false, outStr));
        outStr = "2010\u5e7402\u670807\u65e511\u65f6\u8bb8\uff0c\u5468\u7075\u9896\u62a5\u8b66\uff1a\u57282\u8def\u516c\u4ea4\u8f66\u4e0a\u88ab\u6252\u7a83\uff0c\u5e76\u6293\u83b7\u4e00\u540d\u5acc\u7591\u4eba\u3002\u6c11\u8b66\u51fa\u8b66\u540e\uff0c\u7ecf\u8c03\u67e5\uff0c\u5468\u7075\u9896\u4e8e\u5f53\u65e510\u65f640\u5206\u8bb8\u57502\u8def\u8f66\u5230\u6865\u5357\uff0c\u9014\u4e2d\u88ab\u4e8c\u540d\u7537\u5b50\u6252\u7a83\u73b0\u91d13100\u5143\u3002\u4e00\u540d\u88ab\u5f53\u573a\u6293\u83b7\uff0c\u53e6\u4e00\u540d\u5df2\u9003\u8d70\u3002 ";
        System.out.println(StringUtil.getHandleString(maxlength, replace, false, false, outStr));
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, File file) throws Exception {
        ServletOutputStream out = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            out = response.getOutputStream();
            long fileSize = raf.length();
            long rangeStart = 0L;
            long rangeFinish = fileSize - 1L;
            String range = request.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                String pureRange = range.replaceAll("bytes=", "");
                int rangeSep = pureRange.indexOf("-");
                try {
                    rangeStart = Long.parseLong(pureRange.substring(0, rangeSep));
                    if (rangeStart > fileSize || rangeStart < 0L) {
                        rangeStart = 0L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (rangeSep < pureRange.length() - 1) {
                    try {
                        rangeFinish = Long.parseLong(pureRange.substring(rangeSep + 1));
                        if (rangeFinish < 0L || rangeFinish >= fileSize) {
                            rangeFinish = fileSize - 1L;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            String name = StringUtil.handleCNName(file.getName(), request);
            response.setHeader("Content-Disposition", "attachment; filename=" + name);
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Length", Long.toString(rangeFinish - rangeStart + 1L));
            response.setHeader("Content-Range", "bytes " + rangeStart + "-" + rangeFinish + "/" + fileSize);
            raf.seek(rangeStart);
            byte[] buffer = new byte[1024];
            int totalRead = 0;
            boolean nomore = false;
            do {
                long len;
                if ((len = (long)raf.read(buffer)) > 0L && (long)totalRead + len > rangeFinish - rangeStart + 1L) {
                    len = rangeFinish - rangeStart + 1L - (long)totalRead;
                    nomore = true;
                }
                if (len <= 0L) break;
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            } while (!nomore);
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                raf.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String filename, Blob blob) throws Exception {
        if (blob == null) {
            return;
        }
        StringUtil.sendFile_(request, response, filename, blob.getBinaryStream(), blob.length());
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String filename, InputStream stream) throws Exception {
        if (stream == null) {
            return;
        }
        StringUtil.sendFile_(request, response, filename, stream);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String filename, Clob clob) throws Exception {
        if (clob == null) {
            return;
        }
        StringUtil.sendFile_(request, response, filename, clob.getAsciiStream(), clob.length());
    }

    public static boolean isIE(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        boolean isie = agent != null ? agent.contains("MSIE ") : false;
        return isie;
    }

    public static boolean isIE6(HttpServletRequest request) {
        String clientInfo = request.getHeader("User-Agent");
        if (clientInfo == null) {
            return false;
        }
        return clientInfo.indexOf("MSIE 6") > 0 || clientInfo.indexOf("MSIE 5") > 0;
    }

    public static String handleCNName(String name, HttpServletRequest request) throws UnsupportedEncodingException {
        String agent = request.getHeader("User-Agent");
        boolean isie = agent != null ? agent.contains("MSIE ") : false;
        name = isie ? URLEncoder.encode(name.replaceAll(" ", "-"), "UTF-8") : new String(name.getBytes(), "ISO-8859-1").replaceAll(" ", "-");
        return name;
    }

    public static void sendFile_(HttpServletRequest request, HttpServletResponse response, Resource in) throws Exception {
        try {
            StringUtil.sendFile_(request, response, in.getFilename(), in.getInputStream());
        }
        finally {
            in.release();
        }
    }

    public static void sendFile_(HttpServletRequest request, HttpServletResponse response, String filename, InputStream in) throws Exception {
        ServletOutputStream out = null;
        try {
            long len;
            if (in == null) {
                return;
            }
            out = response.getOutputStream();
            String name = StringUtil.handleCNName(filename, request);
            response.setContentType("Application");
            response.setHeader("Content-Disposition", "attachment; filename=" + name);
            byte[] buffer = new byte[1024];
            int totalRead = 0;
            while ((len = (long)in.read(buffer)) > 0L) {
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void showFile(HttpServletRequest request, HttpServletResponse response, String filename, InputStream in) throws Exception {
        ServletOutputStream out = null;
        try {
            long len;
            if (in == null) {
                return;
            }
            out = response.getOutputStream();
            String name = StringUtil.handleCNName(filename, request);
            response.setContentType(FileUtil.getMimeTypeByleName(name));
            response.setHeader("Content-Disposition", "inline; filename=" + name);
            byte[] buffer = new byte[1024];
            int totalRead = 0;
            while ((len = (long)in.read(buffer)) > 0L) {
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void showFile(HttpServletRequest request, HttpServletResponse response, File file) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        ServletOutputStream out = null;
        InputStream in = null;
        String filename = file.getName();
        try {
            long len;
            out = response.getOutputStream();
            in = new BufferedInputStream(new FileInputStream(file));
            String name = StringUtil.handleCNName(filename, request);
            response.setContentType(FileUtil.getMimeTypeByleName(name));
            response.setHeader("Content-Disposition", "inline; filename=" + name);
            byte[] buffer = new byte[1024];
            int totalRead = 0;
            while ((len = (long)in.read(buffer)) > 0L) {
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void showFile(HttpServletRequest request, HttpServletResponse response, String filename, Blob blob) throws Exception {
        if (blob == null) {
            return;
        }
        ServletOutputStream out = null;
        InputStream in = null;
        try {
            long len;
            out = response.getOutputStream();
            in = new BufferedInputStream(blob.getBinaryStream());
            String name = StringUtil.handleCNName(filename, request);
            response.setContentType(FileUtil.getMimeTypeByleName(name));
            response.setHeader("Content-Disposition", "inline; filename=" + name);
            byte[] buffer = new byte[1024];
            int totalRead = 0;
            while ((len = (long)in.read(buffer)) > 0L) {
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void sendFile_(HttpServletRequest request, HttpServletResponse response, String filename, InputStream in, long fileSize) throws Exception {
        ServletOutputStream out = null;
        try {
            if (in == null) {
                return;
            }
            out = response.getOutputStream();
            long rangeStart = 0L;
            long rangeFinish = fileSize - 1L;
            String range = request.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                String pureRange = range.replaceAll("bytes=", "");
                int rangeSep = pureRange.indexOf("-");
                try {
                    rangeStart = Long.parseLong(pureRange.substring(0, rangeSep));
                    if (rangeStart > fileSize || rangeStart < 0L) {
                        rangeStart = 0L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (rangeSep < pureRange.length() - 1) {
                    try {
                        rangeFinish = Long.parseLong(pureRange.substring(rangeSep + 1));
                        if (rangeFinish < 0L || rangeFinish >= fileSize) {
                            rangeFinish = fileSize - 1L;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            String name = StringUtil.handleCNName(filename, request);
            response.setHeader("Content-Disposition", "attachment; filename=" + name);
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Length", Long.toString(rangeFinish - rangeStart + 1L));
            response.setHeader("Content-Range", "bytes " + rangeStart + "-" + rangeFinish + "/" + fileSize);
            byte[] buffer = new byte[1024];
            in.skip(rangeStart);
            int totalRead = 0;
            boolean nomore = false;
            do {
                long len;
                if ((len = (long)in.read(buffer)) > 0L && (long)totalRead + len > rangeFinish - rangeStart + 1L) {
                    len = rangeFinish - rangeStart + 1L - (long)totalRead;
                    nomore = true;
                }
                if (len <= 0L) break;
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            } while (!nomore);
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getClientIP(HttpServletRequest request) {
        return StringUtil.getClientIP(realIpHeaders, request);
    }

    public static String getClientIP(String[] realIpHeaders, HttpServletRequest request) {
        if (realIpHeaders == null) {
            realIpHeaders = StringUtil.realIpHeaders;
        }
        String ip = null;
        for (int i = 0; i < realIpHeaders.length && ((ip = request.getHeader(realIpHeaders[i])) == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)); ++i) {
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        } else {
            String[] temp = ip.split(",");
            if (logger.isDebugEnabled()) {
                logger.debug("ip from client:" + ip);
            }
            ip = temp[0];
        }
        return ip;
    }

    static {
        try {
            httpOnlyMethod = Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

