/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.velocity;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.app.VelocityEngine;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.util.VelocityUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class BBossVelocityUtil {
    private static VelocityEngine dbEngine;
    private static VelocityEngine elasticEngine;
    private static Map<String, VelocityEngine> velocityEngineMap;

    public static VelocityContext buildVelocityContext(Map<String, Object> context) {
        return VelocityUtil.buildVelocityContext(context);
    }

    public static String evaluate(Map context, String templateName, String template) {
        return VelocityUtil.evaluate(context, templateName, template);
    }

    public static void init(String approot) {
        VelocityUtil.init(approot);
    }

    public static void initTemplate(Resource template) {
        VelocityUtil.initTemplate(template);
    }

    public static void initTemplate(Resource template, String encoding) {
        VelocityUtil.initTemplate(template, encoding);
    }

    public static void initDBTemplate(Resource template) {
        BBossVelocityUtil.initDBEngine();
        dbEngine.initTemplate(template);
    }

    public static void initDBTemplate(Resource template, String encoding) {
        BBossVelocityUtil.initDBEngine();
        dbEngine.initTemplate(template, encoding);
    }

    public static void initElasticTemplate(Resource template) {
        BBossVelocityUtil.initElasticEngine();
        elasticEngine.initTemplate(template);
    }

    public static void initElasticTemplate(Resource template, String encoding) {
        BBossVelocityUtil.initElasticEngine();
        elasticEngine.initTemplate(template, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VelocityEngine getVelocityEngine(String configFile) {
        VelocityEngine velocityEngine = velocityEngineMap.get(configFile);
        if (velocityEngine != null) {
            return velocityEngine;
        }
        Map<String, VelocityEngine> map = velocityEngineMap;
        synchronized (map) {
            velocityEngine = velocityEngineMap.get(configFile);
            if (velocityEngine == null) {
                velocityEngine = VelocityUtil.initVelocityEngine(configFile);
                velocityEngineMap.put(configFile, velocityEngine);
            }
        }
        return velocityEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initElasticEngine() {
        if (elasticEngine != null) return;
        Class<BBossVelocityUtil> clazz = BBossVelocityUtil.class;
        synchronized (BBossVelocityUtil.class) {
            if (elasticEngine != null) return;
            elasticEngine = VelocityUtil.initVelocityEngine("/bboss-elasticvelocity.properties");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initDBEngine() {
        if (dbEngine != null) return;
        Class<BBossVelocityUtil> clazz = BBossVelocityUtil.class;
        synchronized (BBossVelocityUtil.class) {
            if (dbEngine != null) return;
            dbEngine = VelocityUtil.initVelocityEngine("/bboss-dbvelocity.properties");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String evaluateDB(Map context, String templateName, String template) {
        BBossVelocityUtil.initDBEngine();
        StringWriter out = new StringWriter();
        try {
            dbEngine.evaluate((Context)BBossVelocityUtil.buildVelocityContext(context), (Writer)out, templateName, template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return template;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return template;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return template;
        }
        catch (Exception e) {
            e.printStackTrace();
            return template;
        }
        return out.toString();
    }

    public static String evaluateElastic(Map context, String templateName, String template) {
        BBossVelocityUtil.initElasticEngine();
        StringWriter out = new StringWriter();
        try {
            elasticEngine.evaluate((Context)BBossVelocityUtil.buildVelocityContext(context), (Writer)out, templateName, template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return template;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return template;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return template;
        }
        catch (Exception e) {
            e.printStackTrace();
            return template;
        }
        return out.toString();
    }

    static {
        velocityEngineMap = new HashMap<String, VelocityEngine>();
    }
}

