/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.frameworkset.util.i18n.DefaultI18N;
import org.frameworkset.util.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class I18NUtil {
    private static Logger log = LoggerFactory.getLogger(I18NUtil.class);
    private static I18n i18n;

    public static void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        i18n.setLocale(request, response, locale);
    }

    public static void setLocale(HttpServletRequest request, HttpServletResponse response, String locale) {
        i18n.setLocale(request, response, locale);
    }

    public static Locale getRequestContextLocal(HttpServletRequest request) {
        return i18n.getRequestContextLocal(request);
    }

    public static String getRequestContextLocalCode(HttpServletRequest request) {
        return i18n.getRequestContextLocalCode(request);
    }

    public static String getI18nMessage(String code, HttpServletRequest request) {
        return i18n.getI18nMessage(code, request);
    }

    public static String getI18nMessage(String code, String defaultMessage, HttpServletRequest request) {
        return i18n.getI18nMessage(code, defaultMessage, request);
    }

    public static String getI18nMessage(String code, String defaultMessage) {
        return i18n.getI18nMessage(code, null, defaultMessage, null);
    }

    public static String getI18nMessage(String code) {
        return i18n.getI18nMessage(code, null, null, null);
    }

    public static String getI18nMessage(String code, Object[] args, HttpServletRequest request) {
        return i18n.getI18nMessage(code, args, null, request);
    }

    public static String getI18nMessage(String code, Object[] args) {
        return i18n.getI18nMessage(code, args, (String)null);
    }

    public static String getI18nMessage(String code, Object[] args, String defaultMessage) {
        return i18n.getI18nMessage(code, args, defaultMessage, null);
    }

    public static String getI18nMessage(String code, Object[] args, String defaultMessage, HttpServletRequest request) {
        return i18n.getI18nMessage(code, args, defaultMessage, request);
    }

    static {
        try {
            i18n = (I18n)Class.forName("org.frameworkset.web.servlet.i18n.I18nImpl").newInstance();
        }
        catch (Exception e) {
            log.warn("class org.frameworkset.web.servlet.i18n.I18nImpl not found in classpath,use DefaultI18N. ");
            i18n = new DefaultI18N();
        }
    }
}

