/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.frameworkset.util.SystemPropertyUtils;

public class TimeUtil {
    public static boolean enablePersistentLocalDate = false;

    public static TimeUnit getTimeUnitByName(String timeUnit, TimeUnit defaultTimeUnit) {
        TimeUnit timeUnit_ = TimeUnit.SECONDS;
        if (timeUnit.equals("TimeUnit.SECONDS")) {
            timeUnit_ = TimeUnit.SECONDS;
        } else if (timeUnit.equals("TimeUnit.DAYS")) {
            try {
                timeUnit_ = TimeUnit.valueOf("DAYS");
            }
            catch (Exception e) {
                timeUnit_ = defaultTimeUnit;
            }
        }
        if (timeUnit.equals("TimeUnit.HOURS")) {
            try {
                timeUnit_ = TimeUnit.valueOf("HOURS");
            }
            catch (Exception e) {
                timeUnit_ = defaultTimeUnit;
            }
        } else if (timeUnit.equals("TimeUnit.MICROSECONDS")) {
            timeUnit_ = TimeUnit.MICROSECONDS;
        } else if (timeUnit.equals("TimeUnit.MILLISECONDS")) {
            timeUnit_ = TimeUnit.MILLISECONDS;
        } else if (timeUnit.equals("TimeUnit.MINUTES")) {
            try {
                timeUnit_ = TimeUnit.valueOf("MINUTES");
            }
            catch (Exception e) {
                timeUnit_ = defaultTimeUnit;
            }
        } else if (timeUnit.equals("TimeUnit.NANOSECONDS")) {
            timeUnit_ = TimeUnit.NANOSECONDS;
        }
        return timeUnit_;
    }

    public static Object convertLocalDatetime(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        if (enablePersistentLocalDate) {
            return localDateTime;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        Instant instant = zonedDateTime.toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static Object convertLocalDate(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        if (enablePersistentLocalDate) {
            return localDate;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Object convertLocalDate(Object localDate) {
        if (null == localDate) {
            return null;
        }
        if (localDate instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)localDate);
        }
        if (localDate instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)localDate);
        }
        return localDate;
    }

    public static TimeUnit getTimeUnit(String timeUnit, TimeUnit defaultUnit) {
        TimeUnit timeUnit_ = TimeUnit.SECONDS;
        try {
            timeUnit_ = TimeUnit.valueOf(timeUnit);
        }
        catch (Exception e) {
            timeUnit_ = defaultUnit;
        }
        return timeUnit_;
    }

    public static Date addDates(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date addDateSeconds(Date date, int seconds) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, seconds);
        return c.getTime();
    }

    public static Date addDateMonths(Date date, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, months);
        return c.getTime();
    }

    public static Date addDateHours(Date date, int hours) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(10, hours);
        return c.getTime();
    }

    public static Date addDateMinitues(Date date, int Minitues) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, Minitues);
        return c.getTime();
    }

    public static Date addDateYears(Date date, int years) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        return c.getTime();
    }

    static {
        String _enablePersistentLocalDate = SystemPropertyUtils.getEnvironmentVariableValue("enablePersistentLocalDate");
        if (_enablePersistentLocalDate != null && _enablePersistentLocalDate.equalsIgnoreCase("true")) {
            enablePersistentLocalDate = true;
        }
    }
}

