/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.util.introspection;

import bboss.org.apache.velocity.runtime.RuntimeLogger;
import bboss.org.apache.velocity.runtime.log.Log;
import bboss.org.apache.velocity.runtime.log.RuntimeLoggerLog;
import bboss.org.apache.velocity.util.introspection.IntrospectorBase;
import bboss.org.apache.velocity.util.introspection.MethodMap;
import java.lang.reflect.Method;

public class Introspector
extends IntrospectorBase {
    public Introspector(Log log) {
        super(log);
    }

    public Introspector(RuntimeLogger logger) {
        this(new RuntimeLoggerLog(logger));
    }

    @Override
    public Method getMethod(Class c, String name, Object[] params) throws IllegalArgumentException {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuilder msg = new StringBuilder("Introspection Error : Ambiguous method invocation ").append(name).append("(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                if (params[i] == null) {
                    msg.append("null");
                    continue;
                }
                msg.append(params[i].getClass().getName());
            }
            msg.append(") for class ").append(c);
            this.log.debug(msg.toString());
            return null;
        }
    }
}

